/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.backup.rdbms;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.services.database.utils.ExceptionManagementHelper;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.security.JCRRuntimePermissions;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectReader;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.DataRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.RestoreTableRule;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleaner;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ObjectReaderImpl;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ObjectZipReaderImpl;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;
import org.exoplatform.services.jcr.impl.storage.jdbc.DialectDetecter;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBRestore
implements DataRestore {
    private final int MAXIMUM_BATCH_SIZE = 1000;
    private final List<File> spoolFileList = new ArrayList<File>();
    private final FileCleaner fileCleaner;
    private final File tempDir = new File(PrivilegedSystemHelper.getProperty((String)"java.io.tmpdir"));
    private final int maxBufferSize;
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.DBRestor");
    protected final Connection jdbcConn;
    private final File storageDir;
    protected final Map<String, RestoreTableRule> tables;
    private final DBCleaner dbCleaner;
    protected final String dialect;
    protected List<String> successfulExecuted;

    public DBRestore(File storageDir, Connection jdbcConn, Map<String, RestoreTableRule> tables, WorkspaceEntry wsConfig, FileCleaner fileCleaner, DBCleaner dbCleaner) throws NamingException, SQLException, RepositoryConfigurationException {
        this.jdbcConn = jdbcConn;
        this.fileCleaner = fileCleaner;
        this.maxBufferSize = wsConfig.getContainer().getParameterInteger("max-buffer-size", 204800);
        this.storageDir = storageDir;
        this.tables = tables;
        this.dbCleaner = dbCleaner;
        this.dialect = DialectDetecter.detect(jdbcConn.getMetaData());
    }

    @Override
    public void clean() throws BackupException {
        try {
            this.dbCleaner.executeCleanScripts();
        }
        catch (SQLException e) {
            throw new BackupException(e);
        }
    }

    @Override
    public void restore() throws BackupException {
        try {
            for (Map.Entry<String, RestoreTableRule> entry : this.tables.entrySet()) {
                String tableName = entry.getKey();
                RestoreTableRule restoreRule = entry.getValue();
                this.restoreTable(this.storageDir, this.jdbcConn, tableName, restoreRule);
            }
        }
        catch (IOException e) {
            throw new BackupException(e);
        }
        catch (SQLException e) {
            throw new BackupException("SQL Exception: " + ExceptionManagementHelper.getFullSQLExceptionMessage((SQLException)e), e);
        }
    }

    @Override
    public void commit() throws BackupException {
        try {
            try {
                this.dbCleaner.executeCommitScripts();
            }
            catch (Exception e) {
                LOG.error((Object)"Can't remove temporary objects after cleaning", (Throwable)e);
            }
            this.jdbcConn.commit();
        }
        catch (SQLException e) {
            throw new BackupException(e);
        }
    }

    @Override
    public void rollback() throws BackupException {
        try {
            this.jdbcConn.rollback();
            this.dbCleaner.executeRollbackScripts();
            this.jdbcConn.commit();
        }
        catch (SQLException e) {
            throw new BackupException(e);
        }
    }

    @Override
    public void close() throws BackupException {
        try {
            if (!this.jdbcConn.isClosed()) {
                this.jdbcConn.close();
            }
        }
        catch (SQLException e) {
            throw new BackupException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreTable(File storageDir, Connection jdbcConn, String tableName, RestoreTableRule restoreRule) throws IOException, SQLException {
        ResultSet tableMetaData;
        Statement insertNode;
        ObjectReaderImpl contentLenReader;
        block56: {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkPermission(JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
            }
            ObjectReaderImpl contentReader = null;
            contentLenReader = null;
            insertNode = null;
            tableMetaData = null;
            if (this.dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_PGSQL)) {
                tableName = tableName.toLowerCase();
            }
            try {
                File contentLenFile;
                File contentFile = new File(storageDir, restoreRule.getSrcTableName() + ".dump");
                if (PrivilegedFileHelper.exists((File)contentFile)) {
                    contentReader = new ObjectZipReaderImpl(PrivilegedFileHelper.zipInputStream((File)contentFile));
                    ((ObjectZipReaderImpl)contentReader).getNextEntry();
                    contentLenFile = new File(storageDir, restoreRule.getSrcTableName() + ".len");
                    contentLenReader = new ObjectZipReaderImpl(PrivilegedFileHelper.zipInputStream((File)contentLenFile));
                    ((ObjectZipReaderImpl)contentLenReader).getNextEntry();
                } else {
                    contentFile = new File(storageDir, "dump.zip");
                    contentReader = new ObjectZipReaderImpl(PrivilegedFileHelper.zipInputStream((File)contentFile));
                    while (!((ObjectZipReaderImpl)contentReader).getNextEntry().getName().equals(restoreRule.getSrcTableName())) {
                    }
                    contentLenFile = new File(storageDir, "dump-len.zip");
                    contentLenReader = new ObjectZipReaderImpl(PrivilegedFileHelper.zipInputStream((File)contentLenFile));
                    while (!((ObjectZipReaderImpl)contentLenReader).getNextEntry().getName().equals(restoreRule.getSrcTableName())) {
                    }
                }
                int sourceColumnCount = contentReader.readInt();
                ArrayList<Integer> columnType = new ArrayList<Integer>();
                ArrayList<String> columnName = new ArrayList<String>();
                for (int i = 0; i < sourceColumnCount; ++i) {
                    columnType.add(contentReader.readInt());
                    columnName.add(contentReader.readString());
                }
                int targetColumnCount = sourceColumnCount;
                if (restoreRule.getDeleteColumnIndex() != null) {
                    --targetColumnCount;
                } else if (restoreRule.getNewColumnIndex() != null) {
                    ++targetColumnCount;
                    columnType.add(restoreRule.getNewColumnIndex(), restoreRule.getNewColumnType());
                    String newColumnName = this.dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_PGSQL) ? restoreRule.getNewColumnName().toLowerCase() : restoreRule.getNewColumnName();
                    columnName.add(restoreRule.getNewColumnIndex(), newColumnName);
                }
                String names = "";
                String parameters = "";
                for (int i = 0; i < targetColumnCount; ++i) {
                    if (restoreRule.getSkipColumnIndex() != null && restoreRule.getSkipColumnIndex() == i) continue;
                    names = names + (String)columnName.get(i) + (i == targetColumnCount - 1 ? "" : ",");
                    parameters = parameters + "?" + (i == targetColumnCount - 1 ? "" : ",");
                }
                int batchSize = 0;
                insertNode = jdbcConn.prepareStatement("INSERT INTO " + tableName + " (" + names + ") VALUES(" + parameters + ")");
                block10: while (true) {
                    int i = 0;
                    int targetIndex = 0;
                    while (i < columnType.size()) {
                        long len;
                        ByteArrayInputStream stream;
                        if (restoreRule.getNewColumnIndex() != null && restoreRule.getNewColumnIndex() == i) {
                            stream = new ByteArrayInputStream(restoreRule.getDstContainerName().getBytes("UTF-8"));
                            len = stream.available();
                        } else {
                            try {
                                len = contentLenReader.readLong();
                            }
                            catch (EOFException e) {
                                if (i == 0) {
                                    try {
                                        contentReader.readByte();
                                    }
                                    catch (EOFException e1) {
                                        break block10;
                                    }
                                }
                                throw new IOException("Content length file is empty but content still present", e);
                            }
                            InputStream inputStream = stream = len == -1L ? null : this.spoolInputStream(contentReader, len);
                        }
                        if (restoreRule.getSkipColumnIndex() != null && restoreRule.getSkipColumnIndex() == i) {
                            --targetIndex;
                        } else if (restoreRule.getDeleteColumnIndex() != null && restoreRule.getDeleteColumnIndex() == i) {
                            --targetIndex;
                        } else if (stream != null) {
                            String value;
                            byte[] readBuffer;
                            ByteArrayInputStream ba;
                            if (restoreRule.getConvertColumnIndex() != null && restoreRule.getConvertColumnIndex().contains(i)) {
                                StringBuilder builder;
                                ba = stream;
                                readBuffer = new byte[ba.available()];
                                ba.read(readBuffer);
                                String currentValue = new String(readBuffer, "UTF-8");
                                if (currentValue.equals(Constants.ROOT_PARENT_UUID)) {
                                    stream = new ByteArrayInputStream(Constants.ROOT_PARENT_UUID.getBytes());
                                } else if (restoreRule.getDstMultiDb().booleanValue()) {
                                    if (!restoreRule.getSrcMultiDb().booleanValue()) {
                                        stream = new ByteArrayInputStream(new String(readBuffer, "UTF-8").substring(restoreRule.getSrcContainerName().length()).getBytes());
                                    }
                                } else if (restoreRule.getSrcMultiDb().booleanValue()) {
                                    builder = new StringBuilder();
                                    builder.append(restoreRule.getDstContainerName());
                                    builder.append(currentValue);
                                    stream = new ByteArrayInputStream(builder.toString().getBytes());
                                } else {
                                    builder = new StringBuilder();
                                    builder.append(restoreRule.getDstContainerName());
                                    builder.append(new String(readBuffer, "UTF-8").substring(restoreRule.getSrcContainerName().length()));
                                    stream = new ByteArrayInputStream(builder.toString().getBytes());
                                }
                                len = stream.available();
                            }
                            if ((Integer)columnType.get(i) == 4 || (Integer)columnType.get(i) == -5 || (Integer)columnType.get(i) == 5 || (Integer)columnType.get(i) == -6) {
                                ba = stream;
                                readBuffer = new byte[ba.available()];
                                ba.read(readBuffer);
                                value = new String(readBuffer, "UTF-8");
                                insertNode.setLong(targetIndex + 1, Integer.parseInt(value));
                            } else if ((Integer)columnType.get(i) == -7) {
                                ba = stream;
                                readBuffer = new byte[ba.available()];
                                ba.read(readBuffer);
                                value = new String(readBuffer);
                                if (this.dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_PGSQL)) {
                                    insertNode.setBoolean(targetIndex + 1, value.equalsIgnoreCase("t"));
                                } else {
                                    insertNode.setBoolean(targetIndex + 1, value.equals("1"));
                                }
                            } else if ((Integer)columnType.get(i) == 16) {
                                ba = stream;
                                readBuffer = new byte[ba.available()];
                                ba.read(readBuffer);
                                value = new String(readBuffer);
                                insertNode.setBoolean(targetIndex + 1, value.equalsIgnoreCase("true"));
                            } else if ((Integer)columnType.get(i) == -3 || (Integer)columnType.get(i) == -4 || (Integer)columnType.get(i) == 2004 || (Integer)columnType.get(i) == -2 || (Integer)columnType.get(i) == 1111) {
                                insertNode.setBinaryStream(targetIndex + 1, stream, (int)len);
                            } else {
                                byte[] readBuffer2 = new byte[(int)len];
                                stream.read(readBuffer2);
                                insertNode.setString(targetIndex + 1, new String(readBuffer2, "UTF-8"));
                            }
                        } else {
                            insertNode.setNull(targetIndex + 1, (Integer)columnType.get(i));
                        }
                        ++i;
                        ++targetIndex;
                    }
                    insertNode.addBatch();
                    if (++batchSize != 1000) continue;
                    insertNode.executeBatch();
                    this.commitBatch();
                    batchSize = 0;
                }
                if (batchSize != 0) {
                    insertNode.executeBatch();
                    this.commitBatch();
                }
                Object var28_29 = null;
                if (contentReader == null) break block56;
            }
            catch (Throwable throwable) {
                Object var28_30 = null;
                if (contentReader != null) {
                    contentReader.close();
                }
                if (contentLenReader != null) {
                    contentLenReader.close();
                }
                if (insertNode != null) {
                    insertNode.close();
                }
                for (File file : this.spoolFileList) {
                    if (PrivilegedFileHelper.delete((File)file)) continue;
                    this.fileCleaner.addFile(file);
                }
                if (tableMetaData != null) {
                    tableMetaData.close();
                }
                throw throwable;
            }
            contentReader.close();
        }
        if (contentLenReader != null) {
            contentLenReader.close();
        }
        if (insertNode != null) {
            insertNode.close();
        }
        for (File file : this.spoolFileList) {
            if (PrivilegedFileHelper.delete((File)file)) continue;
            this.fileCleaner.addFile(file);
        }
        if (tableMetaData != null) {
            tableMetaData.close();
        }
    }

    protected void commitBatch() throws SQLException {
        if (this.dialect.equalsIgnoreCase(DBConstants.DB_DIALECT_SYBASE)) {
            this.jdbcConn.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream spoolInputStream(ObjectReader in, long contentLen) throws IOException {
        FileInputStream fileInputStream;
        File sf;
        block13: {
            OutputStream sfout;
            block11: {
                ByteArrayInputStream byteArrayInputStream;
                block12: {
                    byte[] buffer = new byte[]{};
                    long readLen = 0L;
                    sf = null;
                    sfout = null;
                    try {
                        while (true) {
                            int needToRead = contentLen - readLen > 2048L ? 2048 : (int)(contentLen - readLen);
                            byte[] tmpBuff = new byte[needToRead];
                            if (needToRead == 0) break;
                            in.readFully(tmpBuff);
                            if (sfout != null) {
                                sfout.write(tmpBuff);
                            } else if (readLen + (long)needToRead > (long)this.maxBufferSize && this.fileCleaner != null) {
                                sf = PrivilegedFileHelper.createTempFile((String)"jcrvd", null, (File)this.tempDir);
                                sfout = PrivilegedFileHelper.fileOutputStream((File)sf);
                                sfout.write(buffer);
                                sfout.write(tmpBuff);
                                buffer = null;
                            } else {
                                byte[] newBuffer = new byte[(int)(readLen + (long)needToRead)];
                                System.arraycopy(buffer, 0, newBuffer, 0, (int)readLen);
                                System.arraycopy(tmpBuff, 0, newBuffer, (int)readLen, needToRead);
                                buffer = newBuffer;
                            }
                            readLen += (long)needToRead;
                        }
                        if (buffer == null) break block11;
                        byteArrayInputStream = new ByteArrayInputStream(buffer);
                        Object var13_12 = null;
                        if (sfout == null) break block12;
                    }
                    catch (Throwable throwable) {
                        block14: {
                            Object var13_14 = null;
                            if (sfout != null) {
                                sfout.close();
                            }
                            if (sf == null) break block14;
                            this.spoolFileList.add(sf);
                        }
                        throw throwable;
                    }
                    sfout.close();
                }
                if (sf != null) {
                    this.spoolFileList.add(sf);
                }
                return byteArrayInputStream;
            }
            fileInputStream = PrivilegedFileHelper.fileInputStream(sf);
            Object var13_13 = null;
            if (sfout == null) break block13;
            sfout.close();
        }
        if (sf != null) {
            this.spoolFileList.add(sf);
        }
        return fileInputStream;
    }
}

