/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.application.portlet;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.portlet.PortletURL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.Parameter;
import org.exoplatform.web.application.URLBuilder;
import org.exoplatform.webui.core.UIComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletURLBuilder
extends URLBuilder<UIComponent> {
    private static Log log = ExoLogger.getLogger(PortletURLBuilder.class);
    private final PortletURL url;

    public PortletURLBuilder(PortletURL url) {
        this.url = url;
    }

    public String createAjaxURL(UIComponent targetComponent, String action, String confirm, String targetBeanId, Parameter[] params) {
        return this.createURL(true, confirm, targetComponent, action, targetBeanId, true, params);
    }

    public String createURL(UIComponent targetComponent, String action, String confirm, String targetBeanId, Parameter[] params) {
        return this.createURL(false, confirm, targetComponent, action, targetBeanId, true, params);
    }

    private String createURL(boolean ajax, String confirm, UIComponent targetComponent, String action, String targetBeanId, boolean escapeXML, Parameter[] params) {
        this.url.getParameterMap().clear();
        this.url.setProperty("gtn:ajax", Boolean.toString(ajax));
        this.url.setProperty("gtn:confirm", confirm);
        this.url.setParameter("uicomponent", targetComponent.getId());
        if (action != null && action.trim().length() > 0) {
            this.url.setParameter("op", action);
        }
        if (targetBeanId != null && targetBeanId.trim().length() > 0) {
            this.url.setParameter("objectId", targetBeanId);
        }
        if (params != null && params.length > 0) {
            for (Parameter param : params) {
                this.url.setParameter(param.getName(), param.getValue());
            }
        }
        if (this.removeLocale) {
            this.url.setProperty("gtn:lang", "");
        } else if (this.locale != null) {
            this.url.setProperty("gtn:lang", this.locale.toString());
        }
        if (escapeXML) {
            StringWriter w = new StringWriter();
            try {
                this.url.write((Writer)w, true);
            }
            catch (IOException e) {
                log.error((Object)"Error in create URL process", (Throwable)e);
            }
            return ((Object)w).toString();
        }
        return this.url.toString();
    }
}

