/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.checker;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.checker.AbstractInconsistencyRepair;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.WorkspaceStorageConnectionFactory;

public class NodeRemover
extends AbstractInconsistencyRepair {
    private final NodeTypeDataManager nodeTypeManager;

    public NodeRemover(WorkspaceStorageConnectionFactory connFactory, NodeTypeDataManager nodeTypeManager) {
        super(connFactory);
        this.nodeTypeManager = nodeTypeManager;
    }

    void repairRow(JDBCStorageConnection conn, ResultSet resultSet) throws SQLException {
        try {
            String parentId = this.exctractId(resultSet, "PARENT_ID");
            InternalQName nodeName = InternalQName.parse(resultSet.getString("NAME"));
            NodeData parent = (NodeData)conn.getItemData(parentId);
            NodeDefinitionData def = this.nodeTypeManager.getChildNodeDefinition(nodeName, parent.getPrimaryTypeName(), parent.getMixinTypeNames());
            if (def != null && !def.isResidualSet()) {
                throw new SQLException("Node is required by its parent.");
            }
            String nodeId = this.exctractId(resultSet, "ID");
            int orderNum = resultSet.getInt("N_ORDER_NUM");
            int version = resultSet.getInt("VERSION");
            QPath path = QPath.makeChildPath(parent.getQPath(), this.extractName(resultSet));
            TransientNodeData data = new TransientNodeData(path, nodeId, version, null, null, orderNum, "00exo0jcr0root0uuid0000000000000", null);
            this.deleteTree(conn, data);
        }
        catch (IllegalStateException e) {
            throw new SQLException(e);
        }
        catch (RepositoryException e) {
            throw new SQLException(e);
        }
        catch (IllegalNameException e) {
            throw new SQLException(e);
        }
    }

    private void deleteTree(JDBCStorageConnection conn, NodeData data) throws IllegalStateException, RepositoryException {
        for (NodeData child : conn.getChildNodesData(data)) {
            this.deleteTree(conn, child);
        }
        for (PropertyData prop : conn.getChildPropertiesData(data)) {
            conn.delete(prop);
        }
        conn.delete(data);
    }
}

