/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet.profile;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletRequest;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.social.core.identity.IdentityManager;
import org.exoplatform.social.core.identity.ProfileMapper;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.portlet.profile.UIProfile;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIContainer;

public abstract class UIProfileSection
extends UIContainer {
    private boolean isEditMode;
    private boolean isMultipart = false;
    private String currentProperty;
    private ProfileMapper profilemapper;

    public Profile getProfile() throws Exception {
        UIProfile pp = (UIProfile)this.getAncestorOfType(UIProfile.class);
        return pp.getProfile();
    }

    public boolean isEditMode() {
        return this.isEditMode;
    }

    public void setEditMode(boolean editMode) {
        this.isEditMode = editMode;
    }

    public boolean isEditable() {
        UIProfile pp = (UIProfile)this.getAncestorOfType(UIProfile.class);
        return pp.isEditable();
    }

    public boolean isMultipart() {
        return this.isMultipart;
    }

    public void setMultipart(boolean multipart) {
        this.isMultipart = multipart;
    }

    public String getCurrentProperty() {
        return this.currentProperty;
    }

    public void setCurrentProperty(String currentProperty) {
        this.currentProperty = currentProperty;
    }

    public void processDecode(WebuiRequestContext context) throws Exception {
        Map params = ((PortletRequest)context.getRequest()).getParameterMap();
        for (String paramkey : params.keySet()) {
            String[] values;
            for (String value : values = ((PortletRequest)context.getRequest()).getParameterValues(paramkey)) {
                System.out.println("profile: " + paramkey + "=" + value);
            }
        }
        if (params.get("op") != null && "Save".equals(((String[])params.get("op"))[0])) {
            System.out.println("going to save");
            HashMap<String, String[]> profileInfo = new HashMap<String, String[]>();
            Profile p = this.getProfile();
            for (String paramkey : params.keySet()) {
                if (!paramkey.startsWith("profile.")) continue;
                String name = paramkey.substring(8);
                String[] values = ((PortletRequest)context.getRequest()).getParameterValues(paramkey);
                profileInfo.put(name, values);
                System.out.println("profile: " + name + "=" + profileInfo.get(name));
            }
            this.getProfileMapper().copy(profileInfo, p);
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            IdentityManager im = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
            im.saveProfile(p);
        }
        super.processDecode(context);
    }

    protected void beginEditMode(Writer writer) throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        String b = context.getURLBuilder().createURL((Object)this, null, null);
        writer.append("<form class=\"UIForm\" name=\"form_").append(this.getId()).append("\" id=\"form_").append(this.getId()).append("\" action=\"").append(b).append("\" onSubmit=\"").append(this.eventSubmit("Save")).append(";return false;\"");
        if (this.isMultipart) {
            writer.append(" enctype=\"multipart/form-data\"");
        }
        writer.append(" method=\"post\">");
        writer.append("<input type=\"hidden\" name=\"op\" value=\"\"/>");
    }

    protected void endEditMode(Writer writer) throws IOException {
        writer.write("</form>");
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        context.getJavascriptManager().addOnLoadJavascript((CharSequence)("eXo.social.profile.UIProfileSection.initForm(\"" + this.getId() + "\")"));
    }

    protected void begin(Writer writer) throws IOException {
        writer.append("<div id=\"").append(this.getId()).append("\" class=\"UIProfileSection\">");
    }

    protected void end(Writer writer) throws IOException {
        writer.write("</div>");
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        Writer writer = context.getWriter();
        this.begin(writer);
        if (this.isEditMode()) {
            this.beginEditMode(writer);
        }
        super.processRender(context);
        if (this.isEditMode()) {
            this.endEditMode(writer);
        }
        this.end(writer);
    }

    public String eventSubmit(String name) throws Exception {
        StringBuilder b = new StringBuilder();
        b.append("javascript:eXo.social.profile.UIProfileSection.submitForm('").append(this.getId()).append("', '").append(name).append("')");
        return b.toString();
    }

    private ProfileMapper getProfileMapper() {
        if (this.profilemapper == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            this.profilemapper = (ProfileMapper)container.getComponentInstanceOfType(ProfileMapper.class);
        }
        return this.profilemapper;
    }
}

