/*
 * Decompiled with CFR 0.152.
 */
package social.portal.webui.component;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.social.space.Space;
import org.exoplatform.social.space.SpaceUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import social.portal.webui.component.UISpaceApplication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/portal/webui/uiform/UISpaceApplication.gtmpl", events={@EventConfig(listeners={AddApplicationActionListener.class}), @EventConfig(listeners={RemoveApplicationActionListener.class})})
public class UISpaceApplication
extends UIForm {
    private Space space_;
    private UIPageIterator iterator_;
    private final String iteratorID = "UIIteratorSpaceApplication";

    public UISpaceApplication() throws Exception {
        this.addChild(UIPopupContainer.class, null, "UIPopupAddApp");
        this.iterator_ = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UIIteratorSpaceApplication");
        this.addChild((UIComponent)this.iterator_);
    }

    public List<Application> getApplications() throws Exception {
        return this.iterator_.getCurrentPageData();
    }

    public void setValue(Space space) throws Exception {
        this.space_ = space;
        ArrayList<Application> lists = new ArrayList<Application>();
        ArrayList<Application> apps = new ArrayList<Application>();
        String installedApps = space.getApp();
        if (installedApps != null) {
            Map appStore = SpaceUtils.getAppStore((Space)space);
            for (ApplicationCategory category : appStore.keySet()) {
                List appList = (List)appStore.get(category);
                for (Application app : appList) {
                    if (apps.contains(app)) continue;
                    apps.add(app);
                }
            }
            List appLst = SpaceUtils.getAppList();
            Iterator appListItr = appLst.iterator();
            while (appListItr.hasNext()) {
                Application app = (Application)appListItr.next();
                if (!this.isExisted(apps, app)) continue;
                appListItr.remove();
            }
            if (appLst.size() > 0) {
                apps.addAll(appLst);
            }
            if (apps.size() != 0) {
                for (Application app : apps) {
                    String appStatus = SpaceUtils.getAppStatus((Space)space, (String)app.getApplicationName());
                    if (appStatus == null || !appStatus.equals("active") || this.isExisted(lists, app)) continue;
                    lists.add(app);
                }
            }
        }
        ObjectPageList pageList = new ObjectPageList(lists, 3);
        this.iterator_.setPageList((PageList)pageList);
    }

    public UIPageIterator getUIPageIterator() {
        return this.iterator_;
    }

    public boolean isRemovable(String appId) {
        return SpaceUtils.isRemovableApp((Space)this.space_, (String)appId);
    }

    private boolean isExisted(List<Application> appLst, Application app) {
        String appName = app.getApplicationName();
        String existedAppName = null;
        for (Application application : appLst) {
            existedAppName = application.getApplicationName();
            if (!existedAppName.equals(appName)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Space access$000(UISpaceApplication x0) {
        return x0.space_;
    }
}

