/*
 * Decompiled with CFR 0.152.
 */
package social.portal.webui.component.navigation;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.navigation.PageNavigationUtils;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UISocialNavigation
extends UIComponent {
    private boolean useAJAX = true;
    protected PageNode selectedNode_;
    protected Object selectedParent_;

    public UIComponent getViewModeUIComponent() {
        return null;
    }

    public void setUseAjax(boolean bl) {
        this.useAJAX = bl;
    }

    public boolean isUseAjax() {
        return this.useAJAX;
    }

    public List<PageNavigation> getNavigations() throws Exception {
        ArrayList<PageNavigation> result = new ArrayList<PageNavigation>();
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UIPortal uiPortal = Util.getUIPortal();
        int portalNav = ("portal::" + uiPortal.getName()).hashCode();
        PageNavigation portalNavigation = uiPortal.getPageNavigation(portalNav);
        portalNavigation = PageNavigationUtils.filter((PageNavigation)portalNavigation, (String)context.getRemoteUser());
        result.add(portalNavigation);
        return result;
    }

    public PageNavigation getSelectedNavigation() {
        PageNavigation nav = null;
        try {
            nav = Util.getUIPortal().getSelectedNavigation();
            if (nav != null) {
                return nav;
            }
            if (Util.getUIPortal().getNavigations().size() < 1) {
                return null;
            }
            return (PageNavigation)Util.getUIPortal().getNavigations().get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getSelectedParent() {
        return this.selectedParent_;
    }

    public PageNode getSelectedPageNode() {
        try {
            if (this.selectedNode_ != null) {
                return this.selectedNode_;
            }
            this.selectedNode_ = Util.getUIPortal().getSelectedNode();
            return this.selectedNode_;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isSelectedNode(PageNode node) {
        if (this.selectedNode_ != null && node.getUri().equals(this.selectedNode_.getUri())) {
            return true;
        }
        if (this.selectedParent_ == null || this.selectedParent_ instanceof PageNavigation) {
            return false;
        }
        PageNode pageNode = (PageNode)this.selectedParent_;
        return node.getUri().equals(pageNode.getUri());
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        UIPortal uiPortal = Util.getUIPortal();
        if (uiPortal.getSelectedNode() != this.selectedNode_) {
            this.setSelectedPageNode(uiPortal.getSelectedNode());
        }
        super.processRender(context);
    }

    private void setSelectedPageNode(PageNode selectedNode) throws Exception {
        this.selectedNode_ = selectedNode;
        this.selectedParent_ = null;
        String seletctUri = selectedNode.getUri();
        int index = seletctUri.lastIndexOf("/");
        String parentUri = null;
        if (index > 0) {
            parentUri = seletctUri.substring(0, seletctUri.lastIndexOf("/"));
        }
        List pageNavs = this.getNavigations();
        for (PageNavigation pageNav : pageNavs) {
            if (PageNavigationUtils.searchPageNodeByUri((PageNavigation)pageNav, (String)selectedNode.getUri()) == null) continue;
            if (parentUri == null || parentUri.length() < 1) {
                this.selectedParent_ = pageNav;
                break;
            }
            this.selectedParent_ = PageNavigationUtils.searchPageNodeByUri((PageNavigation)pageNav, (String)parentUri);
            break;
        }
    }
}

