/*
 * Decompiled with CFR 0.152.
 */
package social.portal.webui.component.space;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.social.core.identity.IdentityManager;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.identity.model.ProfileAttachment;
import org.exoplatform.social.space.Space;
import org.exoplatform.social.space.SpaceException;
import org.exoplatform.social.space.SpaceService;
import org.exoplatform.social.space.SpaceUtils;
import org.exoplatform.social.webui.UIProfileUserSearch;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.webui.event.Event;
import social.portal.webui.component.UserListAccess;
import social.portal.webui.component.space.UIUserListPortlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/portal/webui/space/UIUserListPortlet.gtmpl", events={@EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE)})})
public class UIUserListPortlet
extends UIPortletApplication {
    private UIPageIterator iterator_;
    private List<User> memberList;
    private List<User> leaderList;
    private UIPageIterator iteratorLeaders;
    private UIPageIterator iteratorMembers;
    private final String iteratorLeaderID = "UIIteratorLeader";
    private final String iteratorMemberID = "UIIteratorMember";
    private final Integer ITEMS_PER_PAGE = 5;
    private IdentityManager identityManager_ = null;
    private UIProfileUserSearch uiSearchMemberOfSpace = null;
    private List<Identity> identityList;

    public List<Identity> getIdentityList() {
        return this.identityList;
    }

    public void setIdentityList(List<Identity> identityList) {
        this.identityList = identityList;
    }

    public UIUserListPortlet() throws Exception {
        this.initMember();
        this.initLeader();
        this.iterator_ = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, null);
        this.addChild((UIComponent)this.iterator_);
        this.iteratorLeaders = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UIIteratorLeader");
        this.iteratorMembers = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UIIteratorMember");
        this.addChild((UIComponent)this.iteratorLeaders);
        this.addChild((UIComponent)this.iteratorMembers);
        this.uiSearchMemberOfSpace = (UIProfileUserSearch)this.createUIComponent(UIProfileUserSearch.class, null, "UIProfileUserSearch");
        this.addChild((UIComponent)this.uiSearchMemberOfSpace);
    }

    public void setMemberList(List<User> memberList) {
        this.memberList = memberList;
    }

    public void setLeaderList(List<User> leaderList) {
        this.leaderList = leaderList;
    }

    public List<User> getLeaderList() throws Exception {
        this.initLeader();
        return this.leaderList;
    }

    public UIPageIterator getIteratorLeaders() {
        return this.iteratorLeaders;
    }

    public UIPageIterator getIteratorMembers() {
        return this.iteratorMembers;
    }

    public List<User> getLeaders() throws Exception {
        this.initLeader();
        int currentPage = this.iteratorLeaders.getCurrentPage();
        LazyPageList pageList = new LazyPageList((ListAccess)new UserListAccess(this.leaderList), this.ITEMS_PER_PAGE.intValue());
        this.iteratorLeaders.setPageList((PageList)pageList);
        int pageCount = this.iteratorLeaders.getAvailablePage();
        if (pageCount >= currentPage) {
            this.iteratorLeaders.setCurrentPage(currentPage);
        } else if (pageCount < currentPage) {
            this.iteratorLeaders.setCurrentPage(currentPage - 1);
        }
        return this.iteratorLeaders.getCurrentPageData();
    }

    public List<User> getMembers() throws Exception {
        this.initMember();
        UIProfileUserSearch uiSearchMemberOfSpace1 = (UIProfileUserSearch)this.getChild(UIProfileUserSearch.class);
        uiSearchMemberOfSpace1.setAllUserContactName(this.getAllMemberNames());
        int currentPage = this.iteratorMembers.getCurrentPage();
        LazyPageList pageList = new LazyPageList((ListAccess)new UserListAccess(this.memberList), this.ITEMS_PER_PAGE.intValue());
        this.iteratorMembers.setPageList((PageList)pageList);
        int pageCount = this.iteratorMembers.getAvailablePage();
        if (pageCount >= currentPage) {
            this.iteratorMembers.setCurrentPage(currentPage);
        } else if (pageCount < currentPage) {
            this.iteratorMembers.setCurrentPage(currentPage - 1);
        }
        return this.iteratorMembers.getCurrentPageData();
    }

    public String getUserAvatar(String userId) throws Exception {
        Identity identity = this.getIdentityManager().getIdentityByRemoteId("organization", userId);
        Profile profile = identity.getProfile();
        ProfileAttachment attach = (ProfileAttachment)profile.getProperty("avatar");
        if (attach != null) {
            return "/" + this.getPortalName() + "/rest/jcr/" + this.getRepository() + "/" + attach.getWorkspace() + attach.getDataPath() + "/?rnd=" + System.currentTimeMillis();
        }
        return null;
    }

    public Identity getIdentity(String userId) throws Exception {
        Identity identity = this.getIdentityManager().getIdentityByRemoteId("organization", userId);
        if (identity != null) {
            return identity;
        }
        return null;
    }

    public void initMember() throws Exception {
        Space space = this.getSpace();
        this.memberList = new ArrayList();
        OrganizationService orgSrc = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        UserHandler userHandler = orgSrc.getUserHandler();
        ArrayList<String> userNames = spaceService.getMembers(space);
        Iterator itr = userNames.iterator();
        while (itr.hasNext()) {
            String userName = (String)itr.next();
            if (!spaceService.isLeader(space, userName)) continue;
            itr.remove();
        }
        List matchIdentities = this.getIdentityList();
        if (matchIdentities != null) {
            ArrayList<String> searchResultUserNames = new ArrayList<String>();
            String userName = null;
            for (Identity id : matchIdentities) {
                userName = id.getRemoteId();
                if (!userNames.contains(userName)) continue;
                searchResultUserNames.add(userName);
            }
            userNames = searchResultUserNames;
        }
        for (String name : userNames) {
            this.memberList.add(userHandler.findUserByName(name));
        }
    }

    public void initLeader() throws Exception {
        Space space = this.getSpace();
        this.leaderList = new ArrayList();
        OrganizationService orgSrc = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        UserHandler userHandler = orgSrc.getUserHandler();
        List userNames = spaceService.getMembers(space);
        Iterator itr = userNames.iterator();
        while (itr.hasNext()) {
            String userName = (String)itr.next();
            if (spaceService.isLeader(space, userName)) continue;
            itr.remove();
        }
        for (String name : userNames) {
            this.leaderList.add(userHandler.findUserByName(name));
        }
    }

    private void update() throws Exception {
        int n = this.iterator_.getCurrentPage();
        ObjectPageList pageList = new ObjectPageList(this.memberList, this.ITEMS_PER_PAGE.intValue());
        this.iterator_.setPageList((PageList)pageList);
        if (n <= pageList.getAvailablePage()) {
            this.iterator_.setCurrentPage(n);
        }
    }

    public UIPageIterator getUIPageIterator() throws Exception {
        return this.iterator_;
    }

    public Space getSpace() throws SpaceException {
        String spaceUrl = SpaceUtils.getSpaceUrl();
        SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        return spaceService.getSpaceByUrl(spaceUrl);
    }

    public List<User> getUsersInSpace() throws Exception {
        this.update();
        return this.iterator_.getCurrentPageData();
    }

    public String getPath() {
        String nodePath = Util.getPortalRequestContext().getNodePath();
        String uriPath = Util.getPortalRequestContext().getRequestURI();
        return uriPath.replaceAll(nodePath, "");
    }

    public String getMemberships(String userName) throws Exception {
        String memberShip = null;
        OrganizationService orgService = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        MembershipHandler memberShipHandler = orgService.getMembershipHandler();
        Collection memberShips = memberShipHandler.findMembershipsByUserAndGroup(userName, this.getSpace().getGroupId());
        for (Membership aaa : memberShips) {
            if (memberShip == null) {
                memberShip = aaa.getMembershipType();
                continue;
            }
            memberShip = memberShip + "," + aaa.getMembershipType();
        }
        return memberShip;
    }

    private List<String> getAllMemberNames() throws Exception {
        ArrayList<String> allMemberNames = new ArrayList<String>();
        for (User user : this.memberList) {
            allMemberNames.add(user.getFirstName() + " " + user.getLastName());
        }
        return allMemberNames;
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager_ == null) {
            PortalContainer pcontainer = PortalContainer.getInstance();
            this.identityManager_ = (IdentityManager)pcontainer.getComponentInstanceOfType(IdentityManager.class);
        }
        return this.identityManager_;
    }

    private String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    private String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }
}

