/*
 * Decompiled with CFR 0.152.
 */
package social.portal.webui.component;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.social.space.SpaceAttachment;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import social.portal.webui.component.UIAvatarUploadContent;

@ComponentConfig(template="app:/groovy/portal/webui/uiform/UIAvatarUploadContent.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AbortActionListener.class})})
public class UIAvatarUploadContent
extends UIContainer {
    public static final String AVARTAR_PROPERTY = "avatar";
    private SpaceAttachment spaceAttachment;
    private String imageSource;

    public UIAvatarUploadContent() {
    }

    public UIAvatarUploadContent(SpaceAttachment spaceAttachment) throws Exception {
        this.spaceAttachment = spaceAttachment;
        this.setImageSource(spaceAttachment.getImageBytes());
    }

    public SpaceAttachment getSpaceAttachment() {
        return this.spaceAttachment;
    }

    public void setSpaceAttachment(SpaceAttachment spaceAttachment) throws Exception {
        this.spaceAttachment = spaceAttachment;
        this.setImageSource(spaceAttachment.getImageBytes());
    }

    private void setImageSource(byte[] imageBytes) throws Exception {
        if (imageBytes == null || imageBytes.length == 0) {
            return;
        }
        ByteArrayInputStream byteImage = new ByteArrayInputStream(imageBytes);
        DownloadService downloadService = (DownloadService)this.getApplicationComponent(DownloadService.class);
        InputStreamDownloadResource downloadResource = new InputStreamDownloadResource((InputStream)byteImage, "image");
        downloadResource.setDownloadName(this.spaceAttachment.getFileName());
        this.imageSource = downloadService.getDownloadLink(downloadService.addDownloadResource((DownloadResource)downloadResource));
    }

    public String getImageSource() {
        return this.imageSource;
    }
}

