/*
 * Decompiled with CFR 0.152.
 */
package social.portal.webui.component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.exoplatform.application.registry.Application;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.social.space.Space;
import org.exoplatform.social.space.SpaceException;
import org.exoplatform.social.space.SpaceService;
import org.exoplatform.social.space.SpaceUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import social.portal.webui.component.UISpaceApplication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/portal/webui/uiform/UISpaceApplication.gtmpl", events={@EventConfig(listeners={AddApplicationActionListener.class}), @EventConfig(listeners={RemoveApplicationActionListener.class})})
public class UISpaceApplication
extends UIForm {
    private Space space;
    private UIPageIterator iterator;
    private final String iteratorID = "UIIteratorSpaceApplication";

    public UISpaceApplication() throws Exception {
        this.addChild(UIPopupContainer.class, null, "UIPopupAddApp");
        this.iterator = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UIIteratorSpaceApplication");
        this.addChild((UIComponent)this.iterator);
    }

    public List<Application> getApplications() throws Exception {
        return this.iterator.getCurrentPageData();
    }

    public void setValue(Space space) throws Exception {
        this.space = space;
        List appIdList = SpaceUtils.getAppIdList((Space)space);
        ArrayList notAvailableAppIdList = new ArrayList(appIdList);
        ArrayList<Application> installedAppList = new ArrayList<Application>();
        Map appStore = SpaceUtils.getAppStore((Space)space);
        for (Map.Entry appCategoryEntrySet : appStore.entrySet()) {
            List appList = (List)appCategoryEntrySet.getValue();
            for (Application app : appList) {
                String appStatus;
                if (this.isExisted(installedAppList, app) || !appIdList.contains(app.getApplicationName()) || !(appStatus = SpaceUtils.getAppStatus((Space)space, (String)app.getApplicationName())).equals("active")) continue;
                installedAppList.add(app);
                notAvailableAppIdList.remove(app.getApplicationName());
            }
        }
        for (String appId : notAvailableAppIdList) {
            if (!SpaceUtils.getAppStatus((Space)space, (String)appId).equals("active")) continue;
            installedAppList.add(SpaceUtils.getAppFromPortalContainer((String)appId));
        }
        ObjectPageList pageList = new ObjectPageList(installedAppList, 3);
        this.iterator.setPageList((PageList)pageList);
    }

    public UIPageIterator getUIPageIterator() {
        return this.iterator;
    }

    public boolean isRemovable(String appId) {
        return SpaceUtils.isRemovableApp((Space)this.space, (String)appId);
    }

    public String getAppName(Application application) throws SpaceException {
        String spaceUrl = SpaceUtils.getSpaceUrl();
        SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        Space space = spaceService.getSpaceByUrl(spaceUrl);
        if (space == null) {
            return null;
        }
        PageNavigation pageNav = null;
        try {
            pageNav = SpaceUtils.getGroupNavigation((String)space.getGroupId());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        PageNode homeNode = SpaceUtils.getHomeNode((PageNavigation)pageNav, (String)spaceUrl);
        if (homeNode == null) {
            return null;
        }
        List nodes = homeNode.getChildren();
        String installedApp = space.getApp();
        String[] appStatuses = installedApp.split(",");
        String applicationName = application.getApplicationName();
        for (String appStatus : appStatuses) {
            String[] appParts;
            if (appStatus.length() == 0 || !(appParts = appStatus.split(":"))[0].equals(applicationName)) continue;
            for (PageNode node : nodes) {
                String nodeUri = node.getUri();
                String appNodeName = nodeUri.substring(nodeUri.indexOf("/") + 1);
                if (!appNodeName.equals(appParts[1])) continue;
                return node.getResolvedLabel();
            }
        }
        return application.getDisplayName();
    }

    private boolean isExisted(List<Application> appList, Application app) {
        String appName = app.getApplicationName();
        String existedAppName = null;
        for (Application application : appList) {
            existedAppName = application.getApplicationName();
            if (!existedAppName.equals(appName)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Space access$000(UISpaceApplication x0) {
        return x0.space;
    }
}

