/*
 * Decompiled with CFR 0.152.
 */
package social.portal.webui.component;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activitystream.ActivityManager;
import org.exoplatform.social.core.activitystream.model.Activity;
import org.exoplatform.social.core.identity.IdentityManager;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.space.Space;
import org.exoplatform.social.space.SpaceException;
import org.exoplatform.social.space.SpaceService;
import org.exoplatform.social.space.SpaceUtils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.json.JSONException;
import org.json.JSONObject;
import social.portal.webui.component.UIActivity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app://groovy/portal/webui/component/UIActivity.gtmpl", events={@EventConfig(listeners={ToggleDisplayLikesActionListener.class}), @EventConfig(listeners={ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={LikeActivityActionListener.class}), @EventConfig(listeners={SetCommentListStatusActionListener.class}), @EventConfig(listeners={PostCommentActionListener.class})})
public class UIActivity
extends UIForm {
    private static final Log LOG = ExoLogger.getLogger(UIActivity.class);
    public static int LATEST_COMMENTS_SIZE = 2;
    private int commentMinCharactersAllowed_ = 0;
    private int commentMaxCharactersAllowed_ = 0;
    private JSONObject dataBody_;
    private Activity activity_;
    private List<Activity> comments_;
    private String[] identityLikes_;
    private ActivityManager activityManager_;
    private IdentityManager identityManager_;
    private boolean commentFormDisplayed_ = false;
    private boolean likesDisplayed_ = false;
    private Status commentListStatus_ = Status.LATEST;
    private boolean allCommentsHidden_ = false;
    private boolean commentFormFocused_ = false;

    public UIActivity() throws Exception {
        this.setSubmitAction("return false;");
    }

    public UIActivity setActivity(Activity activity) {
        this.activity_ = activity;
        if (this.activity_ == null) {
            LOG.warn((Object)"activity_ is null!");
        }
        this.init();
        return this;
    }

    public Activity getActivity() {
        return this.activity_;
    }

    public void setCommentMinCharactersAllowed(int num) {
        this.commentMinCharactersAllowed_ = num;
    }

    public int getCommentMinCharactersAllowed() {
        return this.commentMinCharactersAllowed_;
    }

    public void setCommentMaxCharactersAllowed(int num) {
        this.commentMaxCharactersAllowed_ = num;
    }

    public int getCommentMaxCharactersAllowed() {
        return this.commentMaxCharactersAllowed_;
    }

    public void setCommentFormDisplayed(boolean commentFormDisplayed) {
        this.commentFormDisplayed_ = commentFormDisplayed;
    }

    public boolean isCommentFormDisplayed() {
        return this.commentFormDisplayed_;
    }

    public void setLikesDisplayed(boolean likesDisplayed) {
        this.likesDisplayed_ = likesDisplayed;
    }

    public boolean isLikesDisplayed() {
        return this.likesDisplayed_;
    }

    public void setAllCommentsHidden(boolean allCommentsHidden) {
        this.allCommentsHidden_ = allCommentsHidden;
    }

    public boolean isAllCommentsHidden() {
        return this.allCommentsHidden_;
    }

    public void setCommentFormFocused(boolean commentFormFocused) {
        this.commentFormFocused_ = commentFormFocused;
    }

    public boolean isCommentFormFocused() {
        return this.commentFormFocused_;
    }

    public void setCommentListStatus(Status status) {
        this.commentListStatus_ = status;
        if (status == Status.ALL) {
            this.commentFormDisplayed_ = true;
        }
    }

    public Status getCommentListStatus() {
        return this.commentListStatus_;
    }

    public boolean commentListToggleable() {
        return this.comments_.size() > LATEST_COMMENTS_SIZE;
    }

    public List<Activity> getComments() {
        if (this.commentListStatus_ == Status.ALL) {
            return this.comments_;
        }
        if (this.commentListStatus_ == Status.NONE) {
            return new ArrayList<Activity>();
        }
        int commentsSize = this.comments_.size();
        if (commentsSize > LATEST_COMMENTS_SIZE) {
            return this.comments_.subList(commentsSize - LATEST_COMMENTS_SIZE, commentsSize);
        }
        return this.comments_;
    }

    public List<Activity> getAllComments() {
        return this.comments_;
    }

    public String[] getIdentityLikes() {
        return this.identityLikes_;
    }

    public String[] getDisplayedIdentityLikes() throws Exception {
        this.identityManager_ = this.getIdentityManager();
        Identity userIdentity = this.identityManager_.getOrCreateIdentity("organization", this.getRemoteUser());
        if (this.isLiked()) {
            return (String[])ArrayUtils.removeElement((Object[])this.identityLikes_, (Object)userIdentity.getId());
        }
        return this.identityLikes_;
    }

    public void setIdenityLikes(String[] identityLikes) {
        this.identityLikes_ = identityLikes;
    }

    public String getUserFullName(String userIdentityId) throws Exception {
        this.identityManager_ = this.getIdentityManager();
        Identity userIdentity = this.identityManager_.getIdentity(userIdentityId, true);
        if (userIdentity == null) {
            return null;
        }
        Profile userProfile = userIdentity.getProfile();
        return userProfile.getFullName();
    }

    public String getUserProfileUri(String userIdentityId) throws Exception {
        this.identityManager_ = this.getIdentityManager();
        Identity userIdentity = this.identityManager_.getIdentity(userIdentityId, true);
        if (userIdentity == null) {
            return null;
        }
        return "/" + PortalContainer.getCurrentPortalContainerName() + "/private/classic/activities/" + userIdentity.getRemoteId();
    }

    public String getUserAvatarImageSource(String userIdentityId) throws Exception {
        Identity userIdentity = this.identityManager_.getIdentity(userIdentityId, true);
        if (userIdentity == null) {
            return null;
        }
        Profile userProfile = userIdentity.getProfile();
        return userProfile.getAvatarImageSource(PortalContainer.getInstance());
    }

    public boolean isSpaceActivity(String remoteId) throws Exception {
        this.identityManager_ = this.getIdentityManager();
        Identity spaceIdentity = this.identityManager_.getIdentity("space", remoteId, false);
        return spaceIdentity != null;
    }

    public Space getSpace() throws SpaceException {
        SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        return spaceService.getSpaceByUrl(SpaceUtils.getSpaceUrl());
    }

    public String event(String name, String callback, boolean updateForm) throws Exception {
        if (updateForm) {
            return super.url(name);
        }
        StringBuilder b = new StringBuilder();
        b.append("javascript:eXo.social.webui.UIForm.submitForm('").append(this.getFormId()).append("','");
        b.append(name).append("',");
        b.append(callback).append(",");
        b.append("true").append(")");
        return b.toString();
    }

    public boolean hasAttachedExtension() {
        try {
            this.dataBody_ = new JSONObject(this.activity_.getBody());
            return true;
        }
        catch (JSONException je) {
            return false;
        }
    }

    public String getAttachedExtensionType() throws JSONException {
        if (this.dataBody_ != null) {
            return this.dataBody_.getString("extension");
        }
        return null;
    }

    public String getLinkTitle() throws JSONException {
        if (this.dataBody_ != null) {
            return ((JSONObject)this.dataBody_.get("data")).getString("title");
        }
        return "";
    }

    public String getLinkImage() throws JSONException {
        if (this.dataBody_ != null) {
            return ((JSONObject)this.dataBody_.get("data")).getString("image");
        }
        return "";
    }

    public String getLinkSource() throws JSONException {
        if (this.dataBody_ != null) {
            return ((JSONObject)this.dataBody_.get("data")).getString("link");
        }
        return "";
    }

    public String getLinkComment() throws JSONException {
        if (this.dataBody_ != null) {
            return this.dataBody_.getString("comment");
        }
        return "";
    }

    public String getLinkDescription() throws JSONException {
        if (this.dataBody_ != null) {
            return ((JSONObject)this.dataBody_.get("data")).getString("description");
        }
        return "";
    }

    public String toPrettyTime(long postedTime) {
        long time = (new Date().getTime() - postedTime) / 1000L;
        long value = 0L;
        if (time < 60L) {
            return "less than a minute ago";
        }
        if (time < 120L) {
            return "about a minute ago";
        }
        if (time < 3600L) {
            value = Math.round(time / 60L);
            return "about " + value + " minutes ago";
        }
        if (time < 7200L) {
            return "about an hour ago";
        }
        if (time < 86400L) {
            value = Math.round(time / 3600L);
            return "about " + value + " hours ago";
        }
        if (time < 172800L) {
            return "about a day ago";
        }
        if (time < 2592000L) {
            value = Math.round(time / 86400L);
            return "about " + value + " days ago";
        }
        if (time < 5184000L) {
            return "about a month ago";
        }
        value = Math.round(time / 2592000L);
        return "about " + value + " months ago";
    }

    private String getFormId() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (context instanceof PortletRequestContext) {
            return ((PortletRequestContext)context).getWindowId() + "#" + this.getId();
        }
        return this.getId();
    }

    private void init() {
        this.addChild((UIComponent)new UIFormTextAreaInput("CommentTextarea" + this.activity_.getId(), "CommentTextarea", null));
        if (this.activity_ != null) {
            this.activityManager_ = this.getActivityManager();
            this.comments_ = this.activityManager_.getComments(this.activity_);
            this.identityLikes_ = this.activity_.getLikeIdentityIds();
        }
    }

    private void saveComment(String remoteUser, String message) throws Exception {
        this.activityManager_ = this.getActivityManager();
        this.identityManager_ = this.getIdentityManager();
        Identity userIdentity = this.identityManager_.getOrCreateIdentity("organization", remoteUser);
        Activity comment = new Activity(userIdentity.getId(), "exosocial:spaces", remoteUser, message);
        this.activityManager_.saveComment(this.getActivity(), comment);
        this.comments_ = this.activityManager_.getComments(this.getActivity());
        this.setCommentListStatus(Status.ALL);
    }

    private void setLike(boolean isLiked, String remoteUser) throws Exception {
        this.activityManager_ = this.getActivityManager();
        this.identityManager_ = this.getIdentityManager();
        Identity userIdentity = this.identityManager_.getOrCreateIdentity("organization", remoteUser);
        if (isLiked) {
            this.activityManager_.saveLike(this.activity_, userIdentity);
        } else {
            this.activityManager_.removeLike(this.activity_, userIdentity);
        }
        this.activity_ = this.activityManager_.getActivity(this.activity_.getId());
        this.setIdenityLikes(this.activity_.getLikeIdentityIds());
    }

    public boolean isLiked() throws Exception {
        this.identityManager_ = this.getIdentityManager();
        return ArrayUtils.contains((Object[])this.identityLikes_, (Object)this.identityManager_.getOrCreateIdentity("organization", this.getRemoteUser()).getId());
    }

    private void refresh() {
        this.activityManager_ = this.getActivityManager();
        this.activity_ = this.activityManager_.getActivity(this.activity_.getId());
        if (this.activity_ == null) {
            LOG.info((Object)"activity_ is null, not found. It can be deleted!");
            return;
        }
        this.comments_ = this.activityManager_.getComments(this.activity_);
        this.identityLikes_ = this.activity_.getLikeIdentityIds();
    }

    private String getRemoteUser() {
        PortalRequestContext requestContext = Util.getPortalRequestContext();
        return requestContext.getRemoteUser();
    }

    private ActivityManager getActivityManager() {
        return (ActivityManager)this.getApplicationComponent(ActivityManager.class);
    }

    private IdentityManager getIdentityManager() {
        return (IdentityManager)this.getApplicationComponent(IdentityManager.class);
    }

    static /* synthetic */ void access$000(UIActivity x0) {
        x0.refresh();
    }

    static /* synthetic */ void access$100(UIActivity x0, boolean x1, String x2) throws Exception {
        x0.setLike(x1, x2);
    }

    static /* synthetic */ void access$200(UIActivity x0, String x1, String x2) throws Exception {
        x0.saveComment(x1, x2);
    }
}

