/*
 * Decompiled with CFR 0.152.
 */
package social.portal.webui.component.space;

import javax.portlet.PortletRequest;
import org.exoplatform.dashboard.webui.component.DashboardParent;
import org.exoplatform.dashboard.webui.component.UIDashboard;
import org.exoplatform.social.space.Space;
import org.exoplatform.social.space.SpaceService;
import org.exoplatform.social.space.SpaceUtils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/portal/webui/space/UIHomeSpacePortlet.gtmpl")
public class UIHomeSpacePortlet
extends UIPortletApplication
implements DashboardParent {
    private String DEFAULT_TEMPLATE = "home-spaces";
    private String DEFAULT_RSSFETCH_ID = "rssFetch";

    public UIHomeSpacePortlet() throws Exception {
        UIDashboard uiDashboard = (UIDashboard)this.addChild(UIDashboard.class, null, null);
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequest prequest = context.getRequest();
        String template = prequest.getPreferences().getValue("template", this.DEFAULT_TEMPLATE);
        String rssFetchId = prequest.getPreferences().getValue("aggregatorId", this.DEFAULT_RSSFETCH_ID);
        uiDashboard.setContainerTemplate(template);
        uiDashboard.setAggregatorId(rssFetchId);
    }

    public boolean canEdit() {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        String remoteUser = context.getRemoteUser();
        String spaceUrl = SpaceUtils.getSpaceUrl();
        SpaceService spaceSrc = (SpaceService)this.getApplicationComponent(SpaceService.class);
        try {
            Space space = spaceSrc.getSpaceByUrl(spaceUrl);
            return spaceSrc.hasEditPermission(space, remoteUser);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getDashboardOwner() {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return context.getRemoteUser();
    }
}

