/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet;

import javax.servlet.http.HttpServletRequest;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.webui.URLUtils;
import org.exoplatform.social.webui.composer.PopupContainer;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.social.webui.profile.UIUserActivitiesDisplay;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupMessages;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/social/portlet/UIUserActivityStreamPortlet.gtmpl")
public class UIUserActivityStreamPortlet
extends UIPortletApplication {
    private static final Log LOG = ExoLogger.getLogger(UIUserActivityStreamPortlet.class);
    private String ownerName;
    private String viewerName = PortalRequestContext.getCurrentInstance().getRemoteUser();
    private UIComposer uiComposer;
    private PopupContainer hiddenContainer;
    private boolean composerDisplayed = false;
    UIUserActivitiesDisplay uiUserActivitiesDisplay;

    public UIUserActivityStreamPortlet() throws Exception {
        this.ownerName = URLUtils.getCurrentUser();
        if (this.ownerName == null) {
            this.ownerName = this.viewerName;
        }
        this.hiddenContainer = (PopupContainer)this.addChild(PopupContainer.class, null, "HiddenContainer");
        this.uiComposer = (UIComposer)this.addChild(UIComposer.class, null, null);
        this.uiComposer.setPostContext(UIComposer.PostContext.USER);
        this.uiComposer.setOptionContainer((UIContainer)this.hiddenContainer);
        this.uiUserActivitiesDisplay = (UIUserActivitiesDisplay)this.addChild(UIUserActivitiesDisplay.class, null, "UIUserActivitiesDisplay");
        this.uiComposer.setActivityDisplay((UIContainer)this.uiUserActivitiesDisplay);
    }

    public boolean isComposerDisplayed() {
        return this.composerDisplayed;
    }

    public void refresh() throws Exception {
        this.viewerName = PortalRequestContext.getCurrentInstance().getRemoteUser();
        this.ownerName = URLUtils.getCurrentUser();
        if (this.ownerName == null) {
            this.ownerName = this.viewerName;
        }
        if (this.viewerName.equals(this.ownerName)) {
            this.uiComposer.isActivityStreamOwner(true);
            this.uiComposer.setRendered(true);
        } else {
            this.uiComposer.isActivityStreamOwner(false);
            IdentityManager identityManager = (IdentityManager)this.getApplicationComponent(IdentityManager.class);
            RelationshipManager relationshipManager = (RelationshipManager)this.getApplicationComponent(RelationshipManager.class);
            Identity ownerIdentity = identityManager.getOrCreateIdentity("organization", this.ownerName);
            Identity viewerIdentity = identityManager.getOrCreateIdentity("organization", this.viewerName);
            Relationship relationship = relationshipManager.getRelationship(ownerIdentity, viewerIdentity);
            if (relationship != null && relationship.getStatus() == Relationship.Type.CONFIRM) {
                this.uiComposer.setRendered(true);
            } else {
                this.uiComposer.setRendered(false);
            }
        }
        this.uiUserActivitiesDisplay.setOwnerName(this.ownerName);
    }

    public final boolean isTitleDisplayed() {
        String activities = "/activities";
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        HttpServletRequest request = portalRequestContext.getRequest();
        String str = request.getRequestURL().toString();
        return str.contains("/activities");
    }

    protected void renderPopupMessages() throws Exception {
        UIPopupMessages popupMess = this.getUIPopupMessages();
        if (popupMess == null) {
            return;
        }
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        popupMess.processRender(context);
    }
}

