/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet;

import javax.portlet.PortletRequest;
import org.exoplatform.dashboard.webui.component.DashboardParent;
import org.exoplatform.dashboard.webui.component.UIDashboard;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/social/portlet/UIHomeSpacePortlet.gtmpl")
public class UIHomeSpacePortlet
extends UIPortletApplication
implements DashboardParent {
    private String DEFAULT_TEMPLATE = "home-spaces";
    private String DEFAULT_RSSFETCH_ID = "rssFetch";

    public UIHomeSpacePortlet() throws Exception {
        UIDashboard uiDashboard = (UIDashboard)this.addChild(UIDashboard.class, null, null);
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequest prequest = context.getRequest();
        String template = prequest.getPreferences().getValue("template", this.DEFAULT_TEMPLATE);
        String rssFetchId = prequest.getPreferences().getValue("aggregatorId", this.DEFAULT_RSSFETCH_ID);
        uiDashboard.setContainerTemplate(template);
        uiDashboard.setAggregatorId(rssFetchId);
    }

    public boolean canEdit() {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        String remoteUser = context.getRemoteUser();
        String spaceUrl = SpaceUtils.getSpaceUrl();
        SpaceService spaceSrc = (SpaceService)this.getApplicationComponent(SpaceService.class);
        try {
            Space space = spaceSrc.getSpaceByUrl(spaceUrl);
            return spaceSrc.hasEditPermission(space, remoteUser);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getDashboardOwner() {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return context.getRemoteUser();
    }
}

