/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.social.space.Space;
import org.exoplatform.social.space.SpaceService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/social/webui/component/UISpaceSearch.gtmpl", events={@EventConfig(listeners={SearchActionListener.class})})
public class UISpaceSearch
extends UIForm {
    public static final String SPACE_SEARCH = "SpaceSearch";
    public static final String SPACE_DESC_SEARCH = "SpaceDescSearch";
    public static final String SEARCH = "Search";
    static final String ALL = "All";
    public static final String DEFAULT_SPACE_NAME_SEARCH = "Space name";
    public static final String DEFAULT_SPACE_DESC_SEARCH = "Description";
    static final String RIGHT_INPUT_PATTERN = "^[\\p{L}][\\p{L}._\\- \\d]+$";
    static final String PREFIX_ADDED_FOR_CHECK = "PrefixAddedForCheck";
    SpaceService spaceService = null;
    private List<Space> spaceList = null;
    String selectedChar = null;
    String spaceNameSearch = null;
    List<String> spaceNameForAutoSuggest = null;

    public String getSpaceNameSearch() {
        return this.spaceNameSearch;
    }

    public void setSpaceNameSearch(String spaceNameSearch) {
        this.spaceNameSearch = spaceNameSearch;
    }

    public List<String> getSpaceNameForAutoSuggest() {
        return this.spaceNameForAutoSuggest;
    }

    public void setSpaceNameForAutoSuggest(List<String> spaceNameForAutoSuggest) {
        this.spaceNameForAutoSuggest = spaceNameForAutoSuggest;
    }

    public void setSpaceList(List<Space> spaceList) {
        this.spaceList = spaceList;
    }

    public List<Space> getSpaceList() throws Exception {
        return this.spaceList;
    }

    public String getSelectedChar() {
        return this.selectedChar;
    }

    public void setSelectedChar(String selectedChar) {
        this.selectedChar = selectedChar;
    }

    public UISpaceSearch() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(SPACE_SEARCH, null, DEFAULT_SPACE_NAME_SEARCH));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(SPACE_DESC_SEARCH, null, DEFAULT_SPACE_DESC_SEARCH));
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchActionListener
    extends EventListener<UISpaceSearch> {
        public void execute(Event<UISpaceSearch> event) throws Exception {
            WebuiRequestContext ctx = event.getRequestContext();
            UISpaceSearch uiSpaceSearch = (UISpaceSearch)((Object)event.getSource());
            String charSearch = ctx.getRequestParameter("objectId");
            SpaceService spaceService = uiSpaceSearch.getSpaceService();
            ResourceBundle resApp = ctx.getApplicationResourceBundle();
            String defaultSpaceName = resApp.getString(uiSpaceSearch.getId() + ".label.SpaceName");
            String spaceName = (String)((UIFormStringInput)uiSpaceSearch.getChildById(UISpaceSearch.SPACE_SEARCH)).getValue();
            String defaultSpaceDesc = resApp.getString(uiSpaceSearch.getId() + ".label.Description");
            String spaceDesc = (String)((UIFormStringInput)uiSpaceSearch.getChildById(UISpaceSearch.SPACE_DESC_SEARCH)).getValue();
            if (spaceName != null) {
                spaceName = spaceName.trim();
            }
            if (spaceDesc != null) {
                spaceDesc = spaceDesc.trim();
            }
            spaceDesc = spaceDesc == null || spaceDesc.length() == 0 || spaceDesc.equals(defaultSpaceDesc) ? null : spaceDesc;
            spaceName = spaceName == null || spaceName.length() == 0 || spaceName.equals(defaultSpaceName) ? "*" : spaceName;
            spaceName = charSearch != null ? charSearch : spaceName;
            String string = spaceName = charSearch != null && UISpaceSearch.ALL.equals(charSearch) ? "" : spaceName;
            if (charSearch != null) {
                ((UIFormStringInput)uiSpaceSearch.getChildById(UISpaceSearch.SPACE_SEARCH)).setValue((Object)defaultSpaceName);
                ((UIFormStringInput)uiSpaceSearch.getChildById(UISpaceSearch.SPACE_DESC_SEARCH)).setValue((Object)defaultSpaceDesc);
            }
            uiSpaceSearch.setSelectedChar(charSearch);
            if (charSearch == null) {
                if (!this.isValidInput(spaceName)) {
                    uiSpaceSearch.setSpaceList(new ArrayList<Space>());
                } else {
                    spaceName = spaceName.charAt(0) != '*' ? "*" + spaceName : spaceName;
                    spaceName = spaceName.charAt(spaceName.length() - 1) != '*' ? (spaceName = spaceName + "*") : spaceName;
                    spaceName = spaceName.indexOf("*") >= 0 ? spaceName.replace("*", ".*") : spaceName;
                    spaceName = spaceName.indexOf("%") >= 0 ? spaceName.replace("%", ".*") : spaceName;
                    List spacesSearchByName = spaceService.getSpacesByName(spaceName, false);
                    ArrayList<Space> spaceSearchResult = new ArrayList();
                    if (spaceDesc == null) {
                        uiSpaceSearch.setSpaceList(spacesSearchByName);
                    } else {
                        spaceSearchResult = this.filterSpacesByDesc(spacesSearchByName, spaceDesc);
                        uiSpaceSearch.setSpaceList(spaceSearchResult);
                    }
                }
            } else {
                List spaceSearchResult = spaceService.getSpacesByName(spaceName, true);
                uiSpaceSearch.setSpaceList(spaceSearchResult);
            }
            uiSpaceSearch.setSpaceNameSearch(spaceName);
            Event searchEvent = uiSpaceSearch.getParent().createEvent(UISpaceSearch.SEARCH, Event.Phase.DECODE, ctx);
            if (searchEvent != null) {
                searchEvent.broadcast();
            }
        }

        private List<Space> filterSpacesByDesc(List<Space> spacesSearchByName, String spaceDesc) {
            ArrayList<Space> spaces = new ArrayList<Space>();
            String[] spaceDescriptions = spaceDesc.split(" ");
            String exactSearchStr = this.getExactSearchStr(spaceDesc);
            String description = null;
            String descPart = null;
            if (exactSearchStr != null) {
                for (Space space : spacesSearchByName) {
                    description = space.getDescription();
                    if (!description.contains(exactSearchStr) || spaces.contains(space)) continue;
                    spaces.add(space);
                }
                return spaces;
            }
            for (Space space : spacesSearchByName) {
                description = space.getDescription();
                for (int idx = 0; idx < spaceDescriptions.length; ++idx) {
                    descPart = spaceDescriptions[idx];
                    if (!description.contains(descPart) || spaces.contains(space)) continue;
                    spaces.add(space);
                }
            }
            return spaces;
        }

        private String getExactSearchStr(String spaceDesc) {
            int firstIndexOfDQuoter = spaceDesc.indexOf(34);
            int lastIndexOfDQuoter = spaceDesc.lastIndexOf(34);
            int firstIndexOfQuoter = spaceDesc.indexOf("'");
            int lastIndexOfQuoter = spaceDesc.lastIndexOf("'");
            if (firstIndexOfDQuoter != -1 && lastIndexOfDQuoter != -1 && firstIndexOfDQuoter < lastIndexOfDQuoter) {
                return spaceDesc.substring(firstIndexOfDQuoter + 1, lastIndexOfDQuoter - 2);
            }
            if (firstIndexOfQuoter != -1 && lastIndexOfQuoter != -1 && firstIndexOfQuoter < lastIndexOfQuoter) {
                return spaceDesc.substring(firstIndexOfQuoter + 1, lastIndexOfQuoter - 2);
            }
            return null;
        }

        private boolean isValidInput(String input) {
            String spacenameForCheck = input.replace("*", "");
            spacenameForCheck = spacenameForCheck.replace("%", "");
            spacenameForCheck = UISpaceSearch.PREFIX_ADDED_FOR_CHECK + spacenameForCheck;
            return spacenameForCheck.matches(UISpaceSearch.RIGHT_INPUT_PATTERN);
        }
    }
}

