/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.search;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.social.metadata.model.Metadata;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.json.JSONArray;
import org.json.simple.JSONObject;

public class DocumentWithMetadata
extends Document {
    private List<MetadataItem> metadataItems;

    public JSONObject toJsonObject() {
        JSONObject jsonObject = super.toJsonObject();
        if (CollectionUtils.isNotEmpty(this.metadataItems)) {
            JSONObject metadatasJSON = new JSONObject();
            Map metadataItemsByType = this.metadataItems.stream().collect(Collectors.groupingBy(MetadataItem::getMetadataTypeName, Collectors.mapping(Function.identity(), Collectors.toList())));
            Set metadataItemsByTypeEntries = metadataItemsByType.entrySet();
            for (Map.Entry metadataItemsByTypeEntry : metadataItemsByTypeEntries) {
                String metadataTypeName = metadataItemsByTypeEntry.getKey();
                List metadataTypeItems = metadataItemsByTypeEntry.getValue().stream().map(this::toJsonObject).collect(Collectors.toList());
                metadatasJSON.put((Object)metadataTypeName, (Object)new JSONArray(metadataTypeItems));
            }
            jsonObject.put((Object)"metadatas", (Object)metadatasJSON);
        }
        return jsonObject;
    }

    public JSONObject toJsonObject(MetadataItem metadataItem) {
        JSONObject json = new JSONObject();
        json.put((Object)"id", (Object)this.getId());
        Metadata metadata = metadataItem.getMetadata();
        if (metadata != null) {
            json.put((Object)"metadataId", (Object)metadata.getId());
            json.put((Object)"metadataTypeName", (Object)metadata.getTypeName());
            json.put((Object)"metadataCreatorId", (Object)metadata.getCreatorId());
            json.put((Object)"metadataName", (Object)metadata.getName());
            json.put((Object)"audienceId", (Object)metadata.getAudienceId());
        }
        json.put((Object)"creatorId", (Object)metadataItem.getCreatorId());
        json.put((Object)"createdDate", (Object)metadataItem.getCreatedDate());
        if (metadataItem.getParentObjectId() != null) {
            json.put((Object)"parentObjectId", (Object)metadataItem.getParentObjectId());
        }
        if (metadataItem.getObjectId() != null) {
            json.put((Object)"objectId", (Object)metadataItem.getObjectId());
        }
        if (metadataItem.getObjectType() != null) {
            json.put((Object)"objectType", (Object)metadataItem.getObjectType());
        }
        return json;
    }

    public List<MetadataItem> getMetadataItems() {
        return this.metadataItems;
    }

    public void setMetadataItems(List<MetadataItem> metadataItems) {
        this.metadataItems = metadataItems;
    }
}

