/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.profile.ProfileLifeCycle;

public class Profile {
    public static final String GENDER = "gender";
    public static final String MALE = "male";
    public static final String FEMALE = "female";
    public static final String USERNAME = "username";
    public static final String FIRST_NAME = "firstName";
    public static final String LAST_NAME = "lastName";
    public static final String FULL_NAME = "fullName";
    public static final String EMAIL = "email";
    public static final String ABOUT_ME = "aboutMe";
    public static final String TIME_ZONE = "timeZone";
    public static final String TIME_ZONE_DST_SAVINGS = "timeZoneDSTSavings";
    public static final String DELETED = "deleted";
    public static final String AVATAR = "avatar";
    public static final String BANNER = "banner";
    public static final String EXPERIENCES = "experiences";
    public static final String EXPERIENCES_ID = "id";
    public static final String EXPERIENCES_COMPANY = "company";
    public static final String EXPERIENCES_POSITION = "position";
    public static final String EXPERIENCES_SKILLS = "skills";
    public static final String EXPERIENCES_START_DATE = "startDate";
    public static final String EXPERIENCES_END_DATE = "endDate";
    public static final String EXPERIENCES_IS_CURRENT = "isCurrent";
    public static final String EXPERIENCES_DESCRIPTION = "description";
    public static final String POSITION = "position";
    public static final String COMPANY = "company";
    public static final String LOCATION = "location";
    public static final String DEPARTMENT = "department";
    public static final String TEAM = "team";
    public static final String PROFESSION = "profession";
    public static final String COUNTRY = "country";
    public static final String CITY = "city";
    public static final String EXTERNAL = "external";
    public static final String ENROLLMENT_DATE = "enrollmentDate";
    public static final String SYNCHRONIZED_DATE = "synchronizedDate";
    public static final String LAST_LOGIN_TIME = "lastLoginTime";
    @Deprecated
    public static final String URL = "Url";
    public static final String CONTACT_PHONES = "phones";
    public static final String CONTACT_IMS = "ims";
    public static final String CONTACT_URLS = "urls";
    public static final String URL_POSTFIX = "Url";
    public static final String RESIZED_SUBFIX = "RESIZED_";
    private static final String SPACE_STR = " ";
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private static final Map<UpdateType, String[]> updateTypes = new HashMap<UpdateType, String[]>();
    private Identity identity;
    private String id;
    private long lastLoaded;
    private boolean hasChanged;
    private UpdateType updateType;
    private String url;
    private String avatarUrl;
    private String bannerUrl;
    private AttachedActivityType attachedActivityType;
    private long createdTime;
    private List<UpdateType> listUpdateTypes;
    private Long avatarLastUpdated;
    private Long bannerLastUpdated;

    public Profile() {
    }

    public Profile(Identity identity) {
        this.identity = identity;
    }

    public final Identity getIdentity() {
        return this.identity;
    }

    public final void setIdentity(Identity identity) {
        this.identity = identity;
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String id) {
        this.id = id;
    }

    public final long getLastLoaded() {
        return this.lastLoaded;
    }

    public final void setLastLoaded(long lastLoaded) {
        this.lastLoaded = lastLoaded;
    }

    public final boolean hasChanged() {
        return this.hasChanged;
    }

    public final void clearHasChanged() {
        this.setHasChanged(false);
    }

    public UpdateType getUpdateType() {
        return this.updateType;
    }

    public AttachedActivityType getAttachedActivityType() {
        return this.attachedActivityType;
    }

    public void setAttachedActivityType(AttachedActivityType attachedActivityType) {
        this.attachedActivityType = attachedActivityType;
    }

    protected void setUpdateType(String updateType) {
        block0: for (UpdateType key : updateTypes.keySet()) {
            String[] updateTypeValues;
            for (String value : updateTypeValues = updateTypes.get((Object)key)) {
                if (!value.equals(updateType)) continue;
                this.updateType = key;
                continue block0;
            }
        }
    }

    private void setHasChanged(boolean hasChanged) {
        this.hasChanged = hasChanged;
    }

    public final Object getProperty(String name) {
        if ("Url".equals(name)) {
            return this.url;
        }
        return this.properties.get(name);
    }

    public final void setProperty(String name, Object value) {
        if ("Url".equals(name)) {
            this.url = value.toString();
            return;
        }
        this.properties.put(name, value);
        this.setHasChanged(true);
        this.setUpdateType(name);
    }

    public final boolean contains(String name) {
        return this.properties.containsKey(name);
    }

    public final Map<String, Object> getProperties() {
        return this.properties;
    }

    public final void removeProperty(String name) {
        this.properties.remove(name);
        this.setHasChanged(true);
    }

    public final Object getPropertyValue(String name) {
        return this.getProperty(name);
    }

    public final String getFullName() {
        Object fullName = (String)this.getProperty(FULL_NAME);
        if (fullName != null && ((String)fullName).length() > 0) {
            return fullName;
        }
        String firstName = (String)this.getProperty(FIRST_NAME);
        String lastName = (String)this.getProperty(LAST_NAME);
        fullName = firstName != null ? firstName : "";
        fullName = (String)fullName + (String)(lastName != null ? SPACE_STR + lastName : "");
        return fullName;
    }

    public String getSynchronizedDate() {
        return SYNCHRONIZED_DATE;
    }

    public void setSynchronizedDate(String synchronizedDate) {
        this.setProperty(SYNCHRONIZED_DATE, synchronizedDate);
    }

    public final String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public final String getEmail() {
        return (String)this.getProperty(EMAIL);
    }

    public final void addOrModifyProperties(Map<String, Object> props) {
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String key = entry.getKey();
            this.setProperty(key, entry.getValue());
        }
        this.setHasChanged(true);
    }

    @Deprecated
    public final String getAvatarImageSource() {
        return this.getAvatarUrl();
    }

    public final String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public final String getBannerUrl() {
        return this.bannerUrl;
    }

    public void setBannerUrl(String bannerUrl) {
        this.bannerUrl = bannerUrl;
    }

    public final String getPosition() {
        return (String)this.getProperty("position");
    }

    public final String getCompany() {
        return (String)this.getProperty("company");
    }

    public final String getLocation() {
        return (String)this.getProperty(LOCATION);
    }

    public final String getDepartment() {
        return (String)this.getProperty(DEPARTMENT);
    }

    public final String getTeam() {
        return (String)this.getProperty(TEAM);
    }

    public final String getProfession() {
        return (String)this.getProperty(PROFESSION);
    }

    public final String getCountry() {
        return (String)this.getProperty(COUNTRY);
    }

    public final String getCity() {
        return (String)this.getProperty(CITY);
    }

    public String getAboutMe() {
        return (String)this.getProperty(ABOUT_ME);
    }

    public void setAboutMe(String aboutMe) {
        this.setProperty(ABOUT_ME, aboutMe);
    }

    public String getTimeZone() {
        return (String)this.getProperty(TIME_ZONE);
    }

    public void setTimeZone(String timeZone) {
        this.setProperty(TIME_ZONE, timeZone);
    }

    public Integer getTimeZoneDSTSavings() {
        String value = (String)this.getProperty(TIME_ZONE_DST_SAVINGS);
        return value == null ? null : Integer.valueOf(Integer.parseInt(value));
    }

    public void setTimeZoneDSTSavings(Object timeZoneDayLightSaving) {
        this.setProperty(TIME_ZONE_DST_SAVINGS, String.valueOf(timeZoneDayLightSaving == null ? Integer.valueOf(0) : timeZoneDayLightSaving));
    }

    public final String getGender() {
        return (String)this.getProperty(GENDER);
    }

    public final List<Map<String, String>> getPhones() {
        return (List)this.getProperty(CONTACT_PHONES);
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Long createdTime) {
        this.createdTime = createdTime != null ? createdTime : System.currentTimeMillis();
    }

    public final String toString() {
        return "[uuid : " + this.id + " identity : " + this.identity.getId() + " properties: " + String.valueOf(this.properties);
    }

    public List<UpdateType> getListUpdateTypes() {
        return this.listUpdateTypes != null ? this.listUpdateTypes : new ArrayList<UpdateType>();
    }

    public void setListUpdateTypes(List<UpdateType> listUpdateTypes) {
        this.listUpdateTypes = listUpdateTypes;
    }

    public Long getAvatarLastUpdated() {
        return this.avatarLastUpdated;
    }

    public void setAvatarLastUpdated(Long avatarLastUpdated) {
        this.avatarLastUpdated = avatarLastUpdated;
    }

    public Long getBannerLastUpdated() {
        return this.bannerLastUpdated;
    }

    public void setBannerLastUpdated(Long bannerLastUpdated) {
        this.bannerLastUpdated = bannerLastUpdated;
    }

    public Boolean hasAvatar() {
        return this.getAvatarLastUpdated() != null;
    }

    static {
        updateTypes.put(UpdateType.POSITION, new String[]{"position"});
        updateTypes.put(UpdateType.BASIC_INFOR, new String[]{FIRST_NAME, LAST_NAME, EMAIL});
        updateTypes.put(UpdateType.CONTACT, new String[]{GENDER, CONTACT_PHONES, CONTACT_IMS, CONTACT_URLS});
        updateTypes.put(UpdateType.EXPERIENCES, new String[]{EXPERIENCES});
        updateTypes.put(UpdateType.AVATAR, new String[]{AVATAR});
        updateTypes.put(UpdateType.BANNER, new String[]{BANNER});
        updateTypes.put(UpdateType.COMPANY, new String[]{"company"});
        updateTypes.put(UpdateType.LOCATION, new String[]{LOCATION});
        updateTypes.put(UpdateType.DEPARTMENT, new String[]{DEPARTMENT});
        updateTypes.put(UpdateType.PROFESSION, new String[]{PROFESSION});
        updateTypes.put(UpdateType.COUNTRY, new String[]{COUNTRY});
        updateTypes.put(UpdateType.CITY, new String[]{CITY});
        updateTypes.put(UpdateType.TEAM, new String[]{TEAM});
    }

    public static enum UpdateType {
        POSITION,
        COMPANY,
        LOCATION,
        DEPARTMENT,
        TEAM,
        PROFESSION,
        COUNTRY,
        CITY,
        BASIC_INFOR,
        CONTACT,
        EXPERIENCES,
        AVATAR,
        ABOUT_ME,
        BANNER,
        TECHNICAL;


        public void updateActivity(ProfileLifeCycle profileLifeCycle, Profile profile) {
            this.updateActivity(profileLifeCycle, profile, null);
        }

        public void updateActivity(ProfileLifeCycle profileLifeCycle, Profile profile, String modifierUsername) {
            switch (this) {
                case ABOUT_ME: {
                    profileLifeCycle.aboutMeUpdated(profile.getIdentity().remoteId, profile, modifierUsername);
                    break;
                }
                case CONTACT: {
                    profileLifeCycle.contactUpdated(profile.getIdentity().getRemoteId(), profile, modifierUsername);
                    break;
                }
                case EXPERIENCES: {
                    profileLifeCycle.experienceUpdated(profile.getIdentity().getRemoteId(), profile, modifierUsername);
                    break;
                }
                case AVATAR: {
                    profileLifeCycle.avatarUpdated(profile.getIdentity().getRemoteId(), profile, modifierUsername);
                    break;
                }
                case BANNER: {
                    profileLifeCycle.bannerUpdated(profile.getIdentity().getRemoteId(), profile, modifierUsername);
                    break;
                }
                case TECHNICAL: {
                    profileLifeCycle.technicalUpdated(profile.getIdentity().getRemoteId(), profile, modifierUsername);
                    break;
                }
            }
        }
    }

    public static enum AttachedActivityType {
        USER("userProfileActivityId"),
        SPACE("spaceProfileActivityId"),
        RELATION("relationActivityId"),
        RELATIONSHIP("relationShipActivityId");

        private String type;

        private AttachedActivityType(String type) {
            this.type = type;
        }

        public String value() {
            return this.type;
        }
    }
}

