/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.embedder;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.embedder.Embedder;
import org.exoplatform.social.common.embedder.ExoSocialMedia;
import org.json.JSONException;
import org.json.JSONObject;

public class OembedEmbedder
implements Embedder {
    private static final String EMBED_TITLE = "title";
    private static final String EMBED_DESC = "description";
    private static final String EMBED_PROVIDER = "provider_name";
    private static final String EMBED_URL = "url";
    private static final String EMBED_HTML = "html";
    private static final String EMBED_TYPE = "type";
    private Map<Pattern, String> schemeEndpointMap = new HashMap<Pattern, String>();
    private String url;
    private static final Log LOG = ExoLogger.getLogger(OembedEmbedder.class);

    public OembedEmbedder(InitParams initParams) {
        Iterator it = initParams.getValueParamIterator();
        ValueParam valueParam = null;
        while (it.hasNext()) {
            valueParam = (ValueParam)it.next();
            this.schemeEndpointMap.put(Pattern.compile(valueParam.getName()), valueParam.getValue());
        }
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    public ExoSocialMedia getExoSocialMedia(String url) {
        this.setUrl(url);
        return this.getExoSocialMedia();
    }

    @Override
    public ExoSocialMedia getExoSocialMedia() {
        URL urlObj = this.getOembedUrl(this.url);
        if (urlObj == null) {
            return null;
        }
        JSONObject oembedData = this.getOembedData(urlObj);
        if (oembedData == null) {
            return null;
        }
        return this.jsonToExoSocialMedia(oembedData);
    }

    private URL getOembedUrl(String url) {
        try {
            for (Pattern pattern : this.schemeEndpointMap.keySet()) {
                Matcher matcher = pattern.matcher(url);
                if (!matcher.find()) continue;
                String endpoint = this.schemeEndpointMap.get(pattern);
                return new URL(String.format(endpoint, url));
            }
            return null;
        }
        catch (MalformedURLException e) {
            LOG.warn((Object)"Can't get oembed url for oembed request", (Throwable)e);
            return null;
        }
    }

    private JSONObject getOembedData(URL url) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.openStream()));
            StringBuffer stringBuffer = new StringBuffer();
            String eachLine = null;
            while ((eachLine = bufferedReader.readLine()) != null) {
                stringBuffer.append(eachLine);
            }
            bufferedReader.close();
            return new JSONObject(stringBuffer.toString());
        }
        catch (JSONException e) {
            LOG.warn((Object)"Can't get oembed response", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            LOG.warn((Object)"Can't get oembed response", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            LOG.warn((Object)"Can't get oembed response", (Throwable)e);
            return null;
        }
    }

    private ExoSocialMedia jsonToExoSocialMedia(JSONObject jsonObject) {
        ExoSocialMedia mediaObject = new ExoSocialMedia();
        try {
            mediaObject.setTitle(jsonObject.getString(EMBED_TITLE));
            mediaObject.setHtml(jsonObject.getString(EMBED_HTML));
            mediaObject.setType(jsonObject.getString(EMBED_TYPE));
            mediaObject.setProvider(jsonObject.getString(EMBED_PROVIDER));
            mediaObject.setDescription(jsonObject.has(EMBED_DESC) ? jsonObject.getString(EMBED_DESC) : "");
            mediaObject.setUrl(jsonObject.has(EMBED_URL) ? jsonObject.getString(EMBED_URL) : "");
            return mediaObject;
        }
        catch (JSONException e) {
            LOG.warn((Object)"Can't convert JSONObject to ExoSocialMedia object", (Throwable)e);
            return null;
        }
    }
}

