/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.xmlprocessor.model;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;

public class XMLTagFilterPolicy {
    private Set<AllowedTag> allowedTagSet = new HashSet<AllowedTag>();

    public Set<AllowedTag> getAllowedTagSet() {
        return this.allowedTagSet;
    }

    public void setAllowedTagSet(Set<AllowedTag> allowedTagSet) {
        this.allowedTagSet = allowedTagSet;
    }

    public void addAllowedTags(String ... tagNames) {
        for (String tagName : tagNames) {
            if (this.allowedTagSet.contains(tagName)) {
                return;
            }
            AllowedTag allowedTag = new AllowedTag(tagName);
            this.allowedTagSet.add(allowedTag);
        }
    }

    public void addAllowedTag(String tagName, Set<String> tagAttributes) {
        AllowedTag allowedTag = new AllowedTag(tagName, tagAttributes);
        this.addAllowedTag(allowedTag);
    }

    public void addAllowedTag(AllowedTag allowedTag) {
        this.allowedTagSet.add(allowedTag);
    }

    public void removeAllowedTag(AllowedTag allowedTag) {
        this.allowedTagSet.remove(allowedTag);
    }

    public void setAllowedTagPlugin(AllowedTagPlugin allowedTagPlugin) {
        List<AllowedTag> allowedTagList = allowedTagPlugin.getAllowedTagList();
        for (AllowedTag allowedTag : allowedTagList) {
            this.addAllowedTag(allowedTag);
        }
    }

    public static class AllowedTag {
        private String tagName;
        private Set<String> tagAttributes = new HashSet<String>();

        public AllowedTag() {
        }

        public AllowedTag(String tagName) {
            this.tagName = tagName;
        }

        public AllowedTag(String tagName, Set<String> tagAttributes) {
            this.tagName = tagName;
            this.tagAttributes = tagAttributes;
        }

        public String getTagName() {
            return this.tagName;
        }

        public void setTagName(String setTagName) {
            this.tagName = setTagName;
        }

        public void setTagAttributes(Set<String> tagAttributes) {
            this.tagAttributes = tagAttributes;
        }

        public Set<String> getTagAttributes() {
            return this.tagAttributes;
        }
    }

    public static class AllowedTagPlugin
    extends BaseComponentPlugin {
        private List<AllowedTag> allowedTagList;

        public AllowedTagPlugin(InitParams initParams) {
            this.allowedTagList = initParams.getObjectParamValues(AllowedTag.class);
        }

        public List<AllowedTag> getAllowedTagList() {
            return this.allowedTagList;
        }
    }
}

