/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.xmlprocessor;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.common.AbstractCommonTest;
import org.exoplatform.social.common.xmlprocessor.BaseXMLFilterPlugin;
import org.exoplatform.social.common.xmlprocessor.Filter;
import org.exoplatform.social.common.xmlprocessor.XMLProcessor;

public class XMLProcessorTest
extends AbstractCommonTest {
    private XMLProcessor xmlProcessor;
    private PortalContainer portalContainer;
    private List<Filter> tearDownFilter;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.portalContainer = PortalContainer.getInstance();
        this.xmlProcessor = (XMLProcessor)this.portalContainer.getComponentInstanceOfType(XMLProcessor.class);
        this.tearDownFilter = new ArrayList<Filter>();
    }

    public void tearDown() throws Exception {
        for (Filter filter : this.tearDownFilter) {
            this.xmlProcessor.removeFilter(filter);
        }
        super.tearDown();
    }

    public void testShouldReturnNullWhenProcessNullInput() {
        Test1FilterPlugin test1FilterPlugin = new Test1FilterPlugin();
        this.xmlProcessor.addFilter((Filter)test1FilterPlugin);
        this.tearDownFilter.add((Filter)test1FilterPlugin);
        Object processedText = this.xmlProcessor.process(null);
        XMLProcessorTest.assertNull((Object)processedText);
    }

    public void testShouldApplyFilterWhenOneFilterAdded() {
        Test1FilterPlugin test1FilterPlugin = new Test1FilterPlugin();
        this.xmlProcessor.addFilter((Filter)test1FilterPlugin);
        this.tearDownFilter.add((Filter)test1FilterPlugin);
        Object processedText = this.xmlProcessor.process((Object)"test");
        XMLProcessorTest.assertNotNull((Object)processedText);
        XMLProcessorTest.assertEquals((String)"test-test1", (String)((String)processedText));
    }

    public void testShouldApplyFiltersWhenTwoFiltersAdded() {
        Test1FilterPlugin test1FilterPlugin = new Test1FilterPlugin();
        this.xmlProcessor.addFilter((Filter)test1FilterPlugin);
        this.tearDownFilter.add((Filter)test1FilterPlugin);
        Test2FilterPlugin test2FilterPlugin = new Test2FilterPlugin();
        this.xmlProcessor.addFilter((Filter)test2FilterPlugin);
        this.tearDownFilter.add((Filter)test2FilterPlugin);
        Object processedText = this.xmlProcessor.process((Object)"test");
        XMLProcessorTest.assertNotNull((Object)processedText);
        XMLProcessorTest.assertEquals((String)"test-test1-test2", (String)((String)processedText));
    }

    public void testShouldApplyFiltersWhenTwoFiltersAddedAndOneRemoved() {
        Test1FilterPlugin test1FilterPlugin = new Test1FilterPlugin();
        this.xmlProcessor.addFilter((Filter)test1FilterPlugin);
        Test2FilterPlugin test2FilterPlugin = new Test2FilterPlugin();
        this.xmlProcessor.addFilter((Filter)test2FilterPlugin);
        this.tearDownFilter.add((Filter)test2FilterPlugin);
        this.xmlProcessor.removeFilter((Filter)test1FilterPlugin);
        Object processedText = this.xmlProcessor.process((Object)"test");
        XMLProcessorTest.assertNotNull((Object)processedText);
        XMLProcessorTest.assertEquals((String)"test-test2", (String)((String)processedText));
    }

    public void testShouldApplyFiltersByPluginWhenTwoFiltersAddedAndOneRemoved() {
        Test1FilterPlugin test1FilterPlugin = new Test1FilterPlugin();
        this.xmlProcessor.addFilterPlugin((BaseXMLFilterPlugin)test1FilterPlugin);
        Test2FilterPlugin test2FilterPlugin = new Test2FilterPlugin();
        this.xmlProcessor.addFilterPlugin((BaseXMLFilterPlugin)test2FilterPlugin);
        this.tearDownFilter.add((Filter)test2FilterPlugin);
        this.xmlProcessor.removeFilterPlugin((BaseXMLFilterPlugin)test1FilterPlugin);
        Object processedText = this.xmlProcessor.process((Object)"test");
        XMLProcessorTest.assertNotNull((Object)processedText);
        XMLProcessorTest.assertEquals((String)"test-test2", (String)((String)processedText));
    }

    class Test1FilterPlugin
    extends BaseXMLFilterPlugin {
        Test1FilterPlugin() {
        }

        public Object doFilter(Object input) {
            if (input != null) {
                String text = (String)input;
                return text + "-test1";
            }
            return null;
        }
    }

    class Test2FilterPlugin
    extends BaseXMLFilterPlugin {
        Test2FilterPlugin() {
        }

        public Object doFilter(Object input) {
            if (input != null) {
                String text = (String)input;
                return text + "-test2";
            }
            return null;
        }
    }
}

