/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.xmlprocessor.filters;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.xmlprocessor.BaseXMLFilterPlugin;
import org.exoplatform.social.common.xmlprocessor.DOMParser;
import org.exoplatform.social.common.xmlprocessor.Tokenizer;
import org.exoplatform.social.common.xmlprocessor.model.Attributes;
import org.exoplatform.social.common.xmlprocessor.model.Node;

public class URLConverterFilterPlugin
extends BaseXMLFilterPlugin {
    private int urlMaxLength = -1;
    private static final Log LOG = ExoLogger.getLogger(URLConverterFilterPlugin.class);
    private static final Pattern URL_PATTERN = Pattern.compile("(?i)(((?:(?:ht|f)tp(?:s?)\\:\\/\\/)(?:\\w+:\\w+@)?(((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?))))|((?:(?:ht|f)tp(?:s?)\\:\\/\\/)?(?:\\w+:\\w+@)?((?:(?:[-\\w]+\\.)+(?:com|org|net|edu|gov|mil|biz|info|mobi|name|aero|jobs|museum|travel|asia|cat|coop|int|pro|tel|xxx|[a-z]{2}))))|(?:(?:(?:ht|f)tp(?:s?)\\:\\/\\/)(?:\\w+:\\w+@)?(?:[-\\w]+)))(?::[\\d]{1,5})?(?:[\\/|\\?|\\#][^\\s]*)?");
    private static final Pattern HAVE_PROTOCOL_PREFIX = Pattern.compile("(?i)^(?:(?:ht|f)tp(?:s?)).*");
    private static final String DEFAULT_PROTOCOL = "http://";

    public URLConverterFilterPlugin(int urlMaxLength) {
        this.urlMaxLength = urlMaxLength;
    }

    public URLConverterFilterPlugin(InitParams params) {
        try {
            this.urlMaxLength = Integer.valueOf(params.getValueParam("urlMaxLength").getValue());
        }
        catch (Exception e) {
            LOG.warn((Object)("an <value-param> 'urlMaxLength' of type int is needed for this component " + this.getClass()));
        }
    }

    @Override
    public Object doFilter(Object input) {
        if (input instanceof String) {
            return this.convertURL((String)input);
        }
        return input;
    }

    public int getUrlMaxLength() {
        return this.urlMaxLength;
    }

    public void setUrlMaxLength(int urlMaxLength) {
        this.urlMaxLength = urlMaxLength;
    }

    private String convertURL(String xmlString) {
        List<String> xmlTokens = Tokenizer.tokenize(xmlString);
        Node rootNode = DOMParser.createDOMTree(xmlTokens);
        this.nodeFilter(rootNode);
        return rootNode.toString();
    }

    private int nodeFilter(Node currentNode) {
        int insertedCount;
        LinkedList<Node> currentChildNode = currentNode.getChildNodes();
        if (currentNode.getTitle().isEmpty() && (insertedCount = this.convertNode(currentNode)) > 0) {
            return insertedCount;
        }
        for (int i = 0; i < currentChildNode.size(); ++i) {
            int insertedCount2;
            if (currentChildNode.get(i).getTitle().equals("a") || (insertedCount2 = this.nodeFilter(currentChildNode.get(i))) <= 0) continue;
            i = i + insertedCount2 - 1;
        }
        return 0;
    }

    private int convertNode(Node currentNode) {
        String content = StringEscapeUtils.unescapeHtml4((String)currentNode.getContent());
        int insertedCount = 0;
        if (!currentNode.isRootNode()) {
            Node currentProccessNode = currentNode;
            Node parrentNode = currentNode.getParentNode();
            int lastMatch = 0;
            Matcher m = URL_PATTERN.matcher(content);
            while (m.find()) {
                String textLink = content.substring(m.start(), m.end());
                Object url = textLink;
                int start = m.start();
                int end = m.end();
                if (start != 0 && !Character.isWhitespace(content.charAt(start - 1)) || end != content.length() && !Character.isWhitespace(content.charAt(end))) continue;
                if (!HAVE_PROTOCOL_PREFIX.matcher((CharSequence)url).matches()) {
                    url = DEFAULT_PROTOCOL + (String)url;
                }
                if (m.start() > lastMatch) {
                    Node textNode = new Node();
                    textNode.setContent(StringEscapeUtils.escapeHtml4((String)content.substring(lastMatch, m.start())));
                    parrentNode.insertAfter(currentProccessNode, textNode);
                    currentProccessNode = textNode;
                    ++insertedCount;
                }
                Node aHrefNode = new Node();
                aHrefNode.setTitle("a");
                aHrefNode.setParentNode(parrentNode);
                Attributes aHrefNodeAttributes = new Attributes();
                aHrefNodeAttributes.put("href", (String)url);
                aHrefNodeAttributes.put("target", "_blank");
                aHrefNode.setAttributes(aHrefNodeAttributes);
                Node aHrefContentNode = new Node();
                aHrefContentNode.setContent(StringEscapeUtils.escapeHtml4((String)this.shortenURL(textLink)));
                aHrefContentNode.setParentNode(aHrefNode);
                aHrefNode.addChildNode(aHrefContentNode);
                parrentNode.insertAfter(currentProccessNode, aHrefNode);
                currentProccessNode = aHrefNode;
                lastMatch = m.end();
                ++insertedCount;
            }
            if (lastMatch + 1 < content.length()) {
                Node textNode = new Node();
                textNode.setContent(StringEscapeUtils.escapeHtml4((String)content.substring(lastMatch, content.length())));
                parrentNode.insertAfter(currentProccessNode, textNode);
                currentProccessNode = textNode;
                ++insertedCount;
            }
            if (insertedCount > 0) {
                parrentNode.getChildNodes().remove(currentNode);
            }
        }
        return insertedCount;
    }

    private String shortenURL(String url) {
        if (this.urlMaxLength < 3 || url.length() < this.urlMaxLength) {
            return url;
        }
        return url.substring(0, this.urlMaxLength - 3) + "...";
    }
}

