/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.channel;

import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.social.notification.AbstractCoreTest;
import org.exoplatform.social.notification.channel.template.MailTemplateProvider;
import org.exoplatform.social.notification.mock.MockMailTemplateProvider;

public class MailTemplateProviderTest
extends AbstractCoreTest {
    private ChannelManager manager;
    private InitParams initParams;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.manager = this.getService(ChannelManager.class);
        this.initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("channel-id");
        valueParam.setValue("MAIL_CHANNEL");
        this.initParams.addParameter((Parameter)valueParam);
        this.manager.registerOverrideTemplateProvider((TemplateProvider)new MailTemplateProvider(this.initParams));
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.manager.registerOverrideTemplateProvider((TemplateProvider)new MockMailTemplateProvider(this.initParams));
    }

    public void testChannelSize() throws Exception {
        MailTemplateProviderTest.assertTrue((this.manager.sizeChannels() > 0 ? 1 : 0) != 0);
    }

    public void testGetChannel() throws Exception {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"MAIL_CHANNEL"));
        MailTemplateProviderTest.assertTrue((channel != null ? 1 : 0) != 0);
        String actual = channel.getTemplateFilePath(PluginKey.key((String)"DigestDailyPlugin"));
        String expected = "war:/notification/templates/DigestDailyPlugin.gtmpl";
        MailTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"DigestWeeklyPlugin"));
        expected = "war:/notification/templates/DigestWeeklyPlugin.gtmpl";
        MailTemplateProviderTest.assertEquals((String)expected, (String)actual);
    }

    public void testMailTemplateProvider() throws Exception {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"MAIL_CHANNEL"));
        MailTemplateProviderTest.assertTrue((channel != null ? 1 : 0) != 0);
        String actual = channel.getTemplateFilePath(PluginKey.key((String)"ActivityCommentPlugin"));
        String expected = "war:/notification/templates/ActivityCommentPlugin.gtmpl";
        MailTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"ActivityReplyToCommentPlugin"));
        expected = "war:/notification/templates/ActivityReplyToCommentPlugin.gtmpl";
        MailTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"ActivityMentionPlugin"));
        expected = "war:/notification/templates/ActivityMentionPlugin.gtmpl";
        MailTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"LikePlugin"));
        expected = "war:/notification/templates/LikePlugin.gtmpl";
        MailTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"EditCommentPlugin"));
        expected = "war:/notification/templates/EditCommentPlugin.gtmpl";
        MailTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"EditActivityPlugin"));
        expected = "war:/notification/templates/EditActivityPlugin.gtmpl";
        MailTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"LikeCommentPlugin"));
        expected = "war:/notification/templates/LikeCommentPlugin.gtmpl";
        MailTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"NewUserPlugin"));
        expected = "war:/notification/templates/NewUserPlugin.gtmpl";
        MailTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"PostActivityPlugin"));
        expected = "war:/notification/templates/PostActivityPlugin.gtmpl";
        MailTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"PostActivitySpaceStreamPlugin"));
        expected = "war:/notification/templates/PostActivitySpaceStreamPlugin.gtmpl";
        MailTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"RelationshipReceivedRequestPlugin"));
        expected = "war:/notification/templates/RelationshipReceivedRequestPlugin.gtmpl";
        MailTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"RequestJoinSpacePlugin"));
        expected = "war:/notification/templates/RequestJoinSpacePlugin.gtmpl";
        MailTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"SpaceInvitationPlugin"));
        expected = "war:/notification/templates/SpaceInvitationPlugin.gtmpl";
        MailTemplateProviderTest.assertEquals((String)expected, (String)actual);
    }

    public void testMailTemplateBuilder() throws Exception {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"MAIL_CHANNEL"));
        MailTemplateProviderTest.assertTrue((channel != null ? 1 : 0) != 0);
        MailTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"ActivityCommentPlugin")));
        MailTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"ActivityReplyToCommentPlugin")));
        MailTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"ActivityMentionPlugin")));
        MailTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"LikePlugin")));
        MailTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"EditCommentPlugin")));
        MailTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"EditActivityPlugin")));
        MailTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"NewUserPlugin")));
        MailTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"PostActivityPlugin")));
        MailTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"PostActivitySpaceStreamPlugin")));
        MailTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"RelationshipReceivedRequestPlugin")));
        MailTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"RequestJoinSpacePlugin")));
        MailTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"SpaceInvitationPlugin")));
    }
}

