/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.web.template;

import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.notification.AbstractPluginTest;

public class LikeCommentWebBuilderTest
extends AbstractPluginTest {
    private ChannelManager manager;
    private static final String COMMENT_TITLE = "my comment's title add today.";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.manager = this.getService(ChannelManager.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    public AbstractTemplateBuilder getTemplateBuilder() {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"WEB_CHANNEL"));
        LikeCommentWebBuilderTest.assertTrue((channel != null ? 1 : 0) != 0);
        LikeCommentWebBuilderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"LikeCommentPlugin")));
        return channel.getTemplateBuilder(PluginKey.key((String)"LikeCommentPlugin"));
    }

    @Override
    public BaseNotificationPlugin getPlugin() {
        return this.pluginService.getPlugin(PluginKey.key((String)"LikeCommentPlugin"));
    }

    public void testLikeComment() throws Exception {
        ExoSocialActivity activity = this.makeActivity(this.rootIdentity, "root post an activity");
        ExoSocialActivity comment = this.makeComment(activity, this.rootIdentity, COMMENT_TITLE);
        this.activityManager.saveLike(comment, this.demoIdentity);
        this.assertMadeWebNotifications(1);
        List<NotificationInfo> list = this.assertMadeWebNotifications(this.rootIdentity.getRemoteId(), 1);
        NotificationInfo likeNotification = list.get(0);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(likeNotification.setTo("root"));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertBody(info, "likes your comment");
        this.assertBody(info, "data-link=\"/portal/classic/activity?id=" + activity.getId() + "#comment-" + comment.getId() + "\"");
    }
}

