/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class ActivityMentionPlugin
extends BaseNotificationPlugin {
    public static final String ID = "ActivityMentionPlugin";

    public ActivityMentionPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        ExoSocialActivity activity = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
        Map templateParams = activity.getTemplateParams() != null ? activity.getTemplateParams() : new HashMap();
        String[] actualMentions = activity.getMentionedIds();
        String[] previousMentions = templateParams.containsKey("PreviousMentions") ? ((String)templateParams.get("PreviousMentions")).split(",") : new String[]{};
        String[] mentionedIds = this.getAddedMentions(previousMentions, actualMentions);
        Set<String> receivers = new HashSet<String>();
        if (actualMentions.length > 0) {
            Utils.sendToMentioners(receivers, mentionedIds, activity.getPosterId());
        } else {
            receivers = Utils.getMentioners((String)activity.getTemplateParams().get("comment"), activity.getPosterId());
        }
        return NotificationInfo.instance().key(this.getKey()).to(new ArrayList<String>(receivers)).with(SocialNotificationUtils.POSTER.getKey(), Utils.getUserId(activity.getPosterId())).with(SocialNotificationUtils.ACTIVITY_ID.getKey(), activity.getId()).end();
    }

    public boolean isValid(NotificationContext ctx) {
        ExoSocialActivity activity = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
        if (activity.getMentionedIds().length > 0) {
            return true;
        }
        String commentLinkActivity = (String)activity.getTemplateParams().get("comment");
        return commentLinkActivity != null && commentLinkActivity.length() > 0 && Utils.getMentioners(commentLinkActivity, activity.getPosterId()).size() > 0;
    }

    private String[] getAddedMentions(String[] previousMentions, String[] actualMentions) {
        List<String> previousMentionsList = Arrays.asList(previousMentions);
        List<String> actualMentionsList = Arrays.asList(actualMentions);
        List<String> addedMentionsList = actualMentionsList.stream().filter(s -> !previousMentionsList.contains(s)).collect(Collectors.toList());
        return addedMentionsList.toArray(new String[addedMentionsList.size()]);
    }
}

