/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.channel.template;

import java.io.StringWriter;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.notification.AbstractPluginTest;

public class EditActivityMailBuilderTest
extends AbstractPluginTest {
    private ChannelManager manager;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.manager = this.getService(ChannelManager.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    public AbstractTemplateBuilder getTemplateBuilder() {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"MAIL_CHANNEL"));
        EditActivityMailBuilderTest.assertTrue((channel != null ? 1 : 0) != 0);
        EditActivityMailBuilderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"EditActivityPlugin")));
        return channel.getTemplateBuilder(PluginKey.key((String)"EditActivityPlugin"));
    }

    @Override
    public BaseNotificationPlugin getPlugin() {
        return this.pluginService.getPlugin(PluginKey.key((String)"EditActivityPlugin"));
    }

    public void testSimpleCase() throws Exception {
        ExoSocialActivity activity = this.makeActivity(this.rootIdentity, "root post an activity");
        this.makeComment(activity, this.demoIdentity, "comment");
        activity.setTitle("edited activity");
        this.activityManager.updateActivity(activity);
        this.assertMadeMailDigestNotifications(1);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.demoIdentity.getRemoteId(), 1);
        NotificationInfo notification = list.get(0);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(notification.setTo("root"));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertSubject(info, "Notification.subject.EditActivityPlugin");
        this.assertBody(info, "edited activity");
    }

    public void testDigest() throws Exception {
        ExoSocialActivity activity = this.makeActivity(this.rootIdentity, "root post an activity");
        this.makeComment(activity, this.demoIdentity, "comment");
        activity.setTitle("edited activity");
        this.activityManager.updateActivity(activity);
        this.assertMadeMailDigestNotifications(1);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.demoIdentity.getRemoteId(), 1);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        list.set(0, list.get(0).setTo(this.demoIdentity.getRemoteId()));
        ctx.setNotificationInfos(list);
        StringWriter writer = new StringWriter();
        this.buildDigest(ctx, writer);
        this.assertDigest(writer, "Root Root edited activity:edited activity");
    }
}

