/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.mock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.notification.service.storage.NotificationService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.social.notification.mock.MockUserSettingServiceImpl;

public class MockNotificationService
implements NotificationService {
    private Map<String, List<NotificationInfo>> storedDigest = new HashMap<String, List<NotificationInfo>>();
    private Map<String, List<NotificationInfo>> storeInstantly = new HashMap<String, List<NotificationInfo>>();
    private Map<String, List<NotificationInfo>> storeWebNotifs = new HashMap<String, List<NotificationInfo>>();

    public int sizeOfInstantly() {
        return this.storeInstantly.values().stream().mapToInt(List::size).sum();
    }

    public int sizeOfWebNotifs() {
        return this.storeWebNotifs.values().stream().mapToInt(List::size).sum();
    }

    public int sizeOfStoredDigest() {
        return this.storedDigest.values().stream().mapToInt(List::size).sum();
    }

    public int sizeOfStoredDigest(String username) {
        return this.storedDigest.containsKey(username) ? this.storedDigest.get(username).size() : 0;
    }

    public void clearAll() {
        this.clearOfStoredDigest();
        this.clearOfInstantly();
        this.clearOfWebNotifs();
    }

    public void clearOfStoredDigest() {
        this.storedDigest.clear();
    }

    public void clearOfInstantly() {
        this.storeInstantly.clear();
    }

    public void clearOfWebNotifs() {
        this.storeWebNotifs.clear();
    }

    public List<NotificationInfo> storeDigest(String username) {
        return this.storedDigest.containsKey(username) ? this.storedDigest.get(username) : Collections.emptyList();
    }

    public List<NotificationInfo> storeInstantly(String username) {
        return this.storeInstantly.containsKey(username) ? this.storeInstantly.get(username) : Collections.emptyList();
    }

    public List<NotificationInfo> storeWebNotifs(String username) {
        return this.storeWebNotifs.containsKey(username) ? this.storeWebNotifs.get(username) : Collections.emptyList();
    }

    public void process(NotificationInfo notification) throws Exception {
        String pluginId = notification.getKey().getId();
        PluginSettingService settingService = (PluginSettingService)CommonsUtils.getService(PluginSettingService.class);
        if (!settingService.isActive(UserSetting.EMAIL_CHANNEL, pluginId)) {
            return;
        }
        List<String> userIds = notification.getSendToUserIds();
        MockUserSettingServiceImpl userSettingService = (MockUserSettingServiceImpl)CommonsUtils.getService(UserSettingService.class);
        if (notification.isSendAll()) {
            userIds = userSettingService.getUserHasSettingPlugin(UserSetting.EMAIL_CHANNEL, pluginId);
        }
        for (String userId : userIds) {
            UserSetting userSetting = userSettingService.get(userId);
            if (userSetting == null) {
                userSetting = userSettingService.getDefaultSettings();
                userSetting.setUserId(userId);
            }
            if (userSetting.isActive(UserSetting.EMAIL_CHANNEL, pluginId)) {
                if (!this.storeInstantly.containsKey(userId)) {
                    this.storeInstantly.put(userId, new ArrayList());
                }
                this.storeInstantly.get(userId).add(notification);
            }
            if (userSetting.isActive("WEB_CHANNEL", pluginId)) {
                if (!this.storeWebNotifs.containsKey(userId)) {
                    this.storeWebNotifs.put(userId, new ArrayList());
                }
                this.storeWebNotifs.get(userId).add(notification);
            }
            if (!userSetting.isInDaily(pluginId) && !userSetting.isInWeekly(pluginId)) continue;
            if (!this.storedDigest.containsKey(userId)) {
                this.storedDigest.put(userId, new ArrayList());
            }
            this.storedDigest.get(userId).add(notification);
        }
    }

    public void process(Collection<NotificationInfo> messages) throws Exception {
        for (NotificationInfo message : messages) {
            this.process(message);
        }
    }

    public void digest(NotificationContext context) throws Exception {
    }
}

