/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.web.template;

import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.notification.AbstractPluginTest;

public class ActivityMentionWebBuilderTest
extends AbstractPluginTest {
    private ChannelManager manager;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.manager = this.getService(ChannelManager.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    public AbstractTemplateBuilder getTemplateBuilder() {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"WEB_CHANNEL"));
        ActivityMentionWebBuilderTest.assertTrue((channel != null ? 1 : 0) != 0);
        ActivityMentionWebBuilderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"ActivityMentionPlugin")));
        return channel.getTemplateBuilder(PluginKey.key((String)"ActivityMentionPlugin"));
    }

    @Override
    public BaseNotificationPlugin getPlugin() {
        return this.pluginService.getPlugin(PluginKey.key((String)"ActivityMentionPlugin"));
    }

    public void testActivityMention() throws Exception {
        this.makeActivity(this.maryIdentity, "hello @john and @demo");
        this.assertMadeWebNotifications(3);
        List<NotificationInfo> list = this.assertMadeWebNotifications(this.johnIdentity.getRemoteId(), 1);
        NotificationInfo mentionNotification = list.get(0);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(mentionNotification.setTo(this.demoIdentity.getRemoteId()));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertBody(info, "has mentioned you");
    }

    public void testEditActivityMention() throws Exception {
        ExoSocialActivity maryActivity = this.makeActivityOnStream(this.ghostIdentity, "Hello @root");
        this.assertMadeWebNotifications(1);
        List<NotificationInfo> toRoot = this.assertMadeWebNotifications(this.rootIdentity.getRemoteId(), 1);
        NotificationInfo mentionNotification = toRoot.get(0);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(mentionNotification.setTo(this.rootIdentity.getRemoteId()));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertBody(info, "has mentioned you");
        this.notificationService.clearAll();
        maryActivity = this.editActivity(maryActivity, "Hello @root and @john");
        this.assertMadeWebNotifications(1);
        List<NotificationInfo> toJohn = this.assertMadeWebNotifications(this.johnIdentity.getRemoteId(), 1);
        mentionNotification = toJohn.get(0);
        ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(mentionNotification.setTo(this.johnIdentity.getRemoteId()));
        info = this.buildMessageInfo(ctx);
        this.assertBody(info, "has mentioned you");
        this.notificationService.clearAll();
        this.editActivity(maryActivity, "Hello @demo @root and @john");
        this.assertMadeWebNotifications(1);
        List<NotificationInfo> toDemo = this.assertMadeWebNotifications(this.demoIdentity.getRemoteId(), 1);
        mentionNotification = toDemo.get(0);
        ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(mentionNotification.setTo(this.demoIdentity.getRemoteId()));
        info = this.buildMessageInfo(ctx);
        this.assertBody(info, "has mentioned you");
        this.notificationService.clearAll();
    }

    public void testCommentMention() throws Exception {
        ExoSocialActivity activity = this.makeActivity(this.maryIdentity, "mary post activity on root stream");
        this.assertMadeWebNotifications(1);
        this.notificationService.clearAll();
        this.makeComment(activity, this.demoIdentity, "hello @john and @root");
        this.assertMadeWebNotifications(4);
        List<NotificationInfo> list = this.assertMadeWebNotifications(this.rootIdentity.getRemoteId(), 2);
        NotificationInfo mentionNotification = list.get(1);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(mentionNotification.setTo(this.johnIdentity.getRemoteId()));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertBody(info, "has mentioned you");
    }

    public void testEditCommentMention() throws Exception {
        ExoSocialActivity ghostActivity = this.makeActivityOnStream(this.ghostIdentity, "john post activity on activity stream");
        this.assertMadeWebNotifications(0);
        ExoSocialActivity maryComment = this.makeComment(ghostActivity, this.maryIdentity, "hello @john and @demo");
        this.assertMadeWebNotifications(3);
        this.assertMadeWebNotifications("ghost", 1);
        this.assertMadeWebNotifications("john", 1);
        this.assertMadeWebNotifications("demo", 1);
        List<NotificationInfo> toJohn = this.assertMadeWebNotifications(this.johnIdentity.getRemoteId(), 1);
        NotificationInfo mentionNotification = toJohn.get(0);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(mentionNotification.setTo(this.johnIdentity.getRemoteId()));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertBody(info, "has mentioned you");
        List<NotificationInfo> toDemo = this.assertMadeWebNotifications(this.demoIdentity.getRemoteId(), 1);
        mentionNotification = toDemo.get(0);
        ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(mentionNotification.setTo(this.demoIdentity.getRemoteId()));
        info = this.buildMessageInfo(ctx);
        this.assertBody(info, "has mentioned you");
        this.notificationService.clearAll();
        this.editComment(ghostActivity, maryComment, "hello @root @john and @demo");
        this.assertMadeWebNotifications(2);
        this.assertMadeWebNotifications(this.johnIdentity.getRemoteId(), 0);
        this.assertMadeWebNotifications(this.demoIdentity.getRemoteId(), 0);
        List<NotificationInfo> toRoot = this.assertMadeWebNotifications(this.rootIdentity.getRemoteId(), 1);
        mentionNotification = toRoot.get(0);
        ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(mentionNotification.setTo(this.rootIdentity.getRemoteId()));
        info = this.buildMessageInfo(ctx);
        this.assertBody(info, "has mentioned you");
    }
}

