/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.web.template;

import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.notification.AbstractPluginTest;

public class ActivitySpaceStreamWebBuilderTest
extends AbstractPluginTest {
    private ChannelManager manager;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.manager = this.getService(ChannelManager.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    public AbstractTemplateBuilder getTemplateBuilder() {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"WEB_CHANNEL"));
        ActivitySpaceStreamWebBuilderTest.assertTrue((channel != null ? 1 : 0) != 0);
        ActivitySpaceStreamWebBuilderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"PostActivitySpaceStreamPlugin")));
        return channel.getTemplateBuilder(PluginKey.key((String)"PostActivitySpaceStreamPlugin"));
    }

    @Override
    public BaseNotificationPlugin getPlugin() {
        return this.pluginService.getPlugin(PluginKey.key((String)"PostActivitySpaceStreamPlugin"));
    }

    public void testPostSpaceActivity() throws Exception {
        Space space = this.getSpaceInstance(1);
        this.spaceService.addMember(space, this.demoIdentity.getRemoteId());
        this.spaceService.addMember(space, this.johnIdentity.getRemoteId());
        this.spaceService.addMember(space, this.maryIdentity.getRemoteId());
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), true);
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("root post activity on space 1");
        activity.setUserId(this.rootIdentity.getId());
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        this.tearDownActivityList.add(activity);
        this.assertMadeWebNotifications(3);
        List<NotificationInfo> list = this.assertMadeWebNotifications(this.rootIdentity.getRemoteId(), 1);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        NotificationInfo postSpaceNotification = list.get(0);
        ctx.setNotificationInfo(postSpaceNotification.setTo(this.demoIdentity.getRemoteId()));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertBody(info, "root post activity on space 1");
    }
}

