/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.notification.rest;

import io.meeds.social.notification.rest.WebNotificationRestService;
import javax.ws.rs.core.Response;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.service.WebNotificationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.BaseRestServicesTestCase;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;

public class WebNotificationRestServiceTest
extends BaseRestServicesTestCase {
    @Mock
    WebNotificationService webNotificationService;
    @Mock
    IdentityManager identityManager;
    @Mock
    SpaceService spaceService;

    protected Class<?> getComponentClass() {
        return WebNotificationRestService.class;
    }

    public void testUnauthorizedMarkAsRead() {
        this.startSessionAs("john");
        this.webNotificationService = (WebNotificationService)Mockito.mock(WebNotificationService.class);
        NotificationInfo notificationInfo = new NotificationInfo();
        notificationInfo.setTo("mary");
        Mockito.when((Object)this.webNotificationService.getNotificationInfo(ArgumentMatchers.anyString())).thenReturn((Object)notificationInfo);
        WebNotificationRestService webNotificationRestService = this.newWebNotificationRestService();
        Response response = webNotificationRestService.updateNotification("markAsRead", "1");
        WebNotificationRestServiceTest.assertEquals((int)401, (int)response.getStatus());
    }

    public void testAuthorizedMarkAsRead() {
        this.startSessionAs("john");
        this.webNotificationService = (WebNotificationService)Mockito.mock(WebNotificationService.class);
        NotificationInfo notificationInfo = new NotificationInfo();
        notificationInfo.setTo("john");
        Mockito.when((Object)this.webNotificationService.getNotificationInfo(ArgumentMatchers.anyString())).thenReturn((Object)notificationInfo);
        WebNotificationRestService webNotificationRestService = this.newWebNotificationRestService();
        Response response = webNotificationRestService.updateNotification("markAsRead", "1");
        WebNotificationRestServiceTest.assertEquals((int)204, (int)response.getStatus());
    }

    public void testUnauthorizedHide() {
        this.startSessionAs("john");
        this.webNotificationService = (WebNotificationService)Mockito.mock(WebNotificationService.class);
        NotificationInfo notificationInfo = new NotificationInfo();
        notificationInfo.setTo("mary");
        Mockito.when((Object)this.webNotificationService.getNotificationInfo(ArgumentMatchers.anyString())).thenReturn((Object)notificationInfo);
        WebNotificationRestService webNotificationRestService = this.newWebNotificationRestService();
        Response response = webNotificationRestService.hideNotifications("1");
        WebNotificationRestServiceTest.assertEquals((int)response.getStatus(), (int)401);
    }

    public void testAuthorizedHide() {
        this.startSessionAs("john");
        this.webNotificationService = (WebNotificationService)Mockito.mock(WebNotificationService.class);
        NotificationInfo notificationInfo = new NotificationInfo();
        notificationInfo.setTo("john");
        Mockito.when((Object)this.webNotificationService.getNotificationInfo(ArgumentMatchers.anyString())).thenReturn((Object)notificationInfo);
        WebNotificationRestService webNotificationRestService = this.newWebNotificationRestService();
        Response response = webNotificationRestService.hideNotifications("1");
        WebNotificationRestServiceTest.assertEquals((int)204, (int)response.getStatus());
    }

    private void startSessionAs(String username) {
        Identity identity = new Identity(username);
        ConversationState state = new ConversationState(identity);
        ConversationState.setCurrent((ConversationState)state);
    }

    private WebNotificationRestService newWebNotificationRestService() {
        return new WebNotificationRestService(this.webNotificationService, this.identityManager, this.spaceService);
    }
}

