/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.notification.upgrade;

import io.meeds.social.notification.upgrade.NotificationUpgradePlugin;
import java.util.Arrays;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.social.notification.AbstractNotificationCoreTest;

public class NotificationUpgradePluginTest
extends AbstractNotificationCoreTest {
    private static final String DEFAULT_NOTIFICATION_PLUGIN_ID = "DefaultNotificationPluginId";
    private static final String UPGRADE_NOTIFICATION_PLUGIN = "UpgradeNotificationPlugin";
    private UserSettingService userSettingService;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.userSettingService = (UserSettingService)this.getContainer().getComponentInstanceOfType(UserSettingService.class);
    }

    public void testNotificationUpgrade() {
        UserSetting userSettings = this.userSettingService.get("root");
        String channelId = (String)userSettings.getChannelActives().iterator().next();
        userSettings.setChannelPlugins(channelId, Arrays.asList(DEFAULT_NOTIFICATION_PLUGIN_ID));
        this.userSettingService.save(userSettings);
        UserSetting rootUserSettings = this.userSettingService.get(userSettings.getUserId());
        NotificationUpgradePluginTest.assertTrue((boolean)rootUserSettings.getPlugins(channelId).contains(DEFAULT_NOTIFICATION_PLUGIN_ID));
        InitParams initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("product.group.id");
        valueParam.setValue("org.exoplatform.social");
        initParams.addParam((Object)valueParam);
        valueParam = new ValueParam();
        valueParam.setName("plugin.execution.order");
        valueParam.setValue("5");
        initParams.addParam((Object)valueParam);
        valueParam = new ValueParam();
        valueParam.setName("notificationPluginId");
        valueParam.setValue(UPGRADE_NOTIFICATION_PLUGIN);
        initParams.addParam((Object)valueParam);
        EntityManagerService entityManagerService = (EntityManagerService)this.getContainer().getComponentInstanceOfType(EntityManagerService.class);
        SettingService settingService = (SettingService)this.getContainer().getComponentInstanceOfType(SettingService.class);
        NotificationUpgradePlugin upgradePlugin = new NotificationUpgradePlugin(entityManagerService, this.userSettingService, settingService, initParams);
        upgradePlugin.setName(UPGRADE_NOTIFICATION_PLUGIN);
        NotificationUpgradePluginTest.assertTrue((boolean)upgradePlugin.isEnabled());
        upgradePlugin.processUpgrade(null, null);
        this.restartTransaction();
        rootUserSettings = this.userSettingService.get(userSettings.getUserId());
        NotificationUpgradePluginTest.assertTrue((boolean)rootUserSettings.getPlugins(channelId).contains(UPGRADE_NOTIFICATION_PLUGIN));
    }
}

