/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin;

import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.notification.model.SpaceWebNotificationItem;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;
import org.exoplatform.social.notification.plugin.SpaceWebNotificationPlugin;

public class ActivitySpaceWebNotificationPlugin
extends SpaceWebNotificationPlugin {
    public static final String ID = "ActivitySpaceWebNotificationPlugin";
    private ActivityManager activityManager;

    public ActivitySpaceWebNotificationPlugin(ActivityManager activityManager, IdentityManager identityManager, InitParams params) {
        super(identityManager, params);
        this.activityManager = activityManager;
    }

    public SpaceWebNotificationItem getSpaceApplicationItem(NotificationInfo notification) {
        MetadataObject metadataObject;
        String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null) {
            return null;
        }
        if (activity.isComment()) {
            ExoSocialActivity parentActivity = this.activityManager.getActivity(activity.getParentId());
            metadataObject = parentActivity.getMetadataObject();
        } else {
            metadataObject = activity.getMetadataObject();
        }
        if (metadataObject != null && metadataObject.getSpaceId() > 0L) {
            SpaceWebNotificationItem spaceWebNotificationItem = new SpaceWebNotificationItem(metadataObject.getType(), metadataObject.getId(), 0L, metadataObject.getSpaceId());
            if (activity.isComment()) {
                spaceWebNotificationItem.setActivityId(activity.getParentId());
                spaceWebNotificationItem.addApplicationSubItem(activity.getId());
            } else {
                spaceWebNotificationItem.setActivityId(activity.getId());
            }
            return spaceWebNotificationItem;
        }
        return null;
    }
}

