/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.openid;

import com.github.scribejava.core.model.OAuth2AccessToken;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.IncorrectClaimException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MissingClaimException;
import io.jsonwebtoken.SigningKeyResolver;
import io.meeds.oauth.exception.OAuthException;
import io.meeds.oauth.exception.OAuthExceptionCode;
import io.meeds.oauth.openid.OpenIdAccessTokenContext;
import io.meeds.oauth.openid.OpenIdProcessor;
import io.meeds.oauth.openid.OpenIdRequest;
import io.meeds.oauth.openid.RemoteJwkSigningKeyResolver;
import io.meeds.oauth.spi.InteractionState;
import io.meeds.oauth.spi.OAuthCodec;
import io.meeds.oauth.utils.HttpResponseContext;
import io.meeds.oauth.utils.OAuthPersistenceUtils;
import io.meeds.oauth.utils.OAuthUtils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.web.security.security.SecureRandomService;
import org.json.JSONException;
import org.json.JSONObject;
import org.picocontainer.Startable;

public class OpenIdProcessorImpl
implements OpenIdProcessor,
Startable {
    private static Log log = ExoLogger.getLogger(OpenIdProcessorImpl.class);
    private final String redirectURL;
    private String authenticationURL;
    private String accessTokenURL;
    private String userInfoURL;
    private final String clientID;
    private final String clientSecret;
    private final Set<String> scopes = new HashSet<String>();
    private final String accessType;
    private final String wellKnownConfigurationUrl;
    private boolean wellKnownConfigurationLoaded;
    private final String applicationName;
    private String issuer;
    private final int chunkLength;
    private RemoteJwkSigningKeyResolver remoteJwkSigningKeyResolver;
    private final SecureRandomService secureRandomService;

    public OpenIdProcessorImpl(ExoContainerContext context, InitParams params, SecureRandomService secureRandomService) {
        this.clientID = params.getValueParam("clientId").getValue();
        this.clientSecret = params.getValueParam("clientSecret").getValue();
        String redirectURLParam = params.getValueParam("redirectURL").getValue();
        this.wellKnownConfigurationUrl = params.getValueParam("wellKnownConfigurationUrl").getValue();
        this.wellKnownConfigurationLoaded = false;
        String scope = params.getValueParam("scope").getValue();
        this.accessType = params.getValueParam("accessType").getValue();
        ValueParam appNameParam = params.getValueParam("applicationName");
        this.applicationName = appNameParam != null && appNameParam.getValue() != null ? appNameParam.getValue() : "GateIn portal";
        if (this.clientID == null || this.clientID.length() == 0 || this.clientID.trim().equals("<<to be replaced>>")) {
            throw new IllegalArgumentException("Property 'clientId' needs to be provided. The value should be clientId of your OpenId application");
        }
        if (this.clientSecret == null || this.clientSecret.length() == 0 || this.clientSecret.trim().equals("<<to be replaced>>")) {
            throw new IllegalArgumentException("Property 'clientSecret' needs to be provided. The value should be clientSecret of your OpenId application");
        }
        this.redirectURL = redirectURLParam == null || redirectURLParam.length() == 0 ? "http://localhost:8080/" + context.getName() + "/openidAuth" : redirectURLParam.replaceAll("@@portal.container.name@@", context.getName());
        this.addScopesFromString(scope, this.scopes);
        this.chunkLength = OAuthPersistenceUtils.getChunkLength(params);
        if (log.isDebugEnabled()) {
            log.debug((Object)("configuration: clientId=" + this.clientID + ", clientSecret=" + this.clientSecret + ", redirectURL=" + this.redirectURL + ", scope=" + this.scopes + ", accessType=" + this.accessType + ", applicationName=" + this.applicationName + ", chunkLength=" + this.chunkLength));
        }
        this.secureRandomService = secureRandomService;
    }

    @Override
    public InteractionState<OpenIdAccessTokenContext> processOAuthInteraction(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, OAuthException {
        return this.processOAuthInteractionImpl(httpRequest, httpResponse, this.scopes);
    }

    @Override
    public InteractionState<OpenIdAccessTokenContext> processOAuthInteraction(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String scope) throws IOException, OAuthException {
        HashSet<String> oauthScopes = new HashSet<String>();
        this.addScopesFromString(scope, oauthScopes);
        return this.processOAuthInteractionImpl(httpRequest, httpResponse, oauthScopes);
    }

    protected InteractionState<OpenIdAccessTokenContext> processOAuthInteractionImpl(HttpServletRequest request, HttpServletResponse response, Set<String> oauthScopes) throws IOException {
        HttpSession session = request.getSession();
        String state = (String)session.getAttribute("_authState");
        if (state == null || state.isEmpty()) {
            return this.initialInteraction(request, response);
        }
        if (state.equals(InteractionState.State.AUTH.name())) {
            OAuth2AccessToken tokenResponse = this.obtainAccessToken(request);
            OpenIdAccessTokenContext accessTokenContext = this.validateTokenAndUpdateScopes(new OpenIdAccessTokenContext(tokenResponse, new String[0]));
            session.removeAttribute("_authState");
            session.removeAttribute("_verificationState");
            return new InteractionState<OpenIdAccessTokenContext>(InteractionState.State.FINISH, accessTokenContext);
        }
        return new InteractionState<Object>(InteractionState.State.valueOf(state), null);
    }

    protected InteractionState<OpenIdAccessTokenContext> initialInteraction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.wellKnownConfigurationLoaded) {
            this.readWellKnownConfiguration();
        }
        String verificationState = String.valueOf(this.secureRandomService.getSecureRandom().nextLong());
        String authorizeUrl = this.authenticationURL + "?response_type=code&client_id=" + this.clientID + "&scope=" + this.scopes.stream().collect(Collectors.joining(" ")) + "&redirect_uri=" + this.redirectURL + "&state=" + verificationState;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Starting OAuth2 interaction with OpenId");
            log.trace((Object)("URL to send to OpenId: " + authorizeUrl));
        }
        HttpSession session = request.getSession();
        session.setAttribute("_verificationState", (Object)verificationState);
        session.setAttribute("_authState", (Object)InteractionState.State.AUTH.name());
        response.sendRedirect(authorizeUrl);
        return new InteractionState<Object>(InteractionState.State.AUTH, null);
    }

    protected OAuth2AccessToken obtainAccessToken(HttpServletRequest request) {
        HttpSession session = request.getSession();
        String stateFromSession = (String)session.getAttribute("_verificationState");
        String stateFromRequest = request.getParameter("state");
        if (stateFromSession == null || stateFromRequest == null || !stateFromSession.equals(stateFromRequest)) {
            throw new OAuthException(OAuthExceptionCode.INVALID_STATE, "Validation of state parameter failed. stateFromSession=" + stateFromSession + ", stateFromRequest=" + stateFromRequest);
        }
        String error = request.getParameter("error");
        if (error != null) {
            if ("access_denied".equals(error)) {
                throw new OAuthException(OAuthExceptionCode.USER_DENIED_SCOPE, error);
            }
            throw new OAuthException(OAuthExceptionCode.UNKNOWN_ERROR, error);
        }
        String code = request.getParameter("code");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", code);
        params.put("client_id", this.clientID);
        params.put("client_secret", this.clientSecret);
        params.put("redirect_uri", this.redirectURL);
        params.put("grant_type", "authorization_code");
        OAuth2AccessToken tokenResponse = (OAuth2AccessToken)new OpenIdRequest<OAuth2AccessToken>(){

            @Override
            protected URL createURL() throws IOException {
                return OpenIdProcessorImpl.this.sendAccessTokenRequest();
            }

            @Override
            protected OAuth2AccessToken invokeRequest(Map<String, String> params) throws IOException, JSONException {
                URL url = this.createURL();
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                String urlParameters = params.keySet().stream().map(s -> s + "=" + (String)params.get(s)).collect(Collectors.joining("&"));
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                conn.setRequestProperty("charset", "utf-8");
                conn.setRequestProperty("Content-Length", Integer.toString(urlParameters.getBytes().length));
                conn.setUseCaches(false);
                try (DataOutputStream wr = new DataOutputStream(conn.getOutputStream());){
                    wr.write(urlParameters.getBytes());
                }
                HttpResponseContext httpResponse = OAuthUtils.readUrlContent(conn);
                if (httpResponse.getResponseCode() == 200) {
                    return this.parseResponse(httpResponse.getResponse());
                }
                if (httpResponse.getResponseCode() == 400) {
                    String errorMessage = "Error when obtaining content from OpenId. Error details: " + httpResponse.getResponse();
                    log.warn((Object)errorMessage);
                    throw new OAuthException(OAuthExceptionCode.ACCESS_TOKEN_ERROR, errorMessage);
                }
                String errorMessage = "Unspecified IO error. Http response code: " + httpResponse.getResponseCode() + ", details: " + httpResponse.getResponse();
                log.warn((Object)errorMessage);
                throw new OAuthException(OAuthExceptionCode.IO_ERROR, errorMessage);
            }

            @Override
            protected OAuth2AccessToken parseResponse(String httpResponse) throws JSONException {
                JSONObject json = new JSONObject(httpResponse);
                String accessToken = json.getString("access_token");
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Access Token=" + accessToken));
                }
                return new OAuth2AccessToken(accessToken, json.getString("token_type"), Integer.valueOf(json.getInt("expires_in")), null, json.has("scope") ? json.getString("scope") : null, json.toString());
            }
        }.executeRequest(params);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Successfully obtained accessToken from openid: " + tokenResponse));
        }
        return tokenResponse;
    }

    @Override
    public OpenIdAccessTokenContext validateTokenAndUpdateScopes(OpenIdAccessTokenContext accessToken) throws OAuthException {
        Claims customClaims;
        String scope = accessToken.getTokenData().getScope();
        try {
            String tokenId = new JSONObject(accessToken.accessToken.getRawResponse()).get("id_token").toString();
            customClaims = (Claims)Jwts.parserBuilder().setSigningKeyResolver((SigningKeyResolver)this.remoteJwkSigningKeyResolver).requireIssuer(this.issuer).requireAudience(this.clientID).setAllowedClockSkewSeconds(60L).build().parseClaimsJws(tokenId).getBody();
        }
        catch (IncorrectClaimException e) {
            log.error((Object)"Issuer or audience have not the correct value in the token", (Throwable)e);
            throw new OAuthException(OAuthExceptionCode.TOKEN_VALIDATION_ERROR, "Issuer or audience have not the correct value in the token", (Throwable)e);
        }
        catch (MissingClaimException e) {
            log.error((Object)"Required claims (issuer or audience) are missing in JWT Token", (Throwable)e);
            throw new OAuthException(OAuthExceptionCode.TOKEN_VALIDATION_ERROR, "Required claims (issuer or audience) are missing in JWT Token", (Throwable)e);
        }
        catch (JSONException e) {
            log.error((Object)"Unable to parse the accessToken");
            throw new OAuthException(OAuthExceptionCode.ACCESS_TOKEN_ERROR, "Unable to parse the accessToken", (Throwable)e);
        }
        OpenIdAccessTokenContext accessTokenContext = new OpenIdAccessTokenContext(accessToken.getTokenData(), scope);
        if (customClaims != null) {
            accessTokenContext.addCustomClaims(customClaims.entrySet().stream().filter(element -> ((String)element.getKey()).equals("given_name") || ((String)element.getKey()).equals("family_name") || ((String)element.getKey()).equals("email")).collect(Collectors.toMap(Map.Entry::getKey, x -> x.getValue().toString())));
        }
        return accessTokenContext;
    }

    @Override
    public <C> C getAuthorizedSocialApiObject(OpenIdAccessTokenContext accessToken, Class<C> socialApiObjectType) {
        return null;
    }

    @Override
    public void saveAccessTokenAttributesToUserProfile(UserProfile userProfile, OAuthCodec codec, OpenIdAccessTokenContext accessToken) {
        String encodedAccessToken = codec.encodeString(accessToken.accessToken.getAccessToken());
        OAuthPersistenceUtils.saveLongAttribute(encodedAccessToken, userProfile, "user.social-info.openid.accessToken", false, this.chunkLength);
    }

    @Override
    public OpenIdAccessTokenContext getAccessTokenFromUserProfile(UserProfile userProfile, OAuthCodec codec) {
        String encodedAccessToken = OAuthPersistenceUtils.getLongAttribute(userProfile, "user.social-info.openid.accessToken", false);
        String encodedAccessTokenSecret = OAuthPersistenceUtils.getLongAttribute(userProfile, "user.social-info.openid.accessTokenSecret", false);
        String decodedAccessToken = codec.decodeString(encodedAccessToken);
        String decodedAccessTokenSecret = codec.decodeString(encodedAccessTokenSecret);
        if (decodedAccessToken == null || decodedAccessTokenSecret == null) {
            return null;
        }
        OAuth2AccessToken token = new OAuth2AccessToken(decodedAccessToken, decodedAccessTokenSecret);
        return new OpenIdAccessTokenContext(token, new String[0]);
    }

    @Override
    public void removeAccessTokenFromUserProfile(UserProfile userProfile) {
        OAuthPersistenceUtils.removeLongAttribute(userProfile, "user.social-info.openid.accessToken", false);
        OAuthPersistenceUtils.removeLongAttribute(userProfile, "user.social-info.openid.accessTokenSecret", false);
    }

    @Override
    public JSONObject obtainUserInfo(OpenIdAccessTokenContext accessTokenContext) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", accessTokenContext.getAccessToken());
        OpenIdRequest<JSONObject> userInfoRequest = new OpenIdRequest<JSONObject>(){

            @Override
            protected URL createURL() throws IOException {
                return OpenIdProcessorImpl.this.getUserInfoURL();
            }

            @Override
            protected JSONObject invokeRequest(Map<String, String> params) throws IOException, JSONException {
                URL url = this.createURL();
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("Authorization", "Bearer " + params.get("access_token"));
                HttpResponseContext httpResponse = OAuthUtils.readUrlContent(conn);
                if (httpResponse.getResponseCode() == 200) {
                    return this.parseResponse(httpResponse.getResponse());
                }
                String errorMessage = "Unable to read OpenId userInfo endpoint. Http response code: " + httpResponse.getResponseCode() + ", details: " + httpResponse.getResponse() + ". We will use claims in id_token";
                log.info((Object)errorMessage);
                return new JSONObject();
            }

            @Override
            protected JSONObject parseResponse(String httpResponse) throws JSONException {
                return new JSONObject(httpResponse);
            }
        };
        JSONObject uinfo = (JSONObject)userInfoRequest.executeRequest(params);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Successfully obtained userInfo from openid: " + uinfo));
        }
        return uinfo;
    }

    @Override
    public void revokeToken(OpenIdAccessTokenContext accessToken) throws OAuthException {
    }

    private void addScopesFromString(String scope, Set<String> scopesToBuild) {
        String[] scopesParts = scope.split(" ");
        Collections.addAll(scopesToBuild, scopesParts);
    }

    protected URL sendAccessTokenRequest() throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("AccessToken Request=" + this.accessTokenURL));
        }
        return new URL(this.accessTokenURL);
    }

    protected URL getUserInfoURL() throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("UserInfo Request=" + this.userInfoURL));
        }
        return new URL(this.userInfoURL);
    }

    public void start() {
        boolean openIdEnabled = Boolean.parseBoolean(System.getProperty("exo.oauth.openid.enabled"));
        if (openIdEnabled) {
            if (StringUtils.isBlank((String)this.wellKnownConfigurationUrl)) {
                log.error((Object)"wellKnownConfigurationUrl is not configured");
                return;
            }
            try {
                this.readWellKnownConfiguration();
            }
            catch (JSONException e) {
                log.error((Object)("Unable to read webKnownUrl content : " + this.wellKnownConfigurationUrl), (Throwable)e);
            }
            catch (MalformedURLException e) {
                log.error((Object)("WellKnowConfigurationUrl malformed : url" + this.wellKnownConfigurationUrl), (Throwable)e);
            }
        }
    }

    private void readWellKnownConfiguration() throws MalformedURLException {
        String wellKnownConfigurationContent = OpenIdProcessorImpl.readUrl(new URL(this.wellKnownConfigurationUrl));
        if (wellKnownConfigurationContent != null) {
            JSONObject json = new JSONObject(wellKnownConfigurationContent);
            this.authenticationURL = json.getString("authorization_endpoint");
            this.accessTokenURL = json.getString("token_endpoint");
            this.userInfoURL = json.getString("userinfo_endpoint");
            this.issuer = json.getString("issuer");
            this.remoteJwkSigningKeyResolver = new RemoteJwkSigningKeyResolver(this.wellKnownConfigurationUrl);
            this.wellKnownConfigurationLoaded = true;
        }
    }

    public void stop() {
    }

    private static String readUrl(URL url) {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        try {
            int read;
            StringBuilder buffer = new StringBuilder();
            char[] chars = new char[1024];
            while ((read = reader.read(chars)) != -1) {
                buffer.append(chars, 0, read);
            }
            string = buffer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.error("Unable to read url {}", new Object[]{url, e});
                return null;
            }
        }
        reader.close();
        return string;
    }
}

