/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.web.facebook;

import io.meeds.oauth.facebook.FacebookAccessTokenContext;
import io.meeds.oauth.facebook.GateInFacebookProcessor;
import io.meeds.oauth.social.FacebookPrincipal;
import io.meeds.oauth.spi.InteractionState;
import io.meeds.oauth.spi.OAuthPrincipal;
import io.meeds.oauth.spi.OAuthProviderType;
import io.meeds.oauth.utils.OAuthUtils;
import io.meeds.oauth.web.OAuthProviderFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FacebookFilter
extends OAuthProviderFilter<FacebookAccessTokenContext> {
    @Override
    protected OAuthProviderType<FacebookAccessTokenContext> getOAuthProvider() {
        return this.getOauthProvider("FACEBOOK", FacebookAccessTokenContext.class);
    }

    @Override
    protected void initInteraction(HttpServletRequest request, HttpServletResponse response) {
        request.getSession().removeAttribute("_authState");
        request.getSession().removeAttribute("_verificationState");
    }

    @Override
    protected OAuthPrincipal<FacebookAccessTokenContext> getOAuthPrincipal(HttpServletRequest request, HttpServletResponse response, InteractionState<FacebookAccessTokenContext> interactionState) {
        FacebookAccessTokenContext accessTokenContext = interactionState.getAccessTokenContext();
        FacebookPrincipal principal = ((GateInFacebookProcessor)this.getOauthProviderProcessor()).getPrincipal(accessTokenContext);
        String avatarURL = ((GateInFacebookProcessor)this.getOauthProviderProcessor()).getAvatar(accessTokenContext);
        if (principal == null) {
            this.log.error((Object)"Principal was null");
            return null;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Finished Facebook OAuth2 flow with state: " + String.valueOf(interactionState)));
            this.log.trace((Object)("Facebook accessToken: " + principal.getAccessToken()));
        }
        OAuthPrincipal<FacebookAccessTokenContext> oauthPrincipal = OAuthUtils.convertFacebookPrincipalToOAuthPrincipal(principal, avatarURL, this.getOAuthProvider(), accessTokenContext);
        return oauthPrincipal;
    }

    @Override
    protected String obtainCustomScopeIfAvailable(HttpServletRequest httpRequest) {
        String customScope = super.obtainCustomScopeIfAvailable(httpRequest);
        if (customScope != null) {
            StringBuilder result = new StringBuilder();
            String[] scopes = customScope.split(" ");
            boolean first = true;
            for (String scope : scopes) {
                if (scope.equals("installed")) continue;
                if (!first) {
                    result.append(" ");
                }
                first = false;
                result.append(scope);
            }
            customScope = result.toString();
        }
        return customScope;
    }
}

