/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.shindig.social.opensocial.model.Activity;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.webui.utils.TimeConvertUtils;

@Path(value="social/people")
public class PeopleRestService
implements ResourceContainer {
    private static final String CONFIRMED_STATUS = "confirmed";
    private static final String PENDING_STATUS = "pending";
    private static final String INCOMING_STATUS = "incoming";
    private static final String IGNORED_STATUS = "ignored";
    private static final String WAITING_STATUS = "waiting";
    private static final String ALIEN_STATUS = "alien";
    private static final String INVITE_ACTION = "Invite";
    private static final String ACCEPT_ACTION = "Accept";
    private static final String DENY_ACTION = "Deny";
    private static final String REVOKE_ACTION = "Revoke";
    private static final String REMOVE_ACTION = "Remove";
    private static final String SPACE_MEMBER = "member_of_space";
    private static final String USER_TO_INVITE = "user_to_invite";
    private static final long SUGGEST_LIMIT = 20L;
    private static final int DEFAULT_LIMIT = 20;
    private String portalName_;
    private IdentityManager identityManager;
    private ActivityManager activityManager;
    private RelationshipManager relationshipManager;
    private SpaceService spaceService;

    @GET
    @Path(value="suggest.{format}")
    public Response suggestUsernames(@Context UriInfo uriInfo, @QueryParam(value="nameToSearch") String name, @QueryParam(value="currentUser") String currentUser, @QueryParam(value="typeOfRelation") String typeOfRelation, @QueryParam(value="spaceURL") String spaceURL, @PathParam(value="format") String format) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        ArrayList<Identity> excludedIdentityList = new ArrayList<Identity>();
        excludedIdentityList.add(Util.getViewerIdentity(currentUser));
        UserNameList nameList = new UserNameList();
        ProfileFilter filter = new ProfileFilter();
        filter.setName(name);
        filter.setCompany("");
        filter.setPosition("");
        filter.setSkills("");
        filter.setExcludedIdentityList(excludedIdentityList);
        List<Object> identities = Arrays.asList(this.getIdentityManager().getIdentitiesByProfileFilter("organization", filter, false).load(0, 20));
        Identity currentIdentity = this.getIdentityManager().getOrCreateIdentity("organization", currentUser, false);
        Space space = this.getSpaceService().getSpaceByUrl(spaceURL);
        if (PENDING_STATUS.equals(typeOfRelation)) {
            this.addToNameList(currentIdentity, this.getRelationshipManager().getPending(currentIdentity, identities), nameList);
        } else if (INCOMING_STATUS.equals(typeOfRelation)) {
            this.addToNameList(currentIdentity, this.getRelationshipManager().getIncoming(currentIdentity, identities), nameList);
        } else if (CONFIRMED_STATUS.equals(typeOfRelation)) {
            this.addToNameList(currentIdentity, this.getRelationshipManager().getConfirmed(currentIdentity, identities), nameList);
        } else if (SPACE_MEMBER.equals(typeOfRelation)) {
            this.addSpaceUserToList(identities, nameList, space, typeOfRelation);
        } else if (USER_TO_INVITE.equals(typeOfRelation)) {
            this.addSpaceUserToList(identities, nameList, space, typeOfRelation);
        } else {
            for (Identity identity : identities) {
                nameList.addName(identity.getProfile().getFullName());
            }
        }
        return Util.getResponse(nameList, uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="getprofile/data.json")
    public Response suggestUsernames(@Context UriInfo uriInfo, @QueryParam(value="search") String query) throws Exception {
        MediaType mediaType = Util.getMediaType("json", new String[]{"json"});
        ArrayList excludedIdentityList = new ArrayList();
        ProfileFilter filter = new ProfileFilter();
        filter.setName(query);
        filter.setCompany("");
        filter.setPosition("");
        filter.setSkills("");
        filter.setExcludedIdentityList(excludedIdentityList);
        List<Object> identities = Arrays.asList(this.getIdentityManager().getIdentitiesByProfileFilter("organization", filter, false).load(0, 20));
        ArrayList<UserInfo> userInfos = new ArrayList<UserInfo>(identities.size());
        for (Identity identity : identities) {
            UserInfo userInfo = new UserInfo(identity.getRemoteId());
            userInfo.setName(identity.getProfile().getFullName());
            userInfo.setAvatar(identity.getProfile().getAvatarUrl());
            userInfo.setType("contact");
            userInfos.add(userInfo);
        }
        return Util.getResponse(userInfos, uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="{portalName}/getConnections.{format}")
    public Response searchConnection(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @QueryParam(value="nameToSearch") String nameToSearch, @QueryParam(value="offset") int offset, @QueryParam(value="limit") int limit, @QueryParam(value="lang") String lang, @PathParam(value="format") String format) throws Exception {
        Identity[] identities;
        String[] supportedMediaType = new String[]{"json"};
        MediaType mediaType = Util.getMediaType(format, supportedMediaType);
        this.activityManager = Util.getActivityManager(portalName);
        this.relationshipManager = Util.getRelationshipManager(portalName);
        this.identityManager = Util.getIdentityManager(portalName);
        ArrayList<Identity> excludedIdentityList = new ArrayList<Identity>();
        Identity currentUser = Util.getIdentityManager(portalName).getOrCreateIdentity("organization", Util.getViewerId(uriInfo), true);
        excludedIdentityList.add(currentUser);
        ArrayList<HashMap<String, Object>> entitys = new ArrayList<HashMap<String, Object>>();
        if (nameToSearch == null) {
            identities = (Identity[])this.identityManager.getConnectionsWithListAccess(currentUser).load(offset, limit);
        } else {
            nameToSearch = nameToSearch.trim();
            ProfileFilter filter = new ProfileFilter();
            filter.setName(nameToSearch);
            filter.setExcludedIdentityList(excludedIdentityList);
            identities = (Identity[])this.relationshipManager.getConnectionsByFilter(currentUser, filter).load(offset, limit);
        }
        for (Identity identity : identities) {
            HashMap<String, Object> temp = this.getIdentityInfo(identity, lang);
            if (temp == null) continue;
            entitys.add(temp);
        }
        return Util.getResponse(entitys, uriInfo, mediaType, Response.Status.OK);
    }

    private HashMap<String, Object> getIdentityInfo(Identity existingIdentity, String lang) {
        RealtimeListAccess activityRealtimeListAccess = this.activityManager.getActivitiesWithListAccess(existingIdentity);
        if (activityRealtimeListAccess.getSize() == 0) {
            return null;
        }
        ExoSocialActivity lastestActivity = ((ExoSocialActivity[])activityRealtimeListAccess.load(0, 1))[0];
        return new ConnectionInfoRestOut(existingIdentity, (Activity)lastestActivity, lang);
    }

    @GET
    @Path(value="{portalName}/{currentUserName}/getPeopleInfo/{userId}.{format}")
    public Response getPeopleInfo(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @PathParam(value="currentUserName") String currentUserName, @PathParam(value="userId") String userId, @PathParam(value="format") String format, @QueryParam(value="updatedType") String updatedType) throws Exception {
        PeopleInfo peopleInfo = new PeopleInfo();
        MediaType mediaType = Util.getMediaType(format);
        this.portalName_ = portalName;
        Identity identity = this.getIdentityManager().getOrCreateIdentity("organization", userId, false);
        Identity currentIdentity = this.getIdentityManager().getOrCreateIdentity("organization", currentUserName, false);
        if (updatedType != null) {
            Relationship rel = this.getRelationshipManager().get(currentIdentity, identity);
            if (ACCEPT_ACTION.equals(updatedType)) {
                this.getRelationshipManager().confirm(rel);
            } else if (DENY_ACTION.equals(updatedType)) {
                this.getRelationshipManager().deny(rel);
            } else if (REVOKE_ACTION.equals(updatedType)) {
                this.getRelationshipManager().deny(rel);
            } else if (INVITE_ACTION.equals(updatedType)) {
                this.getRelationshipManager().invite(currentIdentity, identity);
            } else if (REMOVE_ACTION.equals(updatedType)) {
                this.getRelationshipManager().remove(rel);
            }
        }
        Relationship relationship = this.getRelationshipManager().get(currentIdentity, identity);
        peopleInfo.setRelationshipType(this.getRelationshipType(relationship, currentIdentity));
        RealtimeListAccess activitiesListAccess = this.getActivityManager().getActivitiesWithListAccess(identity);
        List activities = activitiesListAccess.loadAsList(0, 20);
        if (activities.size() > 0) {
            peopleInfo.setActivityTitle(((ExoSocialActivity)activities.get(0)).getTitle());
        } else {
            peopleInfo.setActivityTitle("No updates have been posted yet.");
        }
        peopleInfo.setAvatarURL((String)identity.getProfile().getProperty("avatarUrl"));
        return Util.getResponse(peopleInfo, uriInfo, mediaType, Response.Status.OK);
    }

    private void addToNameList(Identity currentIdentity, List<Relationship> identitiesHasRelation, UserNameList nameList) {
        for (Relationship relationship : identitiesHasRelation) {
            Identity identity = relationship.getPartner(currentIdentity);
            String fullName = identity.getProfile().getFullName();
            nameList.addName(fullName);
        }
    }

    private void addSpaceUserToList(List<Identity> identities, UserNameList nameList, Space space, String typeOfRelation) throws SpaceException {
        SpaceService spaceSrv = this.getSpaceService();
        for (Identity identity : identities) {
            String fullName = identity.getProfile().getFullName();
            String userName = (String)identity.getProfile().getProperty("username");
            if (SPACE_MEMBER.equals(typeOfRelation) && spaceSrv.isMember(space, userName)) {
                nameList.addName(fullName);
                continue;
            }
            if (!USER_TO_INVITE.equals(typeOfRelation) || spaceSrv.isInvited(space, userName) || spaceSrv.isPending(space, userName) || spaceSrv.isMember(space, userName)) continue;
            nameList.addName(userName);
        }
    }

    private String getRelationshipType(Relationship relationship, Identity identity) {
        if (relationship == null) {
            return ALIEN_STATUS;
        }
        if (relationship.getStatus() == Relationship.Type.PENDING) {
            if (relationship.getSender().equals((Object)identity)) {
                return WAITING_STATUS;
            }
            return PENDING_STATUS;
        }
        if (relationship.getStatus() == Relationship.Type.CONFIRMED) {
            return CONFIRMED_STATUS;
        }
        if (relationship.getStatus() == Relationship.Type.IGNORED) {
            return IGNORED_STATUS;
        }
        return ALIEN_STATUS;
    }

    public SpaceService getSpaceService() {
        if (this.spaceService == null) {
            PortalContainer portalContainer = (PortalContainer)ExoContainerContext.getCurrentContainer();
            this.spaceService = (SpaceService)portalContainer.getComponentInstanceOfType(SpaceService.class);
        }
        return this.spaceService;
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            PortalContainer portalContainer = (PortalContainer)ExoContainerContext.getCurrentContainer();
            this.identityManager = (IdentityManager)portalContainer.getComponentInstanceOfType(IdentityManager.class);
        }
        return this.identityManager;
    }

    private ActivityManager getActivityManager() {
        if (this.activityManager == null) {
            this.activityManager = (ActivityManager)this.getPortalContainer().getComponentInstanceOfType(ActivityManager.class);
        }
        return this.activityManager;
    }

    private RelationshipManager getRelationshipManager() {
        if (this.relationshipManager == null) {
            PortalContainer portalContainer = (PortalContainer)ExoContainerContext.getCurrentContainer();
            this.relationshipManager = (RelationshipManager)portalContainer.getComponentInstanceOfType(RelationshipManager.class);
        }
        return this.relationshipManager;
    }

    private PortalContainer getPortalContainer() {
        PortalContainer portalContainer = (PortalContainer)ExoContainerContext.getContainerByName((String)this.portalName_);
        if (portalContainer == null) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        return portalContainer;
    }

    @XmlRootElement
    public static class PeopleInfo {
        private String avatarURL;
        private String activityTitle;
        private String relationshipType;

        public String getActivityTitle() {
            return this.activityTitle;
        }

        public void setActivityTitle(String activityTitle) {
            this.activityTitle = activityTitle;
        }

        public String getAvatarURL() {
            return this.avatarURL;
        }

        public void setAvatarURL(String avatarURL) {
            this.avatarURL = avatarURL;
        }

        public String getRelationshipType() {
            return this.relationshipType;
        }

        public void setRelationshipType(String relationshipType) {
            this.relationshipType = relationshipType;
        }
    }

    @XmlRootElement
    public static class UserNameList {
        private List<String> _names;

        public void setNames(List<String> names) {
            this._names = names;
        }

        public List<String> getNames() {
            return this._names;
        }

        public void addName(String name) {
            if (this._names == null) {
                this._names = new ArrayList<String>();
            }
            this._names.add(name);
        }
    }

    public static class ConnectionInfoRestOut
    extends HashMap<String, Object> {
        public ConnectionInfoRestOut() {
            this.initialize();
        }

        public ConnectionInfoRestOut(Identity identity, Activity lastestActivity, String lang) {
            this.setDisplayName(identity.getProfile().getFullName());
            this.setAvatarUrl(Util.buildAbsoluteAvatarURL(identity));
            this.setProfileUrl(identity.getProfile().getUrl());
            this.setActivityTitle(lastestActivity.getTitle());
            Calendar calendar = Calendar.getInstance();
            calendar.setLenient(false);
            int gmtoffset = calendar.get(16) + calendar.get(15);
            calendar.setTimeInMillis(lastestActivity.getPostedTime() - (long)gmtoffset);
            this.setPrettyPostedTime(TimeConvertUtils.convertXTimeAgo((Date)calendar.getTime(), (String)"EEE,MMM dd,yyyy", (Locale)new Locale(lang), (int)TimeConvertUtils.MONTH));
            this.setPosition(identity.getProfile().getPosition());
            this.setActivityId(lastestActivity.getId());
        }

        public String getDisplayName() {
            return (String)this.get(Field.DISPLAY_NAME.toString());
        }

        public void setDisplayName(String displayName) {
            if (displayName != null) {
                this.put(Field.DISPLAY_NAME.toString(), displayName);
            } else {
                this.put(Field.DISPLAY_NAME.toString(), "");
            }
        }

        public String getAvatarUrl() {
            return (String)this.get(Field.AVATAR_URL.toString());
        }

        public void setAvatarUrl(String avatarUrl) {
            if (avatarUrl != null) {
                this.put(Field.AVATAR_URL.toString(), avatarUrl);
            } else {
                this.put(Field.AVATAR_URL.toString(), "");
            }
        }

        public String getProfileUrl() {
            return (String)this.get(Field.PROFILE_URL.toString());
        }

        public void setProfileUrl(String profileUrl) {
            if (profileUrl != null) {
                this.put(Field.PROFILE_URL.toString(), Util.getBaseUrl() + profileUrl);
            } else {
                this.put(Field.PROFILE_URL.toString(), "");
            }
        }

        public String getActivityTitle() {
            return (String)this.get(Field.ACTIVITY_TITLE.toString());
        }

        public void setActivityTitle(String activityTitle) {
            if (activityTitle != null) {
                this.put(Field.ACTIVITY_TITLE.toString(), activityTitle);
            } else {
                this.put(Field.ACTIVITY_TITLE.toString(), "");
            }
        }

        public String getPrettyPostedTime() {
            return (String)this.get((Object)Field.PRETTY_POSTED_TIME);
        }

        public void setPrettyPostedTime(String postedTime) {
            if (postedTime != null) {
                this.put(Field.PRETTY_POSTED_TIME.toString(), postedTime);
            } else {
                this.put(Field.PRETTY_POSTED_TIME.toString(), new Long(0L));
            }
        }

        public String getPosition() {
            return (String)this.get((Object)Field.POSITION);
        }

        public void setPosition(String position) {
            if (position != null) {
                this.put(Field.POSITION.toString(), position);
            } else {
                this.put(Field.POSITION.toString(), "");
            }
        }

        public String getActivityId() {
            return (String)this.get((Object)Field.ACTIVITY_ID);
        }

        public void setActivityId(String activityId) {
            if (activityId != null) {
                this.put(Field.ACTIVITY_ID.toString(), activityId);
            } else {
                this.put(Field.ACTIVITY_ID.toString(), "");
            }
        }

        private void initialize() {
            this.setActivityTitle("");
            this.setAvatarUrl("");
            this.setDisplayName("");
            this.setProfileUrl("");
            this.setActivityId("");
            this.setPosition("");
            this.setPrettyPostedTime("");
        }

        public static enum Field {
            DISPLAY_NAME("displayName"),
            AVATAR_URL("avatarURL"),
            PROFILE_URL("profileURL"),
            ACTIVITY_TITLE("activityTitle"),
            ACTIVITY_ID("activityId"),
            PRETTY_POSTED_TIME("prettyPostedTime"),
            POSITION("position");

            private final String fieldName;

            private Field(String string2) {
                this.fieldName = string2;
            }

            public String toString() {
                return this.fieldName;
            }
        }
    }

    public static class UserInfo {
        private static String AVATAR_URL = "/social-resources/skin/ShareImages/Avatar.gif";
        String id;
        String name;
        String avatar;
        String type;

        public UserInfo(String name) {
            this.name = name;
            this.id = "@" + name;
        }

        public String getId() {
            return this.id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setAvatar(String url) {
            this.avatar = url;
        }

        public String getAvatar() {
            if (this.avatar == null || this.avatar.length() == 0) {
                return AVATAR_URL;
            }
            return this.avatar;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

