/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest.api;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.api.ActivityStreamResources;
import org.exoplatform.social.service.rest.api.models.ActivityRestListOut;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class ActivityStreamResourcesTest
extends AbstractResourceTest {
    private final String RESOURCE_URL = "/api/social/v1-alpha3/portal/activity_stream/";
    private IdentityManager identityManager;
    private ActivityManager activityManager;
    private SpaceService spaceService;
    private RelationshipManager relationshipManager;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity demoIdentity;
    private List<ExoSocialActivity> tearDownActivityList;
    private List<Space> tearDownSpaceList;
    private List<Relationship> tearDownRelationshipList;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.activityManager = (ActivityManager)this.getContainer().getComponentInstanceOfType(ActivityManager.class);
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        this.relationshipManager = (RelationshipManager)this.getContainer().getComponentInstanceOfType(RelationshipManager.class);
        this.rootIdentity = new Identity("organization", "root");
        this.johnIdentity = new Identity("organization", "john");
        this.maryIdentity = new Identity("organization", "mary");
        this.demoIdentity = new Identity("organization", "demo");
        this.identityManager.saveIdentity(this.rootIdentity);
        this.identityManager.saveIdentity(this.johnIdentity);
        this.identityManager.saveIdentity(this.maryIdentity);
        this.identityManager.saveIdentity(this.demoIdentity);
        this.tearDownActivityList = new ArrayList<ExoSocialActivity>();
        this.tearDownSpaceList = new ArrayList<Space>();
        this.tearDownRelationshipList = new ArrayList<Relationship>();
        this.addResource(ActivityStreamResources.class, null);
    }

    @Override
    public void tearDown() throws Exception {
        for (Relationship relationship : this.tearDownRelationshipList) {
            this.relationshipManager.delete(relationship);
        }
        for (ExoSocialActivity activity : this.tearDownActivityList) {
            this.activityManager.deleteActivity(activity);
        }
        for (Space space : this.tearDownSpaceList) {
            this.spaceService.deleteSpace(space);
        }
        this.removeResource(ActivityStreamResources.class);
        super.tearDown();
    }

    public void testGetActivityStreamByIdentityIdGeneralCase() throws Exception {
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/123456.json";
        this.testAccessResourceAsAnonymous("GET", resourceUrl, null, null);
        this.testAccessNotFoundResourceWithAuthentication("demo", "GET", resourceUrl, null);
        this.testStatusCodeOfResource("demo", "GET", "/api/social/v1-alpha3/portal/activity_stream/123456.xml", null, null, Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
        this.testStatusCodeOfResource("demo", "GET", "/api/social/v1-alpha3/portal/activity_stream/123456.rss", null, null, Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
        this.testStatusCodeOfResource("demo", "GET", "/api/social/v1-alpha3/portal/activity_stream/123456.atom", null, null, Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
        this.testStatusCodeOfResource("demo", "GET", "/api/social/v1-alpha3/wrongPortalContainerName/activity_stream/123456.json", null, null, Response.Status.BAD_REQUEST.getStatusCode());
    }

    public void testDefaultGetActivityStreamByIdentityIdWithJsonFormat() throws Exception {
        ArrayList<ExoSocialActivity> emptyList = new ArrayList<ExoSocialActivity>();
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/" + this.demoIdentity.getId() + ".json";
        this.startSessionAs("john");
        ContainerResponse containerResponse1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse1.getStatus() must return: 200", (int)200, (int)containerResponse1.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(emptyList, (ActivityRestListOut)containerResponse1.getEntity());
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse2.getStatus() must return 200", (int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List demoActivities = this.activityManager.getActivitiesWithListAccess(this.demoIdentity).loadAsList(0, 20);
        this.compareActivities(demoActivities, (ActivityRestListOut)containerResponse2.getEntity());
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        String resourceUrl2 = "/api/social/v1-alpha3/portal/activity_stream/" + spaceIdentity.getId() + ".json";
        this.testAccessResourceWithoutPermission("john", "GET", resourceUrl2, null);
        this.startSessionAs("demo");
        ContainerResponse containerResponse3 = this.service("GET", resourceUrl2, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse3.getStatus() must return 200", (int)200, (int)containerResponse3.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse3.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(emptyList, (ActivityRestListOut)containerResponse3.getEntity());
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        ContainerResponse containerResponse4 = this.service("GET", resourceUrl2, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse4.getStatus() must return 200", (int)200, (int)containerResponse4.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse4.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List spaceActivities = this.activityManager.getActivitiesWithListAccess(spaceIdentity).loadAsList(0, 20);
        this.compareActivities(spaceActivities, (ActivityRestListOut)containerResponse4.getEntity());
    }

    public void testMeParamGetActivityStreamByIdentityIdWithJsonFormat() throws Exception {
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/me.json";
        this.startSessionAs("demo");
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse2.getStatus() must return 200", (int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List demoActivities = this.activityManager.getActivitiesWithListAccess(this.demoIdentity).loadAsList(0, 20);
        this.compareActivities(demoActivities, (ActivityRestListOut)containerResponse2.getEntity());
    }

    public void testLimitGetActivityStreamByIdentityIdWithJsonFormat() throws Exception {
        ArrayList<ExoSocialActivity> emptyList = new ArrayList<ExoSocialActivity>();
        int limit = 10;
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/" + this.demoIdentity.getId() + ".json?limit=" + limit;
        this.startSessionAs("john");
        ContainerResponse containerResponse1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse1.getStatus() must return: 200", (int)200, (int)containerResponse1.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(emptyList, (ActivityRestListOut)containerResponse1.getEntity());
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse.getStatus() must return 200", (int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List demoActivities = this.activityManager.getActivitiesWithListAccess(this.demoIdentity).loadAsList(0, limit);
        this.compareActivities(demoActivities, (ActivityRestListOut)containerResponse2.getEntity());
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        String resourceUrl2 = "/api/social/v1-alpha3/portal/activity_stream/" + spaceIdentity.getId() + ".json?limit=" + limit;
        this.testAccessResourceWithoutPermission("john", "GET", resourceUrl2, null);
        this.startSessionAs("demo");
        ContainerResponse containerResponse3 = this.service("GET", resourceUrl2, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse3.getStatus() must return 200", (int)200, (int)containerResponse3.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse3.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(emptyList, (ActivityRestListOut)containerResponse3.getEntity());
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        ContainerResponse containerResponse4 = this.service("GET", resourceUrl2, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse4.getStatus() must return 200", (int)200, (int)containerResponse4.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse4.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List spaceActivities = this.activityManager.getActivitiesWithListAccess(spaceIdentity).loadAsList(0, limit);
        this.compareActivities(spaceActivities, (ActivityRestListOut)containerResponse4.getEntity());
    }

    public void testSinceIdGetActivityStreamByIdentityIdWithJsonFormat() throws Exception {
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/" + this.demoIdentity.getId() + ".json?since_id=" + 123456;
        this.testAccessNotFoundResourceWithAuthentication("john", "GET", resourceUrl, null);
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        ExoSocialActivity baseActivity = (ExoSocialActivity)this.activityManager.getActivitiesWithListAccess(this.demoIdentity).loadAsList(0, 20).get(0);
        resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/" + this.demoIdentity.getId() + ".json?since_id=" + baseActivity.getId();
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        ContainerResponse containerResponse1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse1.getStatus() must return 200", (int)200, (int)containerResponse1.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List newerActivities = this.activityManager.getActivitiesWithListAccess(this.demoIdentity).loadNewer((Object)baseActivity, 10);
        this.compareActivities(newerActivities, (ActivityRestListOut)containerResponse1.getEntity());
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        String resourceUrl2 = "/api/social/v1-alpha3/portal/activity_stream/" + spaceIdentity.getId() + ".json?since_id=" + 123456;
        this.testAccessResourceWithoutPermission("john", "GET", resourceUrl2, null);
        this.testAccessNotFoundResourceWithAuthentication("demo", "GET", resourceUrl2, null);
        this.startSessionAs("demo");
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        ExoSocialActivity baseActivity2 = (ExoSocialActivity)this.activityManager.getActivitiesWithListAccess(spaceIdentity).loadAsList(0, 1).get(0);
        resourceUrl2 = "/api/social/v1-alpha3/portal/activity_stream/" + spaceIdentity.getId() + ".json?since_id=" + baseActivity2.getId();
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        newerActivities = this.activityManager.getActivitiesWithListAccess(spaceIdentity).loadNewer((Object)baseActivity2, 10);
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl2, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse2.getStatus() must return: 200", (int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(newerActivities, (ActivityRestListOut)containerResponse2.getEntity());
    }

    public void testMaxIdGetActivityStreamByIdentityIdWithJsonFormat() throws Exception {
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/" + this.demoIdentity.getId() + ".json?max_id=" + 123456;
        this.testAccessNotFoundResourceWithAuthentication("john", "GET", resourceUrl, null);
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        ExoSocialActivity baseActivity = (ExoSocialActivity)this.activityManager.getActivitiesWithListAccess(this.demoIdentity).loadAsList(0, 5).get(4);
        resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/" + this.demoIdentity.getId() + ".json?max_id=" + baseActivity.getId();
        ContainerResponse containerResponse1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse1.getStatus() must return 200", (int)200, (int)containerResponse1.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List olderActivities = this.activityManager.getActivitiesWithListAccess(this.demoIdentity).loadOlder((Object)baseActivity, 20);
        this.compareActivities(olderActivities, (ActivityRestListOut)containerResponse1.getEntity());
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        String resourceUrl2 = "/api/social/v1-alpha3/portal/activity_stream/" + spaceIdentity.getId() + ".json?max_id=" + 123456;
        this.testAccessResourceWithoutPermission("john", "GET", resourceUrl2, null);
        this.testAccessNotFoundResourceWithAuthentication("demo", "GET", resourceUrl2, null);
        this.startSessionAs("demo");
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        ExoSocialActivity baseActivity2 = (ExoSocialActivity)this.activityManager.getActivitiesWithListAccess(spaceIdentity).loadAsList(0, 5).get(4);
        resourceUrl2 = "/api/social/v1-alpha3/portal/activity_stream/" + spaceIdentity.getId() + ".json?max_id=" + baseActivity2.getId();
        olderActivities = this.activityManager.getActivitiesWithListAccess(spaceIdentity).loadOlder((Object)baseActivity2, 20);
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl2, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse2.getStatus() must return: 200", (int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(olderActivities, (ActivityRestListOut)containerResponse2.getEntity());
    }

    public void testNumberOfCommentsGetActivityStreamByIdentityWithJsonFormat() throws Exception {
        ArrayList<ExoSocialActivity> emptyList = new ArrayList<ExoSocialActivity>();
        int numberOfComments = 3;
        this.startSessionAs("john");
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        List demoActivities = this.activityManager.getActivitiesWithListAccess(this.demoIdentity).loadAsList(0, 20);
        this.createComment((ExoSocialActivity)demoActivities.get(0), this.demoIdentity, numberOfComments + 1);
        this.createComment((ExoSocialActivity)demoActivities.get(0), this.johnIdentity, 1);
        this.createComment((ExoSocialActivity)demoActivities.get(3), this.johnIdentity, 5);
        this.createComment((ExoSocialActivity)demoActivities.get(7), this.demoIdentity, 6);
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/" + this.demoIdentity.getId() + ".json?number_of_comments=" + numberOfComments;
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse2.getStatus() must return 200", (int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        demoActivities = this.activityManager.getActivitiesWithListAccess(this.demoIdentity).loadAsList(0, 20);
        this.compareActivities(demoActivities, (ActivityRestListOut)containerResponse2.getEntity());
        this.compareNumberOfComments(demoActivities, (ActivityRestListOut)containerResponse2.getEntity(), numberOfComments);
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/" + spaceIdentity.getId() + ".json?number_of_comments=" + numberOfComments;
        this.testAccessResourceWithoutPermission("john", "GET", resourceUrl, null);
        this.startSessionAs("demo");
        ContainerResponse containerResponse3 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse3.getStatus() must return 200", (int)200, (int)containerResponse3.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse3.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(emptyList, (ActivityRestListOut)containerResponse3.getEntity());
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        List spaceActivities = this.activityManager.getActivitiesWithListAccess(spaceIdentity).loadAsList(0, 20);
        this.createComment((ExoSocialActivity)spaceActivities.get(1), this.demoIdentity, numberOfComments + 2);
        ContainerResponse containerResponse4 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse4.getStatus() must return 200", (int)200, (int)containerResponse4.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse4.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        spaceActivities = this.activityManager.getActivitiesWithListAccess(spaceIdentity).loadAsList(0, 20);
        this.compareActivities(spaceActivities, (ActivityRestListOut)containerResponse4.getEntity());
        this.compareNumberOfComments(spaceActivities, (ActivityRestListOut)containerResponse4.getEntity(), numberOfComments);
    }

    public void testNumberOfLikesGetActivityStreamByIdentityIdWithJsonFormat() throws Exception {
        int numberOfLikes = 2;
        this.startSessionAs("john");
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.connectIdentities(this.demoIdentity, this.maryIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        List demoActivities = this.activityManager.getActivitiesWithListAccess(this.demoIdentity).loadAsList(0, 20);
        ExoSocialActivity likeActivity1 = (ExoSocialActivity)demoActivities.get(0);
        this.activityManager.saveLike(likeActivity1, this.demoIdentity);
        this.activityManager.saveLike(likeActivity1, this.johnIdentity);
        this.activityManager.saveLike(likeActivity1, this.maryIdentity);
        ExoSocialActivity likeActivity2 = (ExoSocialActivity)demoActivities.get(3);
        this.activityManager.saveLike(likeActivity2, this.demoIdentity);
        this.activityManager.saveLike(likeActivity2, this.johnIdentity);
        ExoSocialActivity likeActivity3 = (ExoSocialActivity)demoActivities.get(4);
        this.activityManager.saveLike(likeActivity3, this.johnIdentity);
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/" + this.demoIdentity.getId() + ".json?number_of_likes=" + numberOfLikes;
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse2.getStatus() must return 200", (int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        demoActivities = this.activityManager.getActivitiesWithListAccess(this.demoIdentity).loadAsList(0, 20);
        this.compareActivities(demoActivities, (ActivityRestListOut)containerResponse2.getEntity());
        this.compareNumberOfLikes(demoActivities, (ActivityRestListOut)containerResponse2.getEntity(), numberOfLikes);
    }

    public void testAllQueryParamsGetActivityStreamByIdentityIdWithJsonFormat() throws Exception {
        int limit = 10;
        int numberOfComments = 2;
        int numberOfLikes = 2;
        this.startSessionAs("john");
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.connectIdentities(this.demoIdentity, this.maryIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        List demoActivities = this.activityManager.getActivitiesWithListAccess(this.demoIdentity).loadAsList(0, limit);
        this.createComment((ExoSocialActivity)demoActivities.get(3), this.demoIdentity, 2);
        this.createComment((ExoSocialActivity)demoActivities.get(3), this.johnIdentity, 2);
        this.createComment((ExoSocialActivity)demoActivities.get(3), this.maryIdentity, 2);
        this.createComment((ExoSocialActivity)demoActivities.get(4), this.johnIdentity, 1);
        this.createComment((ExoSocialActivity)demoActivities.get(6), this.maryIdentity, 7);
        this.createComment((ExoSocialActivity)demoActivities.get(6), this.johnIdentity, 4);
        this.activityManager.saveLike((ExoSocialActivity)demoActivities.get(3), this.demoIdentity);
        this.activityManager.saveLike((ExoSocialActivity)demoActivities.get(3), this.johnIdentity);
        this.activityManager.saveLike((ExoSocialActivity)demoActivities.get(3), this.maryIdentity);
        this.activityManager.saveLike((ExoSocialActivity)demoActivities.get(5), this.maryIdentity);
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/" + this.demoIdentity.getId() + ".json?limit=" + limit + "&number_of_likes=" + numberOfLikes + "&number_of_comments=" + numberOfComments;
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse2.getStatus() must return 200", (int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        demoActivities = this.activityManager.getActivitiesWithListAccess(this.demoIdentity).loadAsList(0, limit);
        this.compareActivities(demoActivities, (ActivityRestListOut)containerResponse2.getEntity());
        this.compareNumberOfComments(demoActivities, (ActivityRestListOut)containerResponse2.getEntity(), numberOfComments);
        this.compareNumberOfLikes(demoActivities, (ActivityRestListOut)containerResponse2.getEntity(), numberOfLikes);
    }

    public void testAllInvalidOptionalQueryParamsGetActivityStreamByIdentityIdWithJsonFormat() throws Exception {
        this.startSessionAs("john");
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.connectIdentities(this.demoIdentity, this.maryIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        List demoActivities = this.activityManager.getActivitiesWithListAccess(this.demoIdentity).loadAsList(0, 20);
        this.createComment((ExoSocialActivity)demoActivities.get(3), this.demoIdentity, 2);
        this.createComment((ExoSocialActivity)demoActivities.get(3), this.johnIdentity, 2);
        this.createComment((ExoSocialActivity)demoActivities.get(3), this.maryIdentity, 2);
        this.createComment((ExoSocialActivity)demoActivities.get(4), this.johnIdentity, 1);
        this.createComment((ExoSocialActivity)demoActivities.get(6), this.maryIdentity, 7);
        this.createComment((ExoSocialActivity)demoActivities.get(6), this.johnIdentity, 4);
        this.activityManager.saveLike((ExoSocialActivity)demoActivities.get(3), this.demoIdentity);
        this.activityManager.saveLike((ExoSocialActivity)demoActivities.get(3), this.johnIdentity);
        this.activityManager.saveLike((ExoSocialActivity)demoActivities.get(3), this.maryIdentity);
        this.activityManager.saveLike((ExoSocialActivity)demoActivities.get(5), this.maryIdentity);
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/" + this.demoIdentity.getId() + ".json?limit=-1&number_of_likes=-1&number_of_comments=-1";
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse2.getStatus() must return 200", (int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        demoActivities = this.activityManager.getActivitiesWithListAccess(this.demoIdentity).loadAsList(0, 20);
        this.compareActivities(demoActivities, (ActivityRestListOut)containerResponse2.getEntity());
        this.compareNumberOfComments(demoActivities, (ActivityRestListOut)containerResponse2.getEntity(), 0);
        this.compareNumberOfLikes(demoActivities, (ActivityRestListOut)containerResponse2.getEntity(), 0);
    }

    public void testGetActivityFeedOfAuthenticatedGeneralCase() throws Exception {
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/feed.json";
        this.testAccessResourceAsAnonymous("GET", resourceUrl, null, null);
        this.testStatusCodeOfResource("demo", "GET", "/api/social/v1-alpha3/portal/activity_stream/feed.xml", null, null, Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
        this.testStatusCodeOfResource("demo", "GET", "/api/social/v1-alpha3/portal/activity_stream/feed.rss", null, null, Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
        this.testStatusCodeOfResource("demo", "GET", "/api/social/v1-alpha3/portal/activity_stream/feed.atom", null, null, Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
        this.testStatusCodeOfResource("demo", "GET", "/api/social/v1-alpha3/wrongPortalContainerName/activity_stream/feed.json", null, null, Response.Status.BAD_REQUEST.getStatusCode());
    }

    public void testDefaultGetActivityFeedOfAuthenticatedWithJsonFormat() throws Exception {
        ArrayList<ExoSocialActivity> emptyList = new ArrayList<ExoSocialActivity>();
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/feed.json";
        this.startSessionAs("demo");
        ContainerResponse containerResponse1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse1.getStatus() must return: 200", (int)200, (int)containerResponse1.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(emptyList, (ActivityRestListOut)containerResponse1.getEntity());
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse2.getStatus() must return 200", (int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List demoActivitiesFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, 15);
        this.compareActivities(demoActivitiesFeed, (ActivityRestListOut)containerResponse2.getEntity());
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        ContainerResponse containerResponse3 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse3.getStatus() must return 200", (int)200, (int)containerResponse3.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse3.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        demoActivitiesFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, 40);
        this.compareActivities(demoActivitiesFeed, (ActivityRestListOut)containerResponse3.getEntity());
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        Space space = this.spaceService.getSpaceByPrettyName("my_space_1");
        this.spaceService.addMember(space, "demo");
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        ContainerResponse containerResponse4 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse4.getStatus() must return 200", (int)200, (int)containerResponse4.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse4.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        demoActivitiesFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, 40);
        this.compareActivities(demoActivitiesFeed, (ActivityRestListOut)containerResponse4.getEntity());
    }

    public void testLimitGetActivityFeedOfAuthenticatedWithJsonFormat() throws Exception {
        int limit = 10;
        ArrayList<ExoSocialActivity> emptyList = new ArrayList<ExoSocialActivity>();
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/feed.json?limit=" + limit;
        this.startSessionAs("demo");
        ContainerResponse containerResponse1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse1.getStatus() must return: 200", (int)200, (int)containerResponse1.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(emptyList, (ActivityRestListOut)containerResponse1.getEntity());
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse2.getStatus() must return 200", (int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List demoActivitiesFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, limit);
        this.compareActivities(demoActivitiesFeed, (ActivityRestListOut)containerResponse2.getEntity());
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        ContainerResponse containerResponse3 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse3.getStatus() must return 200", (int)200, (int)containerResponse3.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse3.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        demoActivitiesFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, limit);
        this.compareActivities(demoActivitiesFeed, (ActivityRestListOut)containerResponse3.getEntity());
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        Space space = this.spaceService.getSpaceByPrettyName("my_space_1");
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        ContainerResponse containerResponse4 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse4.getStatus() must return 200", (int)200, (int)containerResponse4.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse4.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        demoActivitiesFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, limit);
        this.compareActivities(demoActivitiesFeed, (ActivityRestListOut)containerResponse4.getEntity());
    }

    public void testSinceIdGetActivityFeedOfAuthenticatedWithJsonFormat() throws Exception {
        this.startSessionAs("demo");
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/feed.json?since_id=123456";
        this.testAccessNotFoundResourceWithAuthentication("demo", "GET", resourceUrl, null);
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        ExoSocialActivity baseActivity = (ExoSocialActivity)this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, 20).get(14);
        resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/feed.json?since_id=" + baseActivity.getId();
        ContainerResponse containerResponse1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse1.getStatus() must return 200", (int)200, (int)containerResponse1.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List demoActivitiesFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadNewer((Object)baseActivity, 20);
        this.compareActivities(demoActivitiesFeed, (ActivityRestListOut)containerResponse1.getEntity());
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        baseActivity = (ExoSocialActivity)this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, 20).get(14);
        String resourceUrl2 = "/api/social/v1-alpha3/portal/activity_stream/feed.json?since_id=" + baseActivity.getId();
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl2, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse2.getStatus() must return 200", (int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List demoActivitiesFeed2 = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadNewer((Object)baseActivity, 20);
        this.compareActivities(demoActivitiesFeed2, (ActivityRestListOut)containerResponse2.getEntity());
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        Space space = this.spaceService.getSpaceByPrettyName("my_space_1");
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        baseActivity = (ExoSocialActivity)this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, 40).get(29);
        resourceUrl2 = "/api/social/v1-alpha3/portal/activity_stream/feed.json?since_id=" + baseActivity.getId();
        ContainerResponse containerResponse3 = this.service("GET", resourceUrl2, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse3.getStatus() must return 200", (int)200, (int)containerResponse3.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse3.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        demoActivitiesFeed2 = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadNewer((Object)baseActivity, 40);
        this.compareActivities(demoActivitiesFeed2, (ActivityRestListOut)containerResponse3.getEntity());
    }

    public void testMaxIdGetActivityFeedOfAuthenticatedWithJsonFormat() throws Exception {
        this.startSessionAs("demo");
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/feed.json?max_id=123456";
        this.testAccessNotFoundResourceWithAuthentication("demo", "GET", resourceUrl, null);
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        ExoSocialActivity baseActivity = (ExoSocialActivity)this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, 20).get(0);
        resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/feed.json?max_id=" + baseActivity.getId();
        ContainerResponse containerResponse1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse1.getStatus() must return 200", (int)200, (int)containerResponse1.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List demoActivitiesFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadOlder((Object)baseActivity, 20);
        this.compareActivities(demoActivitiesFeed, (ActivityRestListOut)containerResponse1.getEntity());
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        Space space = this.spaceService.getSpaceByPrettyName("my_space_1");
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        ExoSocialActivity baseActivity2 = (ExoSocialActivity)this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, 40).get(0);
        String resourceUrl2 = "/api/social/v1-alpha3/portal/activity_stream/feed.json?max_id=" + baseActivity2.getId();
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl2, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse2.getStatus() must return 200", (int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List demoActivitiesFeed2 = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadOlder((Object)baseActivity2, 40);
        this.compareActivities(demoActivitiesFeed2, (ActivityRestListOut)containerResponse2.getEntity());
    }

    public void testNumberOfCommentsGetActivityFeedOfAuthenticatedWithJsonFormat() throws Exception {
        ArrayList<ExoSocialActivity> emptyList = new ArrayList<ExoSocialActivity>();
        int numberOfComments = 5;
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/feed.json?number_of_comments=" + numberOfComments;
        this.startSessionAs("demo");
        ContainerResponse containerResponse1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse1.getStatus() must return: 200", (int)200, (int)containerResponse1.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(emptyList, (ActivityRestListOut)containerResponse1.getEntity());
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        List demoActivitiesFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, 20);
        for (ExoSocialActivity activity : demoActivitiesFeed) {
            this.createComment(activity, this.demoIdentity, 10);
        }
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse2.getStatus() must return 200", (int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        demoActivitiesFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, 20);
        this.compareActivities(demoActivitiesFeed, (ActivityRestListOut)containerResponse2.getEntity());
        this.compareNumberOfComments(demoActivitiesFeed, (ActivityRestListOut)containerResponse2.getEntity(), numberOfComments);
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        ContainerResponse containerResponse3 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse3.getStatus() must return 200", (int)200, (int)containerResponse3.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse3.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List demoActivitiesFeed2 = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, 40);
        this.compareActivities(demoActivitiesFeed2, (ActivityRestListOut)containerResponse3.getEntity());
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        Space space = this.spaceService.getSpaceByPrettyName("my_space_1");
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        RealtimeListAccess spaceActivities = this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.demoIdentity);
        for (ExoSocialActivity activity : (ExoSocialActivity[])spaceActivities.load(0, 20)) {
            this.createComment(activity, this.demoIdentity, 10);
        }
        ContainerResponse containerResponse4 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse4.getStatus() must return 200", (int)200, (int)containerResponse4.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse4.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        demoActivitiesFeed2 = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, 100);
        this.compareActivities(demoActivitiesFeed2, (ActivityRestListOut)containerResponse4.getEntity());
        this.compareNumberOfComments(demoActivitiesFeed2, (ActivityRestListOut)containerResponse4.getEntity(), numberOfComments);
    }

    public void testNumberOfLikesGetActivityFeedOfAuthenticatedWithJsonFormat() throws Exception {
        ArrayList<ExoSocialActivity> emptyList = new ArrayList<ExoSocialActivity>();
        int numberOfLikes = 2;
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/feed.json?number_of_likes=" + numberOfLikes;
        this.startSessionAs("demo");
        ContainerResponse containerResponse1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse1.getStatus() must return: 200", (int)200, (int)containerResponse1.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(emptyList, (ActivityRestListOut)containerResponse1.getEntity());
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.connectIdentities(this.demoIdentity, this.maryIdentity, true);
        this.connectIdentities(this.demoIdentity, this.rootIdentity, true);
        this.connectIdentities(this.johnIdentity, this.maryIdentity, true);
        this.connectIdentities(this.johnIdentity, this.rootIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        List demoActivitiesFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, 20);
        for (ExoSocialActivity activity : demoActivitiesFeed) {
            this.activityManager.saveLike(activity, this.demoIdentity);
            this.activityManager.saveLike(activity, this.johnIdentity);
            this.activityManager.saveLike(activity, this.maryIdentity);
            this.activityManager.saveLike(activity, this.rootIdentity);
        }
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse2.getStatus() must return 200", (int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        demoActivitiesFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, 20);
        this.compareActivities(demoActivitiesFeed, (ActivityRestListOut)containerResponse2.getEntity());
        this.compareNumberOfLikes(demoActivitiesFeed, (ActivityRestListOut)containerResponse2.getEntity(), numberOfLikes);
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        ContainerResponse containerResponse3 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse3.getStatus() must return 200", (int)200, (int)containerResponse3.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse3.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List demoActivitiesFeed2 = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, 40);
        this.compareActivities(demoActivitiesFeed2, (ActivityRestListOut)containerResponse3.getEntity());
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        Space space = this.spaceService.getSpaceByPrettyName("my_space_1");
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        RealtimeListAccess demoSpaceActivities = this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.demoIdentity);
        for (ExoSocialActivity activity : (ExoSocialActivity[])demoSpaceActivities.load(0, 20)) {
            this.activityManager.saveLike(activity, this.demoIdentity);
            this.activityManager.saveLike(activity, this.johnIdentity);
            this.activityManager.saveLike(activity, this.maryIdentity);
            this.activityManager.saveLike(activity, this.rootIdentity);
        }
        ContainerResponse containerResponse4 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse4.getStatus() must return 200", (int)200, (int)containerResponse4.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse4.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        demoActivitiesFeed2 = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, 100);
        this.compareActivities(demoActivitiesFeed2, (ActivityRestListOut)containerResponse4.getEntity());
        this.compareNumberOfLikes(demoActivitiesFeed2, (ActivityRestListOut)containerResponse4.getEntity(), numberOfLikes);
    }

    public void testAllQueryParamsGetActivityFeedOfAuthenticatedWithJsonFormat() throws Exception {
        int limit = 10;
        int since_id = 123456;
        int numberOfComments = 5;
        int numberOfLikes = 2;
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/feed.json?limit=" + limit + "&since_id=" + since_id + "&number_of_comments=" + numberOfComments + "@number_of_likes=" + numberOfLikes;
        this.startSessionAs("demo");
        this.testAccessNotFoundResourceWithAuthentication("demo", "GET", resourceUrl, null);
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.connectIdentities(this.demoIdentity, this.maryIdentity, true);
        this.connectIdentities(this.demoIdentity, this.rootIdentity, true);
        this.connectIdentities(this.johnIdentity, this.maryIdentity, true);
        this.connectIdentities(this.johnIdentity, this.rootIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        List demoActivitiesFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, 20);
        for (ExoSocialActivity activity : demoActivitiesFeed) {
            this.createComment(activity, this.demoIdentity, 10);
            this.activityManager.saveLike(activity, this.demoIdentity);
            this.activityManager.saveLike(activity, this.johnIdentity);
            this.activityManager.saveLike(activity, this.maryIdentity);
            this.activityManager.saveLike(activity, this.rootIdentity);
        }
        ExoSocialActivity baseActivity = (ExoSocialActivity)this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, 20).get(14);
        resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/feed.json?limit=" + limit + "&since_id=" + baseActivity.getId() + "&number_of_comments=" + numberOfComments + "&number_of_likes=" + numberOfLikes;
        ContainerResponse containerResponse1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse1.getStatus() must return 200", (int)200, (int)containerResponse1.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        demoActivitiesFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadNewer((Object)baseActivity, limit);
        this.compareActivities(demoActivitiesFeed, (ActivityRestListOut)containerResponse1.getEntity());
        this.compareNumberOfComments(demoActivitiesFeed, (ActivityRestListOut)containerResponse1.getEntity(), numberOfComments);
        this.compareNumberOfLikes(demoActivitiesFeed, (ActivityRestListOut)containerResponse1.getEntity(), numberOfLikes);
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        Space space = this.spaceService.getSpaceByPrettyName("my_space_1");
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        RealtimeListAccess spaceActivities = this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.demoIdentity);
        for (ExoSocialActivity activity : (ExoSocialActivity[])spaceActivities.load(0, 20)) {
            this.createComment(activity, this.demoIdentity, 10);
            this.activityManager.saveLike(activity, this.demoIdentity);
            this.activityManager.saveLike(activity, this.johnIdentity);
            this.activityManager.saveLike(activity, this.maryIdentity);
            this.activityManager.saveLike(activity, this.rootIdentity);
        }
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse2.getStatus() must return 200", (int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List demoActivitiesFeed2 = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, limit);
        this.compareNumberOfComments(demoActivitiesFeed2, (ActivityRestListOut)containerResponse2.getEntity(), numberOfComments);
        this.compareNumberOfLikes(demoActivitiesFeed2, (ActivityRestListOut)containerResponse2.getEntity(), numberOfLikes);
    }

    public void testGeneralCaseGetActivityConnectionsOfAuthenticated() throws Exception {
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/xyz.json";
        this.testAccessNotFoundResourceWithAuthentication("demo", "GET", resourceUrl, null);
        this.testStatusCodeOfResource("demo", "GET", "/api/social/v1-alpha3/portal/activity_stream/connections.xml", null, null, Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
        this.testStatusCodeOfResource("demo", "GET", "/api/social/v1-alpha3/portal/activity_stream/connections.rss", null, null, Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
        this.testStatusCodeOfResource("demo", "GET", "/api/social/v1-alpha3/portal/activity_stream/connections.atom", null, null, Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
        this.testStatusCodeOfResource("demo", "GET", "/api/social/v1-alpha3/wrongPortalContainerName/activity_stream/connections.json", null, null, Response.Status.BAD_REQUEST.getStatusCode());
        resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/connections.json";
        this.startSessionAs("john");
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        ContainerResponse rsp = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)("Response's status must be: " + Response.Status.OK.getStatusCode()), (int)Response.Status.OK.getStatusCode(), (int)rsp.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)rsp.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(new ArrayList<ExoSocialActivity>(), (ActivityRestListOut)rsp.getEntity());
        this.endSession();
    }

    public void testDefaultGetActivityConnectionsOfAuthenticatedWithJsonFormat() throws Exception {
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/connections.json";
        this.startSessionAs("demo");
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        ContainerResponse rsp1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)("Response's status must be: " + Response.Status.OK.getStatusCode()), (int)Response.Status.OK.getStatusCode(), (int)rsp1.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)rsp1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List demoActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity).loadAsList(0, 20);
        this.compareActivities(demoActivities, (ActivityRestListOut)rsp1.getEntity());
        this.endSession();
    }

    public void testLimitGetActivityConnectionsOfAuthenticatedWithJsonFormat() throws Exception {
        ArrayList<ExoSocialActivity> emptyList = new ArrayList<ExoSocialActivity>();
        int limit = 10;
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/connections.json?limit=" + limit;
        this.startSessionAs("demo");
        ContainerResponse rsp = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)("Response's status must be: " + Response.Status.OK.getStatusCode()), (int)Response.Status.OK.getStatusCode(), (int)rsp.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)rsp.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(emptyList, (ActivityRestListOut)rsp.getEntity());
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        ContainerResponse rsp1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)("Response's status must be: " + Response.Status.OK.getStatusCode()), (int)Response.Status.OK.getStatusCode(), (int)rsp1.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)rsp1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List demoActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity).loadAsList(0, limit);
        this.compareActivities(demoActivities, (ActivityRestListOut)rsp1.getEntity());
        limit = 3;
        resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/connections.json?limit=" + limit;
        rsp1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)("Response's status must be: " + Response.Status.OK.getStatusCode()), (int)Response.Status.OK.getStatusCode(), (int)rsp1.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)rsp1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        demoActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity).loadAsList(0, limit);
        this.compareActivities(demoActivities, (ActivityRestListOut)rsp1.getEntity());
        this.endSession();
    }

    public void testSinceIdGetActivityConnectionsOfAuthenticatedWithJsonFormat() throws Exception {
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/connections.json?since_id=123456";
        this.testAccessNotFoundResourceWithAuthentication("john", "GET", resourceUrl, null);
        this.startSessionAs("demo");
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.connectIdentities(this.demoIdentity, this.maryIdentity, true);
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.createActivities(this.johnIdentity, this.demoIdentity, 10);
        this.createActivities(this.maryIdentity, this.demoIdentity, 10);
        ExoSocialActivity baseActivity = (ExoSocialActivity)this.activityManager.getActivitiesOfConnectionsWithListAccess(this.johnIdentity).loadAsList(0, 20).get(0);
        resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/connections.json?since_id=" + baseActivity.getId();
        ContainerResponse rsp = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)("Response's status must be: " + Response.Status.OK.getStatusCode()), (int)Response.Status.OK.getStatusCode(), (int)rsp.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)rsp.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List newerActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity).loadNewer((Object)baseActivity, 20);
        this.compareActivities(newerActivities, (ActivityRestListOut)rsp.getEntity());
        this.endSession();
    }

    public void testMaxIdGetActivityConnectionsOfAuthenticatedWithJsonFormat() throws Exception {
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/connections.json?max_id=123456";
        this.testAccessNotFoundResourceWithAuthentication("john", "GET", resourceUrl, null);
        this.startSessionAs("demo");
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        ExoSocialActivity baseActivity = (ExoSocialActivity)this.activityManager.getActivitiesOfConnectionsWithListAccess(this.johnIdentity).loadAsList(0, 5).get(4);
        resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/connections.json?max_id=" + baseActivity.getId();
        ContainerResponse rsp = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)("Response's status must be: " + Response.Status.OK.getStatusCode()), (int)Response.Status.OK.getStatusCode(), (int)rsp.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)rsp.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List olderActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity).loadOlder((Object)baseActivity, 20);
        this.compareActivities(olderActivities, (ActivityRestListOut)rsp.getEntity());
        this.endSession();
    }

    public void testNumberOfCommentsGetActivityConnectionsOfAuthenticatedWithJsonFormat() throws Exception {
        int numberOfComments = 3;
        this.startSessionAs("demo");
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        List demoActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity).loadAsList(0, 20);
        for (ExoSocialActivity act : demoActivities) {
            this.createComment(act, this.johnIdentity, 5);
        }
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/connections.json?number_of_comments=" + numberOfComments;
        ContainerResponse rsp1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)("Response's status must be: " + Response.Status.OK.getStatusCode()), (int)Response.Status.OK.getStatusCode(), (int)rsp1.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)rsp1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        demoActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity).loadAsList(0, 20);
        this.compareActivities(demoActivities, (ActivityRestListOut)rsp1.getEntity());
        this.compareNumberOfComments(demoActivities, (ActivityRestListOut)rsp1.getEntity(), numberOfComments);
        this.endSession();
    }

    public void testNumberOfLikesGetActivityConnectionsOfAuthenticatedWithJsonFormat() throws Exception {
        int numberOfLikes = 3;
        this.startSessionAs("demo");
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        List demoActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity).loadAsList(0, 20);
        for (ExoSocialActivity act : demoActivities) {
            this.activityManager.saveLike(act, this.demoIdentity);
            this.activityManager.saveLike(act, this.johnIdentity);
            this.activityManager.saveLike(act, this.maryIdentity);
            this.activityManager.saveLike(act, this.rootIdentity);
        }
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/connections.json?number_of_likes=" + numberOfLikes;
        ContainerResponse rsp1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)("Response's status must be: " + Response.Status.OK.getStatusCode()), (int)Response.Status.OK.getStatusCode(), (int)rsp1.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)rsp1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        demoActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity).loadAsList(0, 20);
        this.compareActivities(demoActivities, (ActivityRestListOut)rsp1.getEntity());
        this.compareNumberOfLikes(demoActivities, (ActivityRestListOut)rsp1.getEntity(), numberOfLikes);
        this.endSession();
    }

    public void testFullParamsGetActivityConnectionsOfAuthenticatedWithJsonFormat() throws Exception {
        int limit = 3;
        int numberOfComments = 3;
        int numberOfLikes = 3;
        this.startSessionAs("demo");
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        List demoActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity).loadAsList(0, 20);
        for (ExoSocialActivity act : demoActivities) {
            this.createComment(act, this.johnIdentity, 5);
            this.activityManager.saveLike(act, this.demoIdentity);
            this.activityManager.saveLike(act, this.johnIdentity);
            this.activityManager.saveLike(act, this.maryIdentity);
            this.activityManager.saveLike(act, this.rootIdentity);
        }
        ExoSocialActivity baseSinceIdActivity = (ExoSocialActivity)this.activityManager.getActivitiesOfConnectionsWithListAccess(this.johnIdentity).loadAsList(0, 5).get(4);
        ExoSocialActivity baseMaxIdActivity = (ExoSocialActivity)this.activityManager.getActivitiesOfConnectionsWithListAccess(this.johnIdentity).loadAsList(0, 5).get(4);
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/connections.json?limit=" + limit + "&since_id=" + baseSinceIdActivity.getId() + "&max_id=" + baseMaxIdActivity.getId() + "&number_of_comments=" + numberOfComments + "&number_of_likes=" + numberOfLikes;
        ContainerResponse rsp1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)("Response's status must be: " + Response.Status.OK.getStatusCode()), (int)Response.Status.OK.getStatusCode(), (int)rsp1.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)rsp1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        demoActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity).loadNewer((Object)baseSinceIdActivity, limit);
        this.compareActivities(demoActivities, (ActivityRestListOut)rsp1.getEntity());
        this.compareNumberOfComments(demoActivities, (ActivityRestListOut)rsp1.getEntity(), numberOfComments);
        this.compareNumberOfLikes(demoActivities, (ActivityRestListOut)rsp1.getEntity(), numberOfLikes);
        this.endSession();
    }

    public void testGetActivitySpacesOfAuthenticatedGeneralCase() throws Exception {
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/12356/spaces.json";
        this.testAccessNotFoundResourceWithAuthentication("demo", "GET", resourceUrl, null);
        this.testStatusCodeOfResource("demo", "GET", "/api/social/v1-alpha3/portal/activity_stream/spaces.xml", null, null, Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
        this.testStatusCodeOfResource("demo", "GET", "/api/social/v1-alpha3/portal/activity_stream/spaces.rss", null, null, Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
        this.testStatusCodeOfResource("demo", "GET", "/api/social/v1-alpha3/portal/activity_stream/spaces.atom", null, null, Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
        this.testStatusCodeOfResource("demo", "GET", "/api/social/v1-alpha3/wrongPortalContainerName/activity_stream/spaces.json", null, null, Response.Status.BAD_REQUEST.getStatusCode());
    }

    public void testDefaultGetActivitySpacesOfAuthenticatedWithJsonFormat() throws Exception {
        ArrayList<ExoSocialActivity> emptyList = new ArrayList<ExoSocialActivity>();
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/spaces.json";
        this.startSessionAs("john");
        ContainerResponse containerResponse1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse1.getStatus() must return: 200", (int)200, (int)containerResponse1.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(emptyList, (ActivityRestListOut)containerResponse1.getEntity());
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        String resourceUrl2 = "/api/social/v1-alpha3/portal/activity_stream/spaces.json";
        this.startSessionAs("demo");
        ContainerResponse containerResponse3 = this.service("GET", resourceUrl2, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse3.getStatus() must return 200", (int)200, (int)containerResponse3.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse3.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(emptyList, (ActivityRestListOut)containerResponse3.getEntity());
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        ContainerResponse containerResponse4 = this.service("GET", resourceUrl2, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse4.getStatus() must return 200", (int)200, (int)containerResponse4.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse4.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List spaceActivities = this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.demoIdentity).loadAsList(0, 20);
        this.compareActivities(spaceActivities, (ActivityRestListOut)containerResponse4.getEntity());
        this.endSession();
    }

    public void testLimitGetActivitySpacesOfAuthenticatedWithJsonFormat() throws Exception {
        ArrayList<ExoSocialActivity> emptyList = new ArrayList<ExoSocialActivity>();
        int limit = 10;
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/spaces.json?limit=" + limit;
        this.startSessionAs("john");
        ContainerResponse containerResponse1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse1.getStatus() must return: 200", (int)200, (int)containerResponse1.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(emptyList, (ActivityRestListOut)containerResponse1.getEntity());
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        String resourceUrl2 = "/api/social/v1-alpha3/portal/activity_stream/spaces.json?limit=" + limit;
        this.startSessionAs("demo");
        ContainerResponse containerResponse3 = this.service("GET", resourceUrl2, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse3.getStatus() must return 200", (int)200, (int)containerResponse3.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse3.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(emptyList, (ActivityRestListOut)containerResponse3.getEntity());
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        ContainerResponse containerResponse4 = this.service("GET", resourceUrl2, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse4.getStatus() must return 200", (int)200, (int)containerResponse4.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse4.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List spaceActivities = this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.demoIdentity).loadAsList(0, limit);
        this.compareActivities(spaceActivities, (ActivityRestListOut)containerResponse4.getEntity());
        this.endSession();
    }

    public void testSinceIdGetActivitySpacesOfAuthenticatedWithJsonFormat() throws Exception {
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        this.startSessionAs("demo");
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        ExoSocialActivity baseActivity = (ExoSocialActivity)this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.demoIdentity).loadAsList(0, 1).get(0);
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/spaces.json?since_id=" + baseActivity.getId();
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        List newerActivities = this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.demoIdentity).loadNewer((Object)baseActivity, 10);
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse2.getStatus() must return: 200", (int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(newerActivities, (ActivityRestListOut)containerResponse2.getEntity());
        this.endSession();
    }

    public void testMaxIdGetActivitySpacesOfAuthenticatedWithJsonFormat() throws Exception {
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        this.startSessionAs("demo");
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        ExoSocialActivity baseActivity = (ExoSocialActivity)this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.demoIdentity).loadAsList(0, 5).get(4);
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/spaces.json?max_id=" + baseActivity.getId();
        List olderActivities = this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.demoIdentity).loadOlder((Object)baseActivity, 20);
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse2.getStatus() must return: 200", (int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(olderActivities, (ActivityRestListOut)containerResponse2.getEntity());
        this.endSession();
    }

    public void testNumberOfCommentsGetActivitySpacesOfAuthenticatedWithJsonFormat() throws Exception {
        ArrayList<ExoSocialActivity> emptyList = new ArrayList<ExoSocialActivity>();
        int numberOfComments = 3;
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/spaces.json?number_of_comments=" + numberOfComments;
        this.startSessionAs("demo");
        ContainerResponse containerResponse3 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse3.getStatus() must return 200", (int)200, (int)containerResponse3.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse3.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(emptyList, (ActivityRestListOut)containerResponse3.getEntity());
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        List spaceActivities = this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.demoIdentity).loadAsList(0, 20);
        this.createComment((ExoSocialActivity)spaceActivities.get(1), this.demoIdentity, numberOfComments + 2);
        ContainerResponse containerResponse4 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse4.getStatus() must return 200", (int)200, (int)containerResponse4.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse3.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        spaceActivities = this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.demoIdentity).loadAsList(0, 20);
        this.compareActivities(spaceActivities, (ActivityRestListOut)containerResponse4.getEntity());
        this.compareNumberOfComments(spaceActivities, (ActivityRestListOut)containerResponse4.getEntity(), numberOfComments);
        this.endSession();
    }

    public void testNumberOfLikesGetActivitySpacesOfAuthenticatedWithJsonFormat() throws Exception {
        int numberOfLikes = 2;
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/spaces.json?number_of_likes=" + numberOfLikes;
        this.startSessionAs("demo");
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        List demoActivities = this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.demoIdentity).loadAsList(0, 20);
        ExoSocialActivity likeActivity = (ExoSocialActivity)demoActivities.get(0);
        this.activityManager.saveLike(likeActivity, this.demoIdentity);
        this.activityManager.saveLike(likeActivity, this.johnIdentity);
        this.activityManager.saveLike(likeActivity, this.maryIdentity);
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse2.getStatus() must return 200", (int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(demoActivities, (ActivityRestListOut)containerResponse2.getEntity());
        this.compareNumberOfLikes(demoActivities, (ActivityRestListOut)containerResponse2.getEntity(), numberOfLikes);
    }

    public void testDefaultGetActivityFeedByTimestampOfAuthenticatedWithJsonFormat() throws Exception {
        ArrayList<ExoSocialActivity> emptyList = new ArrayList<ExoSocialActivity>();
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/feedByTimestamp.json";
        this.startSessionAs("demo");
        ContainerResponse containerResponse1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse1.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(emptyList, (ActivityRestListOut)containerResponse1.getEntity());
        System.out.println(containerResponse1.getResponse().toString());
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List demoActivitiesFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, 15);
        this.compareActivities(demoActivitiesFeed, (ActivityRestListOut)containerResponse2.getEntity());
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        ContainerResponse containerResponse3 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse3.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse3.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        demoActivitiesFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, 40);
        this.compareActivities(demoActivitiesFeed, (ActivityRestListOut)containerResponse3.getEntity());
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        Space space = this.spaceService.getSpaceByPrettyName("my_space_1");
        this.spaceService.addMember(space, "demo");
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        ContainerResponse containerResponse4 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse4.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse4.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        demoActivitiesFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, 40);
        this.compareActivities(demoActivitiesFeed, (ActivityRestListOut)containerResponse4.getEntity());
    }

    public void testLimitGetActivityFeedByTimestampOfAuthenticatedWithJsonFormat() throws Exception {
        int limit = 10;
        ArrayList<ExoSocialActivity> emptyList = new ArrayList<ExoSocialActivity>();
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/feedByTimestamp.json?limit=" + limit;
        this.startSessionAs("demo");
        ContainerResponse containerResponse1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse1.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(emptyList, (ActivityRestListOut)containerResponse1.getEntity());
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List demoActivitiesFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, limit);
        this.compareActivities(demoActivitiesFeed, (ActivityRestListOut)containerResponse2.getEntity());
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        ContainerResponse containerResponse3 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse3.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse3.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        demoActivitiesFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, limit);
        this.compareActivities(demoActivitiesFeed, (ActivityRestListOut)containerResponse3.getEntity());
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        Space space = this.spaceService.getSpaceByPrettyName("my_space_1");
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        ContainerResponse containerResponse4 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse4.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse4.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        demoActivitiesFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, limit);
        this.compareActivities(demoActivitiesFeed, (ActivityRestListOut)containerResponse4.getEntity());
    }

    public void testSinceTimeGetActivityFeedByTimestampOfAuthenticatedWithJsonFormat() throws Exception {
        this.startSessionAs("demo");
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        Long sinceTime = ((ExoSocialActivity)this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, 20).get(14)).getPostedTime();
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/feedByTimestamp.json?since_time=" + sinceTime;
        ContainerResponse containerResponse1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse1.getStatus() must return 200", (int)200, (int)containerResponse1.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List demoActivitiesFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadNewer(sinceTime, 20);
        this.compareActivities(demoActivitiesFeed, (ActivityRestListOut)containerResponse1.getEntity());
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        Long sinceTime2 = ((ExoSocialActivity)this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, 20).get(14)).getPostedTime();
        String resourceUrl2 = "/api/social/v1-alpha3/portal/activity_stream/feedByTimestamp.json?since_time=" + sinceTime2;
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl2, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse2.getStatus() must return 200", (int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List demoActivitiesFeed2 = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadNewer(sinceTime2, 20);
        this.compareActivities(demoActivitiesFeed2, (ActivityRestListOut)containerResponse2.getEntity());
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        Space space = this.spaceService.getSpaceByPrettyName("my_space_1");
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        sinceTime2 = ((ExoSocialActivity)this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, 40).get(29)).getPostedTime();
        resourceUrl2 = "/api/social/v1-alpha3/portal/activity_stream/feedByTimestamp.json?since_time=" + sinceTime2;
        ContainerResponse containerResponse3 = this.service("GET", resourceUrl2, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse3.getStatus() must return 200", (int)200, (int)containerResponse3.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse3.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        demoActivitiesFeed2 = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadNewer(sinceTime2, 40);
        this.compareActivities(demoActivitiesFeed2, (ActivityRestListOut)containerResponse3.getEntity());
    }

    public void testMaxTimeGetActivityFeedByTimestampOfAuthenticatedWithJsonFormat() throws Exception {
        this.startSessionAs("demo");
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        Long maxTime = ((ExoSocialActivity)this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, 20).get(0)).getPostedTime();
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/feedByTimestamp.json?max_time=" + maxTime;
        ContainerResponse containerResponse1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse1.getStatus() must return 200", (int)200, (int)containerResponse1.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List demoActivitiesFeed = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadOlder(maxTime, 20);
        this.compareActivities(demoActivitiesFeed, (ActivityRestListOut)containerResponse1.getEntity());
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        Space space = this.spaceService.getSpaceByPrettyName("my_space_1");
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        Long maxTime2 = ((ExoSocialActivity)this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadAsList(0, 40).get(0)).getPostedTime();
        String resourceUrl2 = "/api/social/v1-alpha3/portal/activity_stream/feedByTimestamp.json?max_time=" + maxTime2;
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl2, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse2.getStatus() must return 200", (int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List demoActivitiesFeed2 = this.activityManager.getActivityFeedWithListAccess(this.demoIdentity).loadOlder(maxTime2, 40);
        this.compareActivities(demoActivitiesFeed2, (ActivityRestListOut)containerResponse2.getEntity());
    }

    public void testDefaultGetActivityStreamByIdentityIdWithJsonFormatWithTimestamp() throws Exception {
        ArrayList<ExoSocialActivity> emptyList = new ArrayList<ExoSocialActivity>();
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/" + this.demoIdentity.getId() + "ByTimestamp.json";
        this.startSessionAs("john");
        ContainerResponse containerResponse1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((String)"containerResponse1.getStatus() must return: 200", (int)200, (int)containerResponse1.getStatus());
        ActivityStreamResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(emptyList, (ActivityRestListOut)containerResponse1.getEntity());
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List demoActivities = this.activityManager.getActivitiesWithListAccess(this.demoIdentity).loadAsList(0, 20);
        this.compareActivities(demoActivities, (ActivityRestListOut)containerResponse2.getEntity());
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        String resourceUrl2 = "/api/social/v1-alpha3/portal/activity_stream/" + spaceIdentity.getId() + "ByTimestamp.json";
        this.testAccessResourceWithoutPermission("john", "GET", resourceUrl2, null);
        this.startSessionAs("demo");
        ContainerResponse containerResponse3 = this.service("GET", resourceUrl2, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse3.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse3.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(emptyList, (ActivityRestListOut)containerResponse3.getEntity());
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        ContainerResponse containerResponse4 = this.service("GET", resourceUrl2, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse4.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse4.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List spaceActivities = this.activityManager.getActivitiesWithListAccess(spaceIdentity).loadAsList(0, 20);
        this.compareActivities(spaceActivities, (ActivityRestListOut)containerResponse4.getEntity());
    }

    public void testMeParamGetActivityStreamByIdentityIdWithJsonFormatWithTimestamp() throws Exception {
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/meByTimestamp.json";
        this.startSessionAs("demo");
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List demoActivities = this.activityManager.getActivitiesWithListAccess(this.demoIdentity).loadAsList(0, 20);
        this.compareActivities(demoActivities, (ActivityRestListOut)containerResponse2.getEntity());
    }

    public void testLimitGetActivityStreamByIdentityIdWithJsonFormatWithTimestamp() throws Exception {
        ArrayList<ExoSocialActivity> emptyList = new ArrayList<ExoSocialActivity>();
        int limit = 10;
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/" + this.demoIdentity.getId() + "ByTimestamp.json?limit=" + limit;
        this.startSessionAs("john");
        ContainerResponse containerResponse1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse1.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(emptyList, (ActivityRestListOut)containerResponse1.getEntity());
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List demoActivities = this.activityManager.getActivitiesWithListAccess(this.demoIdentity).loadAsList(0, limit);
        this.compareActivities(demoActivities, (ActivityRestListOut)containerResponse2.getEntity());
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        String resourceUrl2 = "/api/social/v1-alpha3/portal/activity_stream/" + spaceIdentity.getId() + "ByTimestamp.json?limit=" + limit;
        this.testAccessResourceWithoutPermission("john", "GET", resourceUrl2, null);
        this.startSessionAs("demo");
        ContainerResponse containerResponse3 = this.service("GET", resourceUrl2, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse3.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse3.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(emptyList, (ActivityRestListOut)containerResponse3.getEntity());
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        ContainerResponse containerResponse4 = this.service("GET", resourceUrl2, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse4.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse4.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List spaceActivities = this.activityManager.getActivitiesWithListAccess(spaceIdentity).loadAsList(0, limit);
        this.compareActivities(spaceActivities, (ActivityRestListOut)containerResponse4.getEntity());
    }

    public void testSinceTimeGetActivityStreamByIdentityIdWithJsonFormat() throws Exception {
        this.startSessionAs("demo");
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        Long sinceTime = ((ExoSocialActivity)this.activityManager.getActivitiesWithListAccess(this.demoIdentity).loadAsList(0, 20).get(0)).getPostedTime();
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/" + this.demoIdentity.getId() + "ByTimestamp.json?since_time=" + sinceTime;
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        ContainerResponse containerResponse1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse1.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List newerActivities = this.activityManager.getActivitiesWithListAccess(this.demoIdentity).loadNewer(sinceTime, 10);
        this.compareActivities(newerActivities, (ActivityRestListOut)containerResponse1.getEntity());
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        this.startSessionAs("demo");
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        Long sinceTime2 = ((ExoSocialActivity)this.activityManager.getActivitiesWithListAccess(spaceIdentity).loadAsList(0, 1).get(0)).getPostedTime();
        String resourceUrl2 = "/api/social/v1-alpha3/portal/activity_stream/" + spaceIdentity.getId() + "ByTimestamp.json?since_time=" + sinceTime2;
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        newerActivities = this.activityManager.getActivitiesWithListAccess(spaceIdentity).loadNewer(sinceTime2, 10);
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl2, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(newerActivities, (ActivityRestListOut)containerResponse2.getEntity());
    }

    public void testMaxTimeGetActivityStreamByIdentityIdWithJsonFormat() throws Exception {
        this.startSessionAs("demo");
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        Long maxTime = ((ExoSocialActivity)this.activityManager.getActivitiesWithListAccess(this.demoIdentity).loadAsList(0, 5).get(4)).getPostedTime();
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/" + this.demoIdentity.getId() + "ByTimestamp.json?max_time=" + maxTime;
        ContainerResponse containerResponse1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse1.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List olderActivities = this.activityManager.getActivitiesWithListAccess(this.demoIdentity).loadOlder(maxTime, 20);
        this.compareActivities(olderActivities, (ActivityRestListOut)containerResponse1.getEntity());
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        this.startSessionAs("demo");
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        Long maxTime2 = ((ExoSocialActivity)this.activityManager.getActivitiesWithListAccess(spaceIdentity).loadAsList(0, 5).get(4)).getPostedTime();
        String resourceUrl2 = "/api/social/v1-alpha3/portal/activity_stream/" + spaceIdentity.getId() + "ByTimestamp.json?max_time=" + maxTime2;
        olderActivities = this.activityManager.getActivitiesWithListAccess(spaceIdentity).loadOlder(maxTime2, 20);
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl2, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(olderActivities, (ActivityRestListOut)containerResponse2.getEntity());
    }

    public void testDefaultGetActivityConnectionsOfAuthenticatedWithJsonFormatWithTimestamp() throws Exception {
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/connectionsByTimestamp.json";
        this.startSessionAs("demo");
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        ContainerResponse rsp1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)rsp1.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)rsp1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List demoActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity).loadAsList(0, 20);
        this.compareActivities(demoActivities, (ActivityRestListOut)rsp1.getEntity());
        this.endSession();
    }

    public void testLimitGetActivityConnectionsOfAuthenticatedWithJsonFormatWithTimestamp() throws Exception {
        ArrayList<ExoSocialActivity> emptyList = new ArrayList<ExoSocialActivity>();
        int limit = 10;
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/connectionsByTimestamp.json?limit=" + limit;
        this.startSessionAs("demo");
        ContainerResponse rsp = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)rsp.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)rsp.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(emptyList, (ActivityRestListOut)rsp.getEntity());
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        ContainerResponse rsp1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)rsp1.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)rsp1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List demoActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity).loadAsList(0, limit);
        this.compareActivities(demoActivities, (ActivityRestListOut)rsp1.getEntity());
        limit = 3;
        resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/connectionsByTimestamp.json?limit=" + limit;
        rsp1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)rsp1.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)rsp1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        demoActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity).loadAsList(0, limit);
        this.compareActivities(demoActivities, (ActivityRestListOut)rsp1.getEntity());
        this.endSession();
    }

    public void testSinceTimeGetActivityConnectionsOfAuthenticatedWithJsonFormat() throws Exception {
        this.startSessionAs("demo");
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.connectIdentities(this.demoIdentity, this.maryIdentity, true);
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.createActivities(this.johnIdentity, this.demoIdentity, 10);
        this.createActivities(this.maryIdentity, this.demoIdentity, 10);
        Long sinceTime = ((ExoSocialActivity)this.activityManager.getActivitiesOfConnectionsWithListAccess(this.johnIdentity).loadAsList(0, 20).get(0)).getPostedTime();
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/connectionsByTimestamp.json?since_time=" + sinceTime;
        ContainerResponse rsp = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)rsp.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)rsp.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List newerActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity).loadNewer(sinceTime, 20);
        this.compareActivities(newerActivities, (ActivityRestListOut)rsp.getEntity());
        this.endSession();
    }

    public void testMaxTimeGetActivityConnectionsOfAuthenticatedWithJsonFormat() throws Exception {
        this.startSessionAs("demo");
        this.createActivities(this.demoIdentity, this.demoIdentity, 10);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        this.createActivities(this.johnIdentity, this.demoIdentity, 5);
        Long maxTime = ((ExoSocialActivity)this.activityManager.getActivitiesOfConnectionsWithListAccess(this.johnIdentity).loadAsList(0, 5).get(4)).getPostedTime();
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/connectionsByTimestamp.json?max_time=" + maxTime;
        ContainerResponse rsp = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)rsp.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)rsp.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List olderActivities = this.activityManager.getActivitiesOfConnectionsWithListAccess(this.demoIdentity).loadOlder(maxTime, 20);
        this.compareActivities(olderActivities, (ActivityRestListOut)rsp.getEntity());
        this.endSession();
    }

    public void testDefaultGetActivitySpacesOfAuthenticatedWithJsonFormatWithTimestamp() throws Exception {
        ArrayList<ExoSocialActivity> emptyList = new ArrayList<ExoSocialActivity>();
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/spacesByTimestamp.json";
        this.startSessionAs("john");
        ContainerResponse containerResponse1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse1.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(emptyList, (ActivityRestListOut)containerResponse1.getEntity());
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        String resourceUrl2 = "/api/social/v1-alpha3/portal/activity_stream/spacesByTimestamp.json";
        this.startSessionAs("demo");
        ContainerResponse containerResponse3 = this.service("GET", resourceUrl2, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse3.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse3.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(emptyList, (ActivityRestListOut)containerResponse3.getEntity());
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        ContainerResponse containerResponse4 = this.service("GET", resourceUrl2, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse4.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse4.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List spaceActivities = this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.demoIdentity).loadAsList(0, 20);
        this.compareActivities(spaceActivities, (ActivityRestListOut)containerResponse4.getEntity());
        this.endSession();
    }

    public void testLimitGetActivitySpacesOfAuthenticatedWithJsonFormatWithTimestamp() throws Exception {
        ArrayList<ExoSocialActivity> emptyList = new ArrayList<ExoSocialActivity>();
        int limit = 10;
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/spacesByTimestamp.json?limit=" + limit;
        this.startSessionAs("john");
        ContainerResponse containerResponse1 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse1.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse1.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(emptyList, (ActivityRestListOut)containerResponse1.getEntity());
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        String resourceUrl2 = "/api/social/v1-alpha3/portal/activity_stream/spacesByTimestamp.json?limit=" + limit;
        this.startSessionAs("demo");
        ContainerResponse containerResponse3 = this.service("GET", resourceUrl2, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse3.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse3.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(emptyList, (ActivityRestListOut)containerResponse3.getEntity());
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        ContainerResponse containerResponse4 = this.service("GET", resourceUrl2, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse4.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse4.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        List spaceActivities = this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.demoIdentity).loadAsList(0, limit);
        this.compareActivities(spaceActivities, (ActivityRestListOut)containerResponse4.getEntity());
        this.endSession();
    }

    public void testSinceTimeGetActivitySpacesOfAuthenticatedWithJsonFormat() throws Exception {
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        this.startSessionAs("demo");
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        Long sinceTime = ((ExoSocialActivity)this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.demoIdentity).loadAsList(0, 1).get(0)).getPostedTime();
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/spacesByTimestamp.json?since_time=" + sinceTime;
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        List newerActivities = this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.demoIdentity).loadNewer(sinceTime, 10);
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(newerActivities, (ActivityRestListOut)containerResponse2.getEntity());
        this.endSession();
    }

    public void testMaxTimeGetActivitySpacesOfAuthenticatedWithJsonFormat() throws Exception {
        this.createSpaces(1);
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        this.startSessionAs("demo");
        this.createActivities(spaceIdentity, spaceIdentity, 10);
        this.createActivities(this.demoIdentity, spaceIdentity, 5);
        Long maxTime = ((ExoSocialActivity)this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.demoIdentity).loadAsList(0, 5).get(4)).getPostedTime();
        String resourceUrl = "/api/social/v1-alpha3/portal/activity_stream/spacesByTimestamp.json?max_time=" + maxTime;
        List olderActivities = this.activityManager.getActivitiesOfUserSpacesWithListAccess(this.demoIdentity).loadOlder(maxTime, 20);
        ContainerResponse containerResponse2 = this.service("GET", resourceUrl, "", null, null);
        ActivityStreamResourcesTest.assertEquals((int)200, (int)containerResponse2.getStatus());
        ActivityStreamResourcesTest.assertTrue((boolean)containerResponse2.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        this.compareActivities(olderActivities, (ActivityRestListOut)containerResponse2.getEntity());
        this.endSession();
    }

    private void createActivities(Identity posterIdentity, Identity identityStream, int number) {
        for (int i = 0; i < number; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("title " + i);
            activity.setUserId(posterIdentity.getId());
            this.activityManager.saveActivityNoReturn(identityStream, (ExoSocialActivity)activity);
            this.tearDownActivityList.add((ExoSocialActivity)activity);
        }
    }

    private void createComment(ExoSocialActivity existingActivity, Identity posterIdentity, int number) {
        for (int i = 0; i < number; ++i) {
            ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
            comment.setTitle("comment " + i);
            comment.setUserId(posterIdentity.getId());
            this.activityManager.saveComment(existingActivity, (ExoSocialActivity)comment);
        }
    }

    private void createSpaces(int number) {
        for (int i = 0; i < number; ++i) {
            Space space = new Space();
            space.setDisplayName("my space " + number);
            space.setPrettyName(space.getDisplayName());
            space.setRegistration("open");
            space.setDescription("add new space " + number);
            space.setType("classic");
            space.setVisibility("public");
            space.setRegistration("validation");
            space.setPriority("2");
            space.setGroupId("/spaces/my_space_" + number);
            String[] managers = new String[]{"demo"};
            String[] members = new String[]{"mary", "demo"};
            String[] invitedUsers = new String[]{"john"};
            String[] pendingUsers = new String[]{};
            space.setInvitedUsers(invitedUsers);
            space.setPendingUsers(pendingUsers);
            space.setManagers(managers);
            space.setMembers(members);
            space.setUrl("/space/" + space.getPrettyName());
            try {
                this.spaceService.saveSpace(space, true);
                this.tearDownSpaceList.add(space);
                continue;
            }
            catch (SpaceException e) {
                ActivityStreamResourcesTest.fail((String)"Could not create a new space");
            }
        }
    }

    private void connectIdentities(Identity senderIdentity, Identity receiverIdentity, boolean beConfirmed) {
        this.relationshipManager.inviteToConnect(senderIdentity, receiverIdentity);
        if (beConfirmed) {
            this.relationshipManager.confirm(receiverIdentity, senderIdentity);
        }
        this.tearDownRelationshipList.add(this.relationshipManager.get(senderIdentity, receiverIdentity));
    }
}

