/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.binding;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.binding.model.GroupSpaceBinding;
import org.exoplatform.social.core.binding.model.GroupSpaceBindingOperationReport;
import org.exoplatform.social.core.binding.model.GroupSpaceBindingQueue;
import org.exoplatform.social.core.binding.model.GroupSpaceBindingReportUser;
import org.exoplatform.social.core.binding.spi.GroupSpaceBindingService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.GroupSpaceBindingRestResources;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.GroupNodeEntity;
import org.exoplatform.social.rest.entity.GroupSpaceBindingEntity;
import org.exoplatform.social.rest.entity.GroupSpaceBindingOperationReportEntity;
import org.exoplatform.social.rest.entity.SpaceEntity;

@Path(value="v1/social/spaceGroupBindings")
@Api(tags={"v1/social/groupSpaceBindings"}, value="v1/social/groupSpaceBindings", description="API  to manage the binding between a space and an organization group")
public class GroupSpaceBindingRestResourcesV1
implements GroupSpaceBindingRestResources {
    private GroupSpaceBindingService groupSpaceBindingService;
    private SpaceService spaceService;
    private SimpleDateFormat formater = new SimpleDateFormat("yy-MM-dd_HH-mm-ss");
    private UserACL userACL;
    private static final Log LOG = ExoLogger.getLogger(GroupSpaceBindingRestResourcesV1.class);

    public GroupSpaceBindingRestResourcesV1(SpaceService spaceService, GroupSpaceBindingService groupSpaceBindingService, UserACL userACL) {
        this.groupSpaceBindingService = groupSpaceBindingService;
        this.spaceService = spaceService;
        this.userACL = userACL;
    }

    @Override
    @GET
    @RolesAllowed(value={"administrators"})
    @Produces(value={"application/json"})
    @Path(value="{spaceId}")
    @ApiOperation(value="Gets list of binding for a space.", httpMethod="GET", response=Response.class, notes="Returns a list of bindings in the following cases if the authenticated user is an administrator.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getBindingsBySpaceId(@Context UriInfo uriInfo, @ApiParam(value="Space id", required=true) @PathParam(value="spaceId") String spaceId, @ApiParam(value="Offset", defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", defaultValue="10") @QueryParam(value="limit") int limit, @ApiParam(value="Returning the number of spaces found or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize) throws Exception {
        if (!this.userACL.isSuperUser() && !this.userACL.isUserInGroup(this.userACL.getAdminGroups())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        List removedSpaceBindingsIds = this.groupSpaceBindingService.getGroupSpaceBindingsFromQueueByAction(GroupSpaceBindingQueue.ACTION_REMOVE).stream().map(groupSpaceBinding -> groupSpaceBinding.getId()).collect(Collectors.toList());
        List spaceBindings = this.groupSpaceBindingService.findGroupSpaceBindingsBySpace(spaceId);
        if (removedSpaceBindingsIds.size() > 0 && spaceBindings.size() > 0) {
            spaceBindings.removeIf(spaceBinding -> removedSpaceBindingsIds.contains(spaceBinding.getId()));
        }
        if (spaceBindings.size() == 0) {
            return EntityBuilder.getResponse(new CollectionEntity(new ArrayList(), "groupSpaceBindings", offset, limit), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        }
        ArrayList<DataEntity> bindingEntities = new ArrayList<DataEntity>();
        for (GroupSpaceBinding binding : spaceBindings) {
            GroupSpaceBindingEntity bindingEntity = EntityBuilder.buildEntityFromGroupSpaceBinding(binding);
            bindingEntities.add(bindingEntity.getDataEntity());
        }
        CollectionEntity collectionBinding = new CollectionEntity(bindingEntities, "groupSpaceBindings", offset, limit);
        if (returnSize) {
            collectionBinding.setSize(bindingEntities.size());
        }
        return EntityBuilder.getResponse(collectionBinding, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @POST
    @RolesAllowed(value={"administrators"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="saveGroupsSpaceBindings/{spaceId}")
    @ApiOperation(value="Save space group bindings", httpMethod="POST", response=Response.class, notes="This method set bindings for a specific space with a list of groups if the authenticated user is an administrator.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error due to data encoding")})
    public Response saveGroupSpaceBindings(@Context UriInfo uriInfo, @ApiParam(value="SpaceId of the space", required=true) @PathParam(value="spaceId") String spaceId, @ApiParam(value="List of group names to be bound to the space", required=true) List<String> groupNames) {
        if (!this.userACL.isSuperUser() && !this.userACL.isUserInGroup(this.userACL.getAdminGroups())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (groupNames == null || groupNames.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        List spaceBoundGroups = this.groupSpaceBindingService.findGroupSpaceBindingsBySpace(spaceId).stream().map(groupSpaceBinding -> groupSpaceBinding.getGroup()).collect(Collectors.toList());
        List spaceRemovedBoundGroups = this.groupSpaceBindingService.getGroupSpaceBindingsFromQueueByAction(GroupSpaceBindingQueue.ACTION_REMOVE).stream().filter(groupSpaceBinding -> groupSpaceBinding.getSpaceId().equals(spaceId)).map(groupSpaceBinding -> groupSpaceBinding.getGroup()).collect(Collectors.toList());
        spaceBoundGroups.removeAll(spaceRemovedBoundGroups);
        groupNames.removeAll(spaceBoundGroups);
        if (groupNames.size() == 0) {
            return Response.ok((Object)"Already bound!").build();
        }
        ArrayList groupSpaceBindings = new ArrayList();
        groupNames.stream().forEach(groupName -> groupSpaceBindings.add(new GroupSpaceBinding(spaceId, groupName)));
        this.groupSpaceBindingService.saveGroupSpaceBindings(groupSpaceBindings);
        return Response.ok().build();
    }

    @Override
    @DELETE
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @Path(value="removeGroupSpaceBinding/{bindingId}")
    @ApiOperation(value="Deletes a binding.", httpMethod="DELETE", response=Response.class, notes="This method deletes a binding in the following cases the authenticated user is an administrator.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response deleteSpaceBinding(@Context UriInfo uriInfo, @ApiParam(value="spaceId", required=true) @PathParam(value="bindingId") String bindingId) throws Exception {
        if (!this.userACL.isSuperUser() && !this.userACL.isUserInGroup(this.userACL.getAdminGroups())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        GroupSpaceBinding binding = this.groupSpaceBindingService.findGroupSpaceBindingById(bindingId);
        if (binding != null) {
            this.groupSpaceBindingService.prepareDeleteGroupSpaceBinding(binding);
        }
        return Response.ok().build();
    }

    @Override
    @GET
    @RolesAllowed(value={"administrators"})
    @Produces(value={"application/json"})
    @Path(value="getGroupsTree")
    @ApiOperation(value="Gets list of groups entities from the parent group root.", httpMethod="GET", response=Response.class, notes="Returns a list of group entities in the following cases if the authenticated user is an administrator.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getGroupsTree(@Context UriInfo uriInfo) throws Exception {
        if (!this.userACL.isSuperUser() && !this.userACL.isUserInGroup(this.userACL.getAdminGroups())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        List<DataEntity> groupNodesDataEntities = this.buildGroupTree();
        CollectionEntity collectionGroupEntity = new CollectionEntity(groupNodesDataEntities, "childGroups", 0, 10);
        return EntityBuilder.getResponse(collectionGroupEntity, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @GET
    @RolesAllowed(value={"administrators"})
    @Produces(value={"application/vnd.ms-excel"})
    @Path(value="getExport")
    @ApiOperation(value="Gets CSV report", httpMethod="GET", response=Response.class, notes="Given a (space,group,action,groupBindingId), it return all lines of the report in a csv file")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getReport(@Context UriInfo uriInfo, @ApiParam(value="spaceId", required=true) @QueryParam(value="spaceId") String spaceId, @ApiParam(value="action", required=true) @QueryParam(value="action") String action, @ApiParam(value="group", required=true) @QueryParam(value="group") String group, @ApiParam(value="groupBindingId") @QueryParam(value="groupBindingId") String groupBindingId) throws Exception {
        if (!this.userACL.isSuperUser() && !this.userACL.isUserInGroup(this.userACL.getAdminGroups())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        List reports = this.groupSpaceBindingService.findReportsForCsv(Long.parseLong(spaceId), Long.parseLong(groupBindingId), group, action);
        String csvString = this.computeCSV(spaceId, group, action, reports);
        try {
            String filename = action.substring(0, 1).toUpperCase() + action.substring(1, action.length()).toLowerCase() + "Binding_";
            filename = filename + this.spaceService.getSpaceById(spaceId).getPrettyName() + "_";
            if (group.charAt(0) == '/') {
                group = group.substring(1, group.length());
            }
            filename = filename + group.replace("/", "_") + "_";
            filename = filename + this.formater.format(new Date());
            File temp = null;
            temp = File.createTempFile(filename, ".csv");
            temp.deleteOnExit();
            BufferedWriter bw = new BufferedWriter(new FileWriter(temp));
            bw.write(csvString);
            bw.close();
            Response.ResponseBuilder response = Response.ok((Object)temp);
            response.header("Content-Disposition", (Object)("attachment; filename=" + filename + ".csv"));
            return response.build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error when creating temp file");
            return Response.serverError().build();
        }
    }

    @Override
    @GET
    @RolesAllowed(value={"administrators"})
    @Produces(value={"application/json"})
    @Path(value="getBindingReportOperations")
    @ApiOperation(value="Gets list of groups entities from the parent group root.", httpMethod="GET", response=Response.class, notes="Returns a list of group entities in the following cases if the authenticated user is an administrator.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getBindingReportOperations(@Context UriInfo uriInfo) throws Exception {
        if (!this.userACL.isSuperUser() && !this.userACL.isUserInGroup(this.userACL.getAdminGroups())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        List bindingOperationReports = this.groupSpaceBindingService.getGroupSpaceBindingReportOperations();
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        ArrayList<DataEntity> bindingOperationReportsDataEntities = new ArrayList<DataEntity>();
        for (GroupSpaceBindingOperationReport bindingOperationReport : bindingOperationReports) {
            GroupSpaceBindingOperationReportEntity operationReportEntity = EntityBuilder.buildEntityFromGroupSpaceBindingOperationReport(bindingOperationReport);
            OrganizationService organizationService = CommonsUtils.getOrganizationService();
            Group group = organizationService.getGroupHandler().findGroupById(bindingOperationReport.getGroup());
            GroupNodeEntity groupNodeEntity = group != null ? EntityBuilder.buildEntityFromGroup(group) : EntityBuilder.buildEntityFromGroupId(bindingOperationReport.getGroup());
            operationReportEntity.setGroup(groupNodeEntity.getDataEntity());
            Space space = this.spaceService.getSpaceById(Long.toString(bindingOperationReport.getSpaceId()));
            SpaceEntity spaceEntity = EntityBuilder.buildEntityFromSpace(space, authenticatedUser, uriInfo.getPath(), "members");
            operationReportEntity.setSpace(spaceEntity.getDataEntity());
            bindingOperationReportsDataEntities.add(operationReportEntity.getDataEntity());
        }
        CollectionEntity collectionBindingReports = new CollectionEntity(bindingOperationReportsDataEntities, "groupSpaceBindingReportOperations", 0, 10);
        return EntityBuilder.getResponse(collectionBindingReports, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    private List<DataEntity> buildGroupTree() throws Exception {
        OrganizationService organizationService = CommonsUtils.getOrganizationService();
        Collection allGroups = organizationService.getGroupHandler().getAllGroups();
        List groups = allGroups.stream().filter(group -> !group.getId().startsWith("/spaces")).collect(Collectors.toList());
        int highestLevel = 0;
        for (Object group2 : groups) {
            int level = StringUtils.countMatches((CharSequence)group2.getId(), (CharSequence)"/");
            highestLevel = highestLevel > level ? highestLevel : level;
        }
        ArrayList<GroupNodeEntity> allGroupNodesEntities = new ArrayList<GroupNodeEntity>();
        for (Group group3 : groups) {
            GroupNodeEntity groupNodeEntity = EntityBuilder.buildEntityFromGroup(group3);
            allGroupNodesEntities.add(groupNodeEntity);
        }
        List rootChildrenEntities = allGroupNodesEntities.stream().filter(child -> child.getParentId().equals("root")).collect(Collectors.toList());
        allGroupNodesEntities.removeAll(rootChildrenEntities);
        for (int i = highestLevel; i > 1; --i) {
            List<GroupNodeEntity> bottomGroupNodesEntities = this.getBottomGroupEntities(allGroupNodesEntities, i);
            ArrayList bottomEntities = new ArrayList();
            bottomEntities.addAll(bottomGroupNodesEntities);
            Iterator iterator = bottomGroupNodesEntities.iterator();
            while (iterator.hasNext()) {
                GroupNodeEntity parentEntity;
                GroupNodeEntity groupNodeEntity = (GroupNodeEntity)iterator.next();
                if (!bottomEntities.contains(groupNodeEntity) || (parentEntity = this.getParentEntityOf(groupNodeEntity, allGroupNodesEntities)) == null) continue;
                allGroupNodesEntities.remove(parentEntity);
                List<GroupNodeEntity> childrenEntities = this.getChildrenEntitiesOf(parentEntity, allGroupNodesEntities);
                parentEntity.setChildGroupNodesEntities(this.convertToChildrenDataEntities(childrenEntities));
                allGroupNodesEntities.add(parentEntity);
                allGroupNodesEntities.removeAll(childrenEntities);
                bottomEntities.removeAll(childrenEntities);
            }
        }
        ArrayList<GroupNodeEntity> rootChildGroupNodesEntities = new ArrayList<GroupNodeEntity>();
        for (GroupNodeEntity rootChildEntity : rootChildrenEntities) {
            List<GroupNodeEntity> childrenEntities = this.getChildrenEntitiesOf(rootChildEntity, allGroupNodesEntities);
            rootChildEntity.setChildGroupNodesEntities(this.convertToChildrenDataEntities(childrenEntities));
            rootChildGroupNodesEntities.add(rootChildEntity);
        }
        ArrayList<DataEntity> groupNodesDataEntities = new ArrayList<DataEntity>();
        for (GroupNodeEntity entity : rootChildGroupNodesEntities) {
            groupNodesDataEntities.add(entity.getDataEntity());
        }
        return groupNodesDataEntities;
    }

    private List<GroupNodeEntity> getBottomGroupEntities(List<GroupNodeEntity> allGroupNodesEntities, int highestLevel) {
        ArrayList<GroupNodeEntity> bottomGroupNodesEntities = new ArrayList<GroupNodeEntity>();
        for (GroupNodeEntity groupNodeEntity : allGroupNodesEntities) {
            if (StringUtils.countMatches((CharSequence)groupNodeEntity.getId(), (CharSequence)"/") != highestLevel) continue;
            bottomGroupNodesEntities.add(groupNodeEntity);
        }
        return bottomGroupNodesEntities;
    }

    private GroupNodeEntity getParentEntityOf(GroupNodeEntity groupNodeEntity, List<GroupNodeEntity> groupNodesEntities) {
        GroupNodeEntity parentNodeEntity = null;
        for (GroupNodeEntity parentEntity : groupNodesEntities) {
            if (!parentEntity.getId().equals(groupNodeEntity.getParentId())) continue;
            parentNodeEntity = parentEntity;
        }
        return parentNodeEntity;
    }

    private List<GroupNodeEntity> getChildrenEntitiesOf(GroupNodeEntity groupNodeEntity, List<GroupNodeEntity> groupNodeEntities) {
        ArrayList<GroupNodeEntity> childrenEntities = new ArrayList<GroupNodeEntity>();
        for (GroupNodeEntity childEntity : groupNodeEntities) {
            if (!childEntity.getParentId().equals(groupNodeEntity.getId())) continue;
            childrenEntities.add(childEntity);
        }
        return childrenEntities;
    }

    private List<DataEntity> convertToChildrenDataEntities(List<GroupNodeEntity> childrenEntities) {
        ArrayList<DataEntity> childrenDataEntities = new ArrayList<DataEntity>();
        for (GroupNodeEntity childGroupNodeEntity : childrenEntities) {
            childrenDataEntities.add(childGroupNodeEntity.getDataEntity());
        }
        return childrenDataEntities;
    }

    private List<GroupSpaceBindingOperationReport> convertBindingQueueListToReportOperations(List<GroupSpaceBindingQueue> bindingQueueList) {
        List<GroupSpaceBindingOperationReport> bindingOperationReports = bindingQueueList.stream().map(bindingQueue -> this.convertBindingQueueToOperationReport((GroupSpaceBindingQueue)bindingQueue)).collect(Collectors.toList());
        return bindingOperationReports;
    }

    private GroupSpaceBindingOperationReport convertBindingQueueToOperationReport(GroupSpaceBindingQueue bindingQueue) {
        GroupSpaceBindingOperationReport bindingOperationReport = new GroupSpaceBindingOperationReport();
        bindingOperationReport.setSpaceId(Long.parseLong(bindingQueue.getGroupSpaceBinding().getSpaceId()));
        bindingOperationReport.setGroup(bindingQueue.getGroupSpaceBinding().getGroup());
        bindingOperationReport.setAction(bindingQueue.getAction());
        bindingOperationReport.setGroupSpaceBindingId(bindingQueue.getGroupSpaceBinding().getId());
        return bindingOperationReport;
    }

    private String computeCSV(String spaceId, String group, String action, List<GroupSpaceBindingReportUser> reports) {
        StringBuilder sbResult = new StringBuilder();
        Space space = this.spaceService.getSpaceById(spaceId);
        sbResult.append(space.getDisplayName() + "\n");
        sbResult.append(group + "\n");
        sbResult.append(action + "\n");
        if (reports.size() != 0) {
            sbResult.append(reports.get(0).getDate() + "\n");
            sbResult.append(reports.get(reports.size() - 1).getDate() + "\n");
        }
        sbResult.append("Username,Action,Date,Present Before,Still in space\n");
        reports.stream().forEach(groupSpaceBindingReport -> {
            sbResult.append(groupSpaceBindingReport.getUsername() + ",");
            if (!groupSpaceBindingReport.getGroupSpaceBindingReportAction().getAction().equals("SYNCHRONIZE") && groupSpaceBindingReport.getAction().equals("REMOVE_USER") && groupSpaceBindingReport.isWasPresentBefore() | groupSpaceBindingReport.isStillInSpace()) {
                sbResult.append(",");
            } else {
                sbResult.append(groupSpaceBindingReport.getAction() + ",");
            }
            sbResult.append(groupSpaceBindingReport.getDate() + ",");
            sbResult.append(groupSpaceBindingReport.isWasPresentBefore() + ",");
            if (groupSpaceBindingReport.getAction().equals("REMOVE_USER")) {
                sbResult.append(groupSpaceBindingReport.isStillInSpace());
            }
            sbResult.append("\n");
        });
        return sbResult.toString();
    }
}

