/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.util.Arrays;
import java.util.List;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManagerImpl;
import org.exoplatform.social.core.space.impl.SpaceServiceImpl;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.service.rest.NotificationsRestService;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class NotificationsRestServiceTest
extends AbstractResourceTest {
    private IdentityStorage identityStorage;
    private ActivityManagerImpl activityManager;
    private SpaceServiceImpl spaceService;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity demoIdentity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.identityStorage = (IdentityStorage)this.getContainer().getComponentInstanceOfType(IdentityStorage.class);
        this.activityManager = (ActivityManagerImpl)this.getContainer().getComponentInstanceOfType(ActivityManagerImpl.class);
        this.spaceService = (SpaceServiceImpl)this.getContainer().getComponentInstanceOfType(SpaceServiceImpl.class);
        this.rootIdentity = new Identity("organization", "root");
        this.johnIdentity = new Identity("organization", "john");
        this.maryIdentity = new Identity("organization", "mary");
        this.demoIdentity = new Identity("organization", "demo");
        this.identityStorage.saveIdentity(this.rootIdentity);
        this.identityStorage.saveIdentity(this.johnIdentity);
        this.identityStorage.saveIdentity(this.maryIdentity);
        this.identityStorage.saveIdentity(this.demoIdentity);
        this.addResource(NotificationsRestService.class, null);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource(NotificationsRestService.class);
    }

    public void testReplyActivity() throws Exception {
        this.startSessionAs("root");
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("activity");
        this.activityManager.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        ContainerResponse response = this.service("GET", "/social/notifications/redirectUrl/reply_activity/" + activity.getId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)303, (int)response.getStatus());
        this.activityManager.deleteActivity((ExoSocialActivity)activity);
    }

    public void testViewFullDiscussion() throws Exception {
        this.startSessionAs("root");
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("activity");
        this.activityManager.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        ContainerResponse response = this.service("GET", "/social/notifications/redirectUrl/view_full_activity/" + activity.getId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)303, (int)response.getStatus());
        this.activityManager.deleteActivity((ExoSocialActivity)activity);
    }

    public void testInviteToConnect() throws Exception {
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", "/social/notifications/inviteToConnect/" + this.johnIdentity.getRemoteId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)303, (int)response.getStatus());
    }

    public void testInviteToConnectNotAuthorized() throws Exception {
        this.startSessionAs("john");
        ContainerResponse response = this.service("GET", "/social/notifications/inviteToConnect/" + this.demoIdentity.getRemoteId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)401, (int)response.getStatus());
    }

    public void testInviteToConnectNotAuthorizedWhenUserIsReceiver() throws Exception {
        this.startSessionAs("john");
        ContainerResponse response = this.service("GET", "/social/notifications/inviteToConnect/" + this.johnIdentity.getRemoteId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)401, (int)response.getStatus());
    }

    public void testConfirmInvitationToConnect() throws Exception {
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", "/social/notifications/confirmInvitationToConnect/" + this.johnIdentity.getRemoteId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)303, (int)response.getStatus());
    }

    public void testConfirmInvitationToConnectNotAuthorized() throws Exception {
        this.startSessionAs("john");
        ContainerResponse response = this.service("GET", "/social/notifications/confirmInvitationToConnect/" + this.demoIdentity.getRemoteId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)401, (int)response.getStatus());
    }

    public void testConfirmInvitationToConnectNotAuthorizedWhenUserIsSender() throws Exception {
        this.startSessionAs("john");
        ContainerResponse response = this.service("GET", "/social/notifications/confirmInvitationToConnect/" + this.johnIdentity.getRemoteId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)401, (int)response.getStatus());
    }

    public void testIgnoreInvitationToConnect() throws Exception {
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", "/social/notifications/ignoreInvitationToConnect/" + this.johnIdentity.getRemoteId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)303, (int)response.getStatus());
    }

    public void testIgnoreInvitationToConnectNotAuthorized() throws Exception {
        this.startSessionAs("john");
        ContainerResponse response = this.service("GET", "/social/notifications/ignoreInvitationToConnect/" + this.demoIdentity.getRemoteId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)401, (int)response.getStatus());
    }

    public void testIgnoreInvitationToConnectNotAuthorizedWhenUserIsSender() throws Exception {
        this.startSessionAs("john");
        ContainerResponse response = this.service("GET", "/social/notifications/ignoreInvitationToConnect/" + this.johnIdentity.getRemoteId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)401, (int)response.getStatus());
    }

    public void testAcceptInvitationToJoinSpace() throws Exception {
        Space space = this.getSpaceInstance(1);
        List<String> listMembers = Arrays.asList(space.getMembers());
        NotificationsRestServiceTest.assertFalse((boolean)listMembers.contains("root"));
        List<String> listInviteds = Arrays.asList(space.getInvitedUsers());
        NotificationsRestServiceTest.assertTrue((boolean)listInviteds.contains("root"));
        this.end();
        this.begin();
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", "/social/notifications/acceptInvitationToJoinSpace/" + space.getId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)303, (int)response.getStatus());
        this.end();
        this.begin();
        listMembers = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getMembers());
        NotificationsRestServiceTest.assertTrue((boolean)listMembers.contains("root"));
        listInviteds = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getInvitedUsers());
        NotificationsRestServiceTest.assertFalse((boolean)listInviteds.contains("root"));
        this.spaceService.deleteSpace(space.getId());
    }

    public void testAcceptInvitationToJoinSpaceNotAuthorized() throws Exception {
        Space space = this.getSpaceInstance(1);
        List<String> listMembers = Arrays.asList(space.getMembers());
        NotificationsRestServiceTest.assertFalse((boolean)listMembers.contains("root"));
        List<String> listInviteds = Arrays.asList(space.getInvitedUsers());
        NotificationsRestServiceTest.assertTrue((boolean)listInviteds.contains("root"));
        this.end();
        this.begin();
        this.startSessionAs("john");
        ContainerResponse response = this.service("GET", "/social/notifications/acceptInvitationToJoinSpace/" + space.getId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)401, (int)response.getStatus());
        this.end();
        this.begin();
        listMembers = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getMembers());
        NotificationsRestServiceTest.assertFalse((boolean)listMembers.contains("root"));
        listInviteds = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getInvitedUsers());
        NotificationsRestServiceTest.assertTrue((boolean)listInviteds.contains("root"));
        this.spaceService.deleteSpace(space.getId());
    }

    public void testIgnoreInvitationToJoinSpace() throws Exception {
        Space space = this.getSpaceInstance(1);
        List<String> listMembers = Arrays.asList(space.getMembers());
        NotificationsRestServiceTest.assertFalse((boolean)listMembers.contains("root"));
        List<String> listInviteds = Arrays.asList(space.getInvitedUsers());
        NotificationsRestServiceTest.assertTrue((boolean)listInviteds.contains("root"));
        this.end();
        this.begin();
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", "/social/notifications/ignoreInvitationToJoinSpace/" + space.getId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)303, (int)response.getStatus());
        this.end();
        this.begin();
        listMembers = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getMembers());
        NotificationsRestServiceTest.assertFalse((boolean)listMembers.contains("root"));
        listInviteds = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getInvitedUsers());
        NotificationsRestServiceTest.assertFalse((boolean)listInviteds.contains("root"));
        this.spaceService.deleteSpace(space.getId());
    }

    public void testIgnoreInvitationToJoinSpaceNotAuthorized() throws Exception {
        Space space = this.getSpaceInstance(1);
        List<String> listMembers = Arrays.asList(space.getMembers());
        NotificationsRestServiceTest.assertFalse((boolean)listMembers.contains("root"));
        List<String> listInviteds = Arrays.asList(space.getInvitedUsers());
        NotificationsRestServiceTest.assertTrue((boolean)listInviteds.contains("root"));
        this.end();
        this.begin();
        this.startSessionAs("john");
        ContainerResponse response = this.service("GET", "/social/notifications/ignoreInvitationToJoinSpace/" + space.getId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)401, (int)response.getStatus());
        this.end();
        this.begin();
        listMembers = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getMembers());
        NotificationsRestServiceTest.assertFalse((boolean)listMembers.contains("root"));
        listInviteds = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getInvitedUsers());
        NotificationsRestServiceTest.assertTrue((boolean)listInviteds.contains("root"));
        this.spaceService.deleteSpace(space.getId());
    }

    public void testValidateRequestToJoinSpace() throws Exception {
        Space space = this.getSpaceInstance(1);
        List<String> listMembers = Arrays.asList(space.getMembers());
        NotificationsRestServiceTest.assertFalse((boolean)listMembers.contains("root"));
        List<String> listPendings = Arrays.asList(space.getPendingUsers());
        NotificationsRestServiceTest.assertTrue((boolean)listPendings.contains("root"));
        this.end();
        this.begin();
        this.startSessionAs("john");
        ContainerResponse response = this.service("GET", "/social/notifications/validateRequestToJoinSpace/" + space.getId() + "/" + this.rootIdentity.getRemoteId() + ";jsessionid=0C004882C60E5BF3AB8EDCA4FD1467F1", "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)303, (int)response.getStatus());
        this.end();
        this.begin();
        listMembers = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getMembers());
        NotificationsRestServiceTest.assertTrue((boolean)listMembers.contains("root"));
        listPendings = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getPendingUsers());
        NotificationsRestServiceTest.assertFalse((boolean)listPendings.contains("root"));
        this.spaceService.deleteSpace(space.getId());
    }

    public void testValidateRequestToJoinSpaceNotAuthorized() throws Exception {
        Space space = this.getSpaceInstance(1);
        List<String> listMembers = Arrays.asList(space.getMembers());
        NotificationsRestServiceTest.assertFalse((boolean)listMembers.contains("root"));
        List<String> listPendings = Arrays.asList(space.getPendingUsers());
        NotificationsRestServiceTest.assertTrue((boolean)listPendings.contains("root"));
        this.end();
        this.begin();
        this.startSessionAs("demo");
        ContainerResponse response = this.service("GET", "/social/notifications/validateRequestToJoinSpace/" + space.getId() + "/" + this.rootIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertNotNull((Object)response);
        NotificationsRestServiceTest.assertEquals((int)401, (int)response.getStatus());
        this.end();
        this.begin();
        listMembers = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getMembers());
        NotificationsRestServiceTest.assertFalse((boolean)listMembers.contains("root"));
        listPendings = Arrays.asList(this.spaceService.getSpaceById(space.getId()).getPendingUsers());
        NotificationsRestServiceTest.assertTrue((boolean)listPendings.contains("root"));
        this.spaceService.deleteSpace(space.getId());
    }

    public void testRedirectUrl() throws Exception {
        this.startSessionAs("root");
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("activity");
        this.activityManager.saveActivity(this.rootIdentity, (ExoSocialActivity)activity);
        ContainerResponse response = this.service("GET", "/social/notifications/redirectUrl/view_full_activity/" + activity.getId(), "", null, null);
        NotificationsRestServiceTest.assertEquals((int)303, (int)response.getStatus());
        response = this.service("GET", "/social/notifications/redirectUrl/user/" + this.demoIdentity.getRemoteId(), "", null, null);
        NotificationsRestServiceTest.assertEquals((int)303, (int)response.getStatus());
        Space space = this.getSpaceInstance(1);
        response = this.service("GET", "/social/notifications/redirectUrl/space/" + space.getId(), "", null, null);
        NotificationsRestServiceTest.assertEquals((int)303, (int)response.getStatus());
        this.activityManager.deleteActivity((ExoSocialActivity)activity);
        this.spaceService.deleteSpace(space.getId());
    }

    private Space getSpaceInstance(int number) throws Exception {
        Space space = new Space();
        space.setDisplayName("my_space_" + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setType("classic");
        space.setVisibility("public");
        space.setPriority("2");
        space.setGroupId("/spaces/my_space_" + number);
        String[] managers = new String[]{"john"};
        String[] members = new String[]{};
        String[] invitedUsers = new String[]{"root"};
        String[] pendingUsers = new String[]{"root"};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(managers);
        space.setMembers(members);
        space.setUrl(space.getPrettyName());
        this.spaceService.createSpace(space, "john");
        return space;
    }
}

