/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.identity;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.IdentityRestResources;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.IdentityEntity;
import org.exoplatform.social.rest.entity.ProfileEntity;

@Path(value="v1/social/identities")
@Api(tags={"v1/social/identities"}, value="v1/social/identities", description="Managing identities")
public class IdentityRestResourcesV1
implements IdentityRestResources {
    private IdentityManager identityManager;

    public IdentityRestResourcesV1(IdentityManager identityManager) {
        this.identityManager = identityManager;
    }

    @Override
    @GET
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets all identities", httpMethod="GET", response=Response.class, notes="This returns a list of identities in the following cases: <br/><ul><li>the authenticated user has permissions to view the object linked to these identities</li><li>the authenticated user is in the group /platform/administrators</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getIdentities(@Context UriInfo uriInfo, @ApiParam(value="Provider type: space or organization", required=false, defaultValue="organization") @QueryParam(value="type") String type, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Returning the number of identities or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        try {
            offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
            limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
            IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
            String providerId = type != null && type.equals("space") ? "space" : "organization";
            ListAccess listAccess = identityManager.getIdentitiesByProfileFilter(providerId, new ProfileFilter(), true);
            Identity[] identities = (Identity[])listAccess.load(offset, limit);
            ArrayList<DataEntity> identityEntities = new ArrayList<DataEntity>();
            for (Identity identity : identities) {
                identityEntities.add(EntityBuilder.buildEntityIdentity(identity, uriInfo.getPath(), expand).getDataEntity());
            }
            CollectionEntity collectionIdentity = new CollectionEntity(identityEntities, "identities", offset, limit);
            if (returnSize) {
                collectionIdentity.setSize(listAccess.getSize());
            }
            return EntityBuilder.getResponse(collectionIdentity, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        }
        catch (Exception e) {
            return EntityBuilder.getResponse(new CollectionEntity(new ArrayList(), "identities", offset, limit), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        }
    }

    @Override
    @GET
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets an identity by id", httpMethod="GET", response=Response.class, notes="This returns the identity if the authenticated user has permissions to view the object linked to this identity.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getIdentityById(@Context UriInfo uriInfo, @ApiParam(value="Identity id which is a UUID such as 40487b7e7f00010104499b339f056aa4", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        Identity identity = identityManager.getIdentity(id, true);
        if (identity == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        IdentityEntity profileInfo = EntityBuilder.buildEntityIdentity(identity, uriInfo.getPath(), expand);
        return EntityBuilder.getResponse(profileInfo, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @GET
    @Path(value="{providerId}/{remoteId}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets an identity by id", httpMethod="GET", response=Response.class, notes="This returns the identity if the authenticated user has permissions to view the object linked to this identity.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    @Produces(value={"application/json"})
    public Response getIdentityByProviderIdAndRemoteId(@Context UriInfo uriInfo, @ApiParam(value="Identity provider id which can be of type 'space' or 'organization' for example", required=true) @PathParam(value="providerId") String providerId, @ApiParam(value="Identity id which is the unique name (remote id) of identity", required=true) @PathParam(value="remoteId") String remoteId, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) {
        Identity identity = this.identityManager.getOrCreateIdentity(providerId, remoteId);
        if (identity == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        IdentityEntity profileInfo = EntityBuilder.buildEntityIdentity(identity, uriInfo.getPath(), expand);
        return EntityBuilder.getResponse(profileInfo, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @GET
    @Path(value="{id}/avatar")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets an identity avatar by id", httpMethod="GET", response=Response.class, notes="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=404, message="Resource not found")})
    public Response getIdentityAvatarById(@Context UriInfo uriInfo, @Context Request request, @ApiParam(value="Identity id which is a UUID", required=true) @PathParam(value="id") String id) throws IOException {
        Response.ResponseBuilder builder;
        Identity identity = this.identityManager.getIdentity(id, true);
        if (identity == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        Profile profile = identity.getProfile();
        Long lastUpdated = null;
        if (profile != null) {
            lastUpdated = profile.getAvatarLastUpdated();
        }
        EntityTag eTag = null;
        if (lastUpdated != null) {
            eTag = new EntityTag(Integer.toString(lastUpdated.hashCode()));
        }
        Response.ResponseBuilder responseBuilder = builder = eTag == null ? null : request.evaluatePreconditions(eTag);
        if (builder == null) {
            InputStream stream = this.identityManager.getAvatarInputStream(identity);
            if (stream == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            builder = Response.ok((Object)stream, (String)"image/png");
            builder.tag(eTag);
        }
        CacheControl cc = new CacheControl();
        cc.setMaxAge(86400);
        builder.cacheControl(cc);
        return builder.cacheControl(cc).build();
    }

    @GET
    @Path(value="{id}/banner")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets an identity banner by id", httpMethod="GET", response=Response.class, notes="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=404, message="Resource not found")})
    public Response getIdentityBannerById(@Context UriInfo uriInfo, @Context Request request, @ApiParam(value="Identity id which is a UUID", required=true) @PathParam(value="id") String id) throws IOException {
        Response.ResponseBuilder builder;
        Identity identity = this.identityManager.getIdentity(id, true);
        if (identity == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        Profile profile = identity.getProfile();
        Long lastUpdated = null;
        if (profile != null) {
            lastUpdated = profile.getBannerLastUpdated();
        }
        EntityTag eTag = null;
        if (lastUpdated != null) {
            eTag = new EntityTag(Integer.toString(lastUpdated.hashCode()));
        }
        Response.ResponseBuilder responseBuilder = builder = eTag == null ? null : request.evaluatePreconditions(eTag);
        if (builder == null) {
            InputStream stream = this.identityManager.getBannerInputStream(identity);
            if (stream == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            builder = Response.ok((Object)stream, (String)"image/png");
            builder.tag(eTag);
        }
        CacheControl cc = new CacheControl();
        cc.setMaxAge(86400);
        builder.cacheControl(cc);
        return builder.cacheControl(cc).build();
    }

    private Profile fillProfileFromEntity(ProfileEntity model, Identity identity) {
        Profile profile = identity.getProfile();
        this.setProperty(profile, "firstName", model.getFirstname());
        this.setProperty(profile, "lastName", model.getLastname());
        this.setProperty(profile, "email", model.getEmail());
        this.setProperty(profile, "position", model.getPosition());
        this.setProperty(profile, "gender", model.getGender());
        this.setProperty(profile, "deleted", model.getDeleted());
        return profile;
    }

    private Profile setProperty(Profile profile, String key, Object value) {
        if (value != null) {
            profile.setProperty(key, value);
        }
        return profile;
    }

    @Override
    @GET
    @Path(value="{id}/relationships")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets relationships of a specific identity", httpMethod="GET", response=Response.class, notes="This returns a list of relationships if the authenticated user can view the object linked to the identity.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getRelationshipsOfIdentity(@Context UriInfo uriInfo, @ApiParam(value="The given identity id", required=true) @PathParam(value="id") String id, @ApiParam(value="The other identity id to get the relationship with the given one") @QueryParam(value="with") String with, @ApiParam(value="Returning the number of relationships or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        Identity identity = identityManager.getIdentity(id, true);
        if (identity == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        RelationshipManager relationshipManager = (RelationshipManager)CommonsUtils.getService(RelationshipManager.class);
        if (with != null && with.length() > 0) {
            Identity withUser = identityManager.getIdentity(with, true);
            if (withUser == null) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            Relationship relationship = relationshipManager.get(identity, withUser);
            if (relationship == null) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            return EntityBuilder.getResponse(EntityBuilder.buildEntityRelationship(relationship, uriInfo.getPath(), expand, false), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        }
        List relationships = relationshipManager.getRelationshipsByStatus(identity, Relationship.Type.ALL, offset, limit);
        List<DataEntity> relationshipEntities = EntityBuilder.buildRelationshipEntities(relationships, uriInfo);
        CollectionEntity collectionRelationship = new CollectionEntity(relationshipEntities, "relationships", offset, limit);
        if (returnSize) {
            collectionRelationship.setSize(relationshipManager.getRelationshipsCountByStatus(identity, Relationship.Type.ALL));
        }
        return EntityBuilder.getResponse(collectionRelationship, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @GET
    @Path(value="{id}/commonConnections")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets common connections with identity", httpMethod="GET", response=Response.class, notes="This returns the common connections between a the authenticated user and a given identity.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getCommonConnectionsWithIdentity(@Context UriInfo uriInfo, @ApiParam(value="The given identity id", required=true) @PathParam(value="id") String id, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Returning the number of common connections or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        RelationshipManager relationshipManager = (RelationshipManager)CommonsUtils.getService(RelationshipManager.class);
        Identity authenticatedUser = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", ConversationState.getCurrent().getIdentity().getUserId());
        List<Identity> currentUserConnections = Arrays.asList((Identity[])relationshipManager.getConnections(authenticatedUser).load(0, 0));
        Identity withIdentity = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getIdentity(id, true);
        List<Identity> withConnections = Arrays.asList((Identity[])relationshipManager.getConnections(withIdentity).load(0, 0));
        List commonConnections = currentUserConnections.stream().filter(withConnections::contains).collect(Collectors.toList());
        ArrayList<DataEntity> identityEntities = new ArrayList<DataEntity>();
        for (Identity identity : commonConnections) {
            identityEntities.add(EntityBuilder.buildEntityIdentity(identity, uriInfo.getPath(), expand).getDataEntity());
        }
        CollectionEntity collectionIdentity = new CollectionEntity(identityEntities, "identities", offset, limit);
        if (returnSize) {
            collectionIdentity.setSize(commonConnections.size());
        }
        return EntityBuilder.getResponse(collectionIdentity, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }
}

