/**
 * 
 */
package org.exoplatform.social.service.malwareDetection.connector;

import java.util.List;

import org.apache.commons.lang.StringUtils;

import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;

/**
 * Is extended by all MalwareDetection connectors, and allows to build configuration needed by a list of connectors that is used for Malware detection.
 * 
 */
public abstract class MalwareDetectionConnector extends BaseComponentPlugin {
  
  private String type;
  private boolean isDefault = false;
  protected static final String MALWARE_DETECTION_FEATURE = "malware-detection";
  protected static final String GET_MALWARE_INFECTED_ITEMS_PATHS_OPERATION = "get-malware-infected-items-paths";
  
  /**
   * Initializes a malware detection connector. The constructor is default that connectors must implement.
   * @param initParams The parameters which are used for initializing the malware detection connector from configuration.
   * @LevelAPI Experimental
   */
  public MalwareDetectionConnector(InitParams initParams) {
    PropertiesParam param = initParams.getPropertiesParam("constructor.params");
    this.type = param.getProperty("type");
    if (StringUtils.isNotBlank(param.getProperty("isDefault"))) {
      this.setDefault(Boolean.parseBoolean(param.getProperty("isDefault")));
    }
  }
  
  /**
   * @return the type
   */
  public String getType() {
    return type;
  }

  /**
   * @param type the type to set
   */
  public void setType(String type) {
    this.type = type;
  }

  /**
   * @return the isDefault
   */
  public boolean isDefault() {
    return isDefault;
  }

  /**
   * @param isDefault the isDefault to set
   */
  public void setDefault(boolean isDefault) {
    this.isDefault = isDefault;
  }
  
  public abstract List<String> getInfectedItemsPaths();
}