/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.websocket.listenr;

import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.websocket.ActivityStreamWebSocketService;
import org.exoplatform.social.websocket.entity.ActivityStreamModification;

public class ActivityStreamUpdateBroadcast
extends ActivityListenerPlugin {
    private ActivityStreamWebSocketService activityStreamWebSocketService;

    public ActivityStreamUpdateBroadcast(ActivityStreamWebSocketService activityStreamWebSocketService) {
        this.activityStreamWebSocketService = activityStreamWebSocketService;
    }

    public void saveActivity(ActivityLifeCycleEvent event) {
        String activityId = this.getActivityId(event);
        ActivityStreamModification activityStreamModification = new ActivityStreamModification(activityId, "createActivity");
        this.activityStreamWebSocketService.sendMessage(activityStreamModification);
    }

    public void updateActivity(ActivityLifeCycleEvent event) {
        String activityId = this.getActivityId(event);
        ActivityStreamModification activityStreamModification = new ActivityStreamModification(activityId, "updateActivity");
        this.activityStreamWebSocketService.sendMessage(activityStreamModification);
    }

    public void saveComment(ActivityLifeCycleEvent event) {
        String activityId = this.getActivityId(event);
        String commentId = this.getCommentId(event);
        String parentCommentId = this.getParentCommentId(event);
        ActivityStreamModification activityStreamModification = new ActivityStreamModification(activityId, commentId, parentCommentId, "createComment");
        this.activityStreamWebSocketService.sendMessage(activityStreamModification);
    }

    public void updateComment(ActivityLifeCycleEvent event) {
        String activityId = this.getActivityId(event);
        String commentId = this.getCommentId(event);
        String parentCommentId = this.getParentCommentId(event);
        ActivityStreamModification activityStreamModification = new ActivityStreamModification(activityId, commentId, parentCommentId, "updateComment");
        this.activityStreamWebSocketService.sendMessage(activityStreamModification);
    }

    public void likeActivity(ActivityLifeCycleEvent event) {
        String activityId = this.getActivityId(event);
        ActivityStreamModification activityStreamModification = new ActivityStreamModification(activityId, "likeActivity");
        this.activityStreamWebSocketService.sendMessage(activityStreamModification);
    }

    public void likeComment(ActivityLifeCycleEvent event) {
        String activityId = this.getActivityId(event);
        String commentId = this.getCommentId(event);
        String parentCommentId = this.getParentCommentId(event);
        ActivityStreamModification activityStreamModification = new ActivityStreamModification(activityId, commentId, parentCommentId, "likeComment");
        this.activityStreamWebSocketService.sendMessage(activityStreamModification);
    }

    private String getActivityId(ActivityLifeCycleEvent event) {
        return event.getActivity().isComment() ? event.getActivity().getParentId() : event.getActivity().getId();
    }

    private String getCommentId(ActivityLifeCycleEvent event) {
        return event.getActivity().getParentId() == null ? null : event.getActivity().getId();
    }

    private String getParentCommentId(ActivityLifeCycleEvent event) {
        return event.getActivity().getParentCommentId();
    }
}

