/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.activity;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.tools.DummyContainerResponseWriter;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.ActivityManagerImpl;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.rest.entity.ActivityEntity;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.CommentEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.impl.activity.ActivityRestResourcesV1;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class ActivityRestResourcesTest
extends AbstractResourceTest {
    private ActivityRestResourcesV1 activityRestResourcesV1;
    private IdentityStorage identityStorage;
    private IdentityManager identityManager;
    private ActivityManager activityManager;
    private RelationshipManager relationshipManager;
    private SpaceService spaceService;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity demoIdentity;
    private Identity testSpaceIdentity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("gatein.email.domain.url", "localhost:8080");
        this.identityStorage = (IdentityStorage)this.getContainer().getComponentInstanceOfType(IdentityStorage.class);
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.activityManager = (ActivityManager)this.getContainer().getComponentInstanceOfType(ActivityManager.class);
        this.relationshipManager = (RelationshipManager)this.getContainer().getComponentInstanceOfType(RelationshipManager.class);
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        this.rootIdentity = new Identity("organization", "root");
        this.johnIdentity = new Identity("organization", "john");
        this.maryIdentity = new Identity("organization", "mary");
        this.demoIdentity = new Identity("organization", "demo");
        this.identityStorage.saveIdentity(this.rootIdentity);
        this.identityStorage.saveIdentity(this.johnIdentity);
        this.identityStorage.saveIdentity(this.maryIdentity);
        this.identityStorage.saveIdentity(this.demoIdentity);
        this.activityRestResourcesV1 = new ActivityRestResourcesV1(this.activityManager, this.identityManager, this.spaceService, null);
        this.registry(this.activityRestResourcesV1);
        ExoContainerContext.setCurrentContainer((ExoContainer)this.getContainer());
        this.restartTransaction();
        this.begin();
    }

    @Override
    public void tearDown() throws Exception {
        this.end();
        super.tearDown();
        this.removeResource(this.activityRestResourcesV1.getClass());
    }

    public void testAddActivityByUser() throws Exception {
        this.startSessionAs("john");
        String input = "{\"title\":titleOfActivity,\"templateParams\":{\"param1\": value1,\"param2\":value2}}";
        ContainerResponse response = this.getResponse("POST", this.getURLResource("activities"), input);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        DataEntity responseEntity = (DataEntity)response.getEntity();
        String title = (String)responseEntity.get((Object)"title");
        ActivityRestResourcesTest.assertNotNull((Object)title);
        ActivityRestResourcesTest.assertEquals((String)"titleOfActivity", (String)title);
        DataEntity templateParams = (DataEntity)responseEntity.get((Object)"templateParams");
        ActivityRestResourcesTest.assertNotNull((Object)templateParams);
        ActivityRestResourcesTest.assertEquals((int)2, (int)templateParams.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddActivityByUserWhenPostOnUserStreamDisabled() throws Exception {
        Field field = ActivityManagerImpl.class.getDeclaredField("enableUserComposer");
        field.setAccessible(true);
        field.set(this.activityManager, false);
        try {
            this.startSessionAs("john");
            String input = "{\"title\":titleOfActivity,\"templateParams\":{\"param1\": value1,\"param2\":value2}}";
            ContainerResponse response = this.getResponse("POST", this.getURLResource("activities"), input);
            ActivityRestResourcesTest.assertNotNull((Object)response);
            ActivityRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
        }
        finally {
            field.set(this.activityManager, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetActivitiesOfUser() throws Exception {
        this.startSessionAs("root");
        this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.rootIdentity);
        ExoSocialActivityImpl rootActivity = new ExoSocialActivityImpl();
        rootActivity.setTitle("root activity");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)rootActivity);
        this.restartTransaction();
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("demo activity");
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        ExoSocialActivityImpl maryActivity = new ExoSocialActivityImpl();
        maryActivity.setTitle("mary activity");
        this.activityManager.saveActivityNoReturn(this.maryIdentity, (ExoSocialActivity)maryActivity);
        this.restartTransaction();
        ContainerResponse response = this.service("GET", this.getURLResource("activities?limit=5&offset=0"), "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        ActivityRestResourcesTest.assertEquals((int)2, (int)collections.getEntities().size());
        ActivityEntity activityEntity = this.getBaseEntity(collections.getEntities().get(0), ActivityEntity.class);
        ActivityRestResourcesTest.assertEquals((String)"demo activity", (String)activityEntity.getTitle());
        activityEntity = this.getBaseEntity(collections.getEntities().get(1), ActivityEntity.class);
        ActivityRestResourcesTest.assertEquals((String)"root activity", (String)activityEntity.getTitle());
        Boolean canPost = (boolean)((Boolean)collections.get((Object)"canPost"));
        ActivityRestResourcesTest.assertNotNull((Object)canPost);
        ActivityRestResourcesTest.assertTrue((boolean)canPost);
        Field field = ActivityManagerImpl.class.getDeclaredField("enableUserComposer");
        field.setAccessible(true);
        field.set(this.activityManager, false);
        try {
            response = this.service("GET", this.getURLResource("activities?limit=5&offset=0"), "", null, null);
            ActivityRestResourcesTest.assertNotNull((Object)response);
            ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
            collections = (CollectionEntity)response.getEntity();
            canPost = (boolean)((Boolean)collections.get((Object)"canPost"));
            ActivityRestResourcesTest.assertNotNull((Object)canPost);
            ActivityRestResourcesTest.assertFalse((boolean)canPost);
        }
        finally {
            field.set(this.activityManager, true);
        }
        this.activityManager.deleteActivity((ExoSocialActivity)maryActivity);
        this.activityManager.deleteActivity((ExoSocialActivity)demoActivity);
        this.activityManager.deleteActivity((ExoSocialActivity)rootActivity);
    }

    public void testGetActivity() throws Exception {
        this.startSessionAs("root");
        Space space = this.getSpaceInstance(1, "root");
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName());
        ExoSocialActivityImpl rootActivity = new ExoSocialActivityImpl();
        rootActivity.setTitle("root activity");
        rootActivity.setPosterId(this.rootIdentity.getId());
        rootActivity.setUserId(this.rootIdentity.getId());
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)rootActivity);
        this.restartTransaction();
        rootActivity = this.activityManager.getActivity(rootActivity.getId());
        ContainerResponse response = this.service("GET", this.getURLResource("activities/" + rootActivity.getId() + "?expand="), "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        Object responseEtag = response.getHttpHeaders().getFirst((Object)"etag");
        ActivityRestResourcesTest.assertNotNull((Object)responseEtag);
        DataEntity dataEntityActivity = (DataEntity)response.getEntity();
        ActivityRestResourcesTest.assertNotNull((Object)dataEntityActivity);
        ActivityRestResourcesTest.assertEquals((Object)rootActivity.getId(), (Object)dataEntityActivity.get((Object)"id"));
        ActivityRestResourcesTest.assertEquals((Object)rootActivity.getTitle(), (Object)dataEntityActivity.get((Object)"title"));
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("if-none-match", Collections.singletonList(responseEtag.toString()));
        response = this.service("GET", this.getURLResource("activities/" + rootActivity.getId() + "?expand="), "", headers, null, (ContainerResponseWriter)new DummyContainerResponseWriter());
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)304, (int)response.getStatus());
        this.rootIdentity.getProfile().setProperty("test", (Object)"test");
        this.identityManager.updateProfile(this.rootIdentity.getProfile());
        response = this.service("GET", this.getURLResource("activities/" + rootActivity.getId() + "?expand="), "", headers, null, (ContainerResponseWriter)new DummyContainerResponseWriter());
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        responseEtag = response.getHttpHeaders().getFirst((Object)"etag");
        ActivityRestResourcesTest.assertNotNull((Object)responseEtag);
        headers.put("if-none-match", Collections.singletonList(responseEtag.toString()));
        response = this.service("GET", this.getURLResource("activities/" + rootActivity.getId() + "?expand="), "", headers, null, (ContainerResponseWriter)new DummyContainerResponseWriter());
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)304, (int)response.getStatus());
        this.spaceService.renameSpace(space, "New Display Name");
        response = this.service("GET", this.getURLResource("activities/" + rootActivity.getId() + "?expand="), "", headers, null, (ContainerResponseWriter)new DummyContainerResponseWriter());
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        this.activityManager.deleteActivity((ExoSocialActivity)rootActivity);
    }

    public void testGetActivitiesSpaceById() throws Exception {
        Space space = this.getSpaceInstance(1, "root");
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName());
        for (int i = 0; i < 5; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setTitle("title " + i);
            activity.setUserId(this.rootIdentity.getId());
            this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        }
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("activities?spaceId=" + space.getId()), "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity activitiesCollections = (CollectionEntity)response.getEntity();
        ActivityRestResourcesTest.assertEquals((int)6, (int)activitiesCollections.getEntities().size());
        String input = "{\"title\":title6}";
        response = this.getResponse("POST", this.getURLResource("activities?spaceId=" + space.getId()), input);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        RealtimeListAccess listAccess = this.activityManager.getActivitiesOfSpaceWithListAccess(spaceIdentity);
        ActivityRestResourcesTest.assertEquals((int)7, (int)listAccess.getSize());
        ExoSocialActivity activity = ((ExoSocialActivity[])listAccess.load(0, 10))[0];
        ActivityRestResourcesTest.assertEquals((String)"title6", (String)activity.getTitle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetSpaceActivity() throws Exception {
        this.startSessionAs("root");
        Space space = this.getSpaceInstance("test", "root");
        this.testSpaceIdentity = new Identity("space", "test");
        this.identityStorage.saveIdentity(this.testSpaceIdentity);
        try {
            ExoSocialActivityImpl testSpaceActivity = new ExoSocialActivityImpl();
            testSpaceActivity.setTitle("Test space activity");
            this.activityManager.saveActivityNoReturn(this.testSpaceIdentity, (ExoSocialActivity)testSpaceActivity);
            this.restartTransaction();
            ActivityRestResourcesTest.assertNotNull((Object)this.testSpaceIdentity.getId());
            ContainerResponse response = this.service("GET", "/v1/social/activities/" + testSpaceActivity.getId(), "", null, null);
            ActivityRestResourcesTest.assertNotNull((Object)response);
            ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
            ActivityEntity activityEntity = this.getBaseEntity((DataEntity)response.getEntity(), ActivityEntity.class);
            ActivityRestResourcesTest.assertNotNull((Object)activityEntity);
            ActivityRestResourcesTest.assertNotNull((Object)activityEntity.getOwner());
            ActivityRestResourcesTest.assertTrue((boolean)activityEntity.getOwner().contains("/social/spaces/" + space.getId()));
            this.restartTransaction();
            ExoSocialActivityImpl testComment = new ExoSocialActivityImpl();
            testComment.setTitle("Test Comment");
            testComment.setUserId(this.rootIdentity.getId());
            testComment.setPosterId(this.rootIdentity.getId());
            this.activityManager.saveComment((ExoSocialActivity)testSpaceActivity, (ExoSocialActivity)testComment);
            response = this.service("GET", "/v1/social/activities/" + testComment.getId(), "", null, null);
            ActivityRestResourcesTest.assertNotNull((Object)response);
            ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
            CommentEntity commentEntity = this.getBaseEntity((DataEntity)response.getEntity(), CommentEntity.class);
            ActivityRestResourcesTest.assertNotNull((Object)commentEntity);
            ActivityRestResourcesTest.assertNotNull((Object)commentEntity.getTitle());
            ActivityRestResourcesTest.assertEquals((String)commentEntity.getTitle(), (String)"Test Comment");
            response = this.service("GET", "/v1/social/activities/" + testSpaceActivity.getId(), "", null, null);
            ActivityRestResourcesTest.assertNotNull((Object)response);
            ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
            this.startSessionAs("John");
            response = this.service("GET", "/v1/social/activities/" + testComment.getId(), "", null, null);
            ActivityRestResourcesTest.assertNotNull((Object)response);
            ActivityRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
            response = this.service("GET", "/v1/social/activities/" + testSpaceActivity.getId(), "", null, null);
            ActivityRestResourcesTest.assertNotNull((Object)response);
            ActivityRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
            this.startSessionAs("root");
            this.activityManager.deleteActivity((ExoSocialActivity)testSpaceActivity);
            response = this.service("GET", "/v1/social/activities/" + testSpaceActivity.getId(), "", null, null);
            ActivityRestResourcesTest.assertNotNull((Object)response);
            ActivityRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
        }
        finally {
            if (space != null) {
                this.spaceService.deleteSpace(space);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetSpaceActivityWithBody() throws Exception {
        this.startSessionAs("root");
        Space space = this.getSpaceInstance("test", "root");
        this.testSpaceIdentity = new Identity("space", "test");
        this.identityStorage.saveIdentity(this.testSpaceIdentity);
        try {
            ExoSocialActivityImpl testSpaceActivity = new ExoSocialActivityImpl();
            testSpaceActivity.setTitle("Test space activity title");
            testSpaceActivity.setBody("test space activity body");
            this.activityManager.saveActivityNoReturn(this.testSpaceIdentity, (ExoSocialActivity)testSpaceActivity);
            ActivityRestResourcesTest.assertNotNull((Object)this.testSpaceIdentity.getId());
            ContainerResponse response = this.service("GET", "/v1/social/activities/" + testSpaceActivity.getId(), "", null, null);
            ActivityRestResourcesTest.assertNotNull((Object)response);
            ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
            ActivityEntity activityEntity = this.getBaseEntity((DataEntity)response.getEntity(), ActivityEntity.class);
            ActivityRestResourcesTest.assertNotNull((Object)activityEntity);
            ActivityRestResourcesTest.assertNotNull((Object)activityEntity.getBody());
            ActivityRestResourcesTest.assertEquals((String)"Test space activity title", (String)activityEntity.getTitle());
            ActivityRestResourcesTest.assertEquals((String)"test space activity body", (String)activityEntity.getBody());
            ActivityRestResourcesTest.assertNotNull((Object)activityEntity.getOwner());
            ActivityRestResourcesTest.assertTrue((boolean)activityEntity.getOwner().contains("/social/spaces/" + space.getId()));
        }
        finally {
            if (space != null) {
                this.spaceService.deleteSpace(space);
            }
        }
    }

    public void testGetActivitiesOfCurrentUser() throws Exception {
        this.startSessionAs("root");
        this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.rootIdentity);
        ExoSocialActivityImpl rootActivity = new ExoSocialActivityImpl();
        rootActivity.setTitle("root activity");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)rootActivity);
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("demo activity");
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        ExoSocialActivityImpl maryActivity = new ExoSocialActivityImpl();
        maryActivity.setTitle("mary activity");
        this.activityManager.saveActivityNoReturn(this.maryIdentity, (ExoSocialActivity)maryActivity);
        ContainerResponse response = this.service("GET", "/v1/social/activities?limit=5&offset=0", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        ActivityRestResourcesTest.assertEquals((int)2, (int)collections.getEntities().size());
        ArrayList<String> activitiesTitle = new ArrayList<String>(2);
        ActivityEntity entity = this.getBaseEntity(collections.getEntities().get(0), ActivityEntity.class);
        activitiesTitle.add(entity.getTitle());
        entity = this.getBaseEntity(collections.getEntities().get(1), ActivityEntity.class);
        activitiesTitle.add(entity.getTitle());
        ActivityRestResourcesTest.assertTrue((boolean)activitiesTitle.contains("root activity"));
        ActivityRestResourcesTest.assertTrue((boolean)activitiesTitle.contains("demo activity"));
    }

    public void testUpdateActivityById() throws Exception {
        this.startSessionAs("root");
        ExoSocialActivityImpl rootActivity = new ExoSocialActivityImpl();
        rootActivity.setTitle("test activity");
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put("WORKSPACE", "collaboration");
        templateParams.put("MESSAGE", "old message");
        templateParams.put("description", "description of the activity");
        templateParams.put("FAKE_PARAM", "fake param");
        rootActivity.setTemplateParams(templateParams);
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)rootActivity);
        ContainerResponse response = this.service("GET", "/v1/social/activities/" + rootActivity.getId(), "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        ActivityEntity result = this.getBaseEntity(response.getEntity(), ActivityEntity.class);
        ActivityRestResourcesTest.assertEquals((String)"test activity", (String)result.getTitle());
        String input = "{\"title\":\"updated title\",\"templateParams\":{\"MESSAGE\":\"updated message\",\"NOT_EXIST_KEY\":\"any value\",\"FAKE_PARAM\":\"-\"}}";
        response = this.getResponse("PUT", "/v1/social/activities/" + rootActivity.getId(), input);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        result = this.getBaseEntity(response.getEntity(), ActivityEntity.class);
        ActivityRestResourcesTest.assertEquals((String)"updated title", (String)result.getTitle());
        ActivityRestResourcesTest.assertEquals((Object)"updated message", (Object)result.getTemplateParams().get((Object)"MESSAGE"));
        ActivityRestResourcesTest.assertEquals((Object)"collaboration", (Object)result.getTemplateParams().get((Object)"WORKSPACE"));
        ActivityRestResourcesTest.assertTrue((boolean)result.getTemplateParams().containsKey((Object)"NOT_EXIST_KEY"));
        ActivityRestResourcesTest.assertFalse((boolean)result.getTemplateParams().containsKey((Object)"FAKE_PARAM"));
        ActivityRestResourcesTest.assertEquals((int)4, (int)result.getTemplateParams().size());
    }

    public void testHideActivityById() throws Exception {
        this.startSessionAs("root");
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("test activity");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        RealtimeListAccess activities = this.activityManager.getActivityFeedWithListAccess(this.rootIdentity);
        ActivityRestResourcesTest.assertEquals((int)1, (int)activities.getSize());
        ContainerResponse response = this.service("DELETE", "/v1/social/activities/" + activity.getId() + "?hide=true", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        ActivityEntity result = this.getBaseEntity(response.getEntity(), ActivityEntity.class);
        ActivityRestResourcesTest.assertEquals((String)"test activity", (String)result.getTitle());
        activities = this.activityManager.getActivityFeedWithListAccess(this.rootIdentity);
        ActivityRestResourcesTest.assertEquals((int)0, (int)activities.getSize());
        activity = this.activityManager.getActivity(activity.getId());
        ActivityRestResourcesTest.assertNotNull((String)"Should be able to access activity even when hidden", (Object)activity);
    }

    public void testGetUpdatedDeletedActivityById() throws Exception {
        this.startSessionAs("root");
        this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.rootIdentity);
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("demo activity");
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        ContainerResponse response = this.service("GET", "/v1/social/activities/" + demoActivity.getId(), "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        ActivityEntity result = this.getBaseEntity(response.getEntity(), ActivityEntity.class);
        ActivityRestResourcesTest.assertEquals((String)result.getTitle(), (String)"demo activity");
        String input = "{\"title\":updated}";
        response = this.getResponse("PUT", "/v1/social/activities/" + demoActivity.getId(), input);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
        this.startSessionAs("demo");
        response = this.getResponse("PUT", "/v1/social/activities/" + demoActivity.getId(), input);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        result = this.getBaseEntity(response.getEntity(), ActivityEntity.class);
        ActivityRestResourcesTest.assertEquals((String)result.getTitle(), (String)"updated");
        response = this.service("DELETE", "/v1/social/activities/" + demoActivity.getId(), "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        ActivityRestResourcesTest.assertNull((Object)this.activityManager.getActivity(demoActivity.getId()));
    }

    public void testGetComments() throws Exception {
        this.startSessionAs("root");
        int nbComments = 5;
        ExoSocialActivityImpl rootActivity = new ExoSocialActivityImpl();
        rootActivity.setTitle("root activity");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)rootActivity);
        for (int i = 0; i < nbComments; ++i) {
            ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
            comment.setTitle("comment " + i);
            comment.setUserId(this.rootIdentity.getId());
            this.activityManager.saveComment((ExoSocialActivity)rootActivity, (ExoSocialActivity)comment);
        }
        ContainerResponse response = this.service("GET", "/v1/social/activities/" + rootActivity.getId() + "/comments?sortDescending=false", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        ActivityRestResourcesTest.assertEquals((int)5, (int)collections.getEntities().size());
        this.startSessionAs("demo");
        response = this.service("GET", "/v1/social/activities/" + rootActivity.getId() + "/comments", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
        this.relationshipManager.inviteToConnect(this.demoIdentity, this.rootIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        response = this.service("GET", "/v1/social/activities/" + rootActivity.getId() + "/comments", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        ActivityRestResourcesTest.assertEquals((int)5, (int)collections.getEntities().size());
        response = this.service("GET", "/v1/social/activities/" + rootActivity.getId() + "/comments?sortDescending=true", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        ActivityRestResourcesTest.assertEquals((int)5, (int)collections.getEntities().size());
        for (int i = 0; i < nbComments; ++i) {
            ActivityRestResourcesTest.assertEquals((Object)("comment " + (4 - i)), (Object)((DataEntity)collections.getEntities().get(i)).get((Object)"title"));
        }
        this.activityManager.deleteActivity((ExoSocialActivity)rootActivity);
    }

    public void testGetCommentsWithReplies() throws Exception {
        this.startSessionAs("root");
        int nbComments = 5;
        int nbReplies = 5;
        ExoSocialActivityImpl rootActivity = new ExoSocialActivityImpl();
        rootActivity.setTitle("root activity");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)rootActivity);
        for (int i = 0; i < nbComments; ++i) {
            ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
            comment.setTitle("comment " + i);
            comment.setUserId(this.rootIdentity.getId());
            this.activityManager.saveComment((ExoSocialActivity)rootActivity, (ExoSocialActivity)comment);
            for (int j = 0; j < nbReplies; ++j) {
                ExoSocialActivityImpl commentReply = new ExoSocialActivityImpl();
                commentReply.setTitle("comment reply " + i + " - " + j);
                commentReply.setUserId(this.maryIdentity.getId());
                commentReply.setParentCommentId(comment.getId());
                this.activityManager.saveComment((ExoSocialActivity)rootActivity, (ExoSocialActivity)commentReply);
            }
        }
        ContainerResponse response = this.service("GET", "/v1/social/activities/" + rootActivity.getId() + "/comments", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        ActivityRestResourcesTest.assertEquals((int)5, (int)collections.getEntities().size());
        response = this.service("GET", "/v1/social/activities/" + rootActivity.getId() + "/comments?expand=subComments", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        ActivityRestResourcesTest.assertEquals((int)(nbComments + nbComments * nbReplies), (int)collections.getEntities().size());
        this.startSessionAs("demo");
        response = this.service("GET", "/v1/social/activities/" + rootActivity.getId() + "/comments", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
        this.relationshipManager.inviteToConnect(this.demoIdentity, this.rootIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        response = this.service("GET", "/v1/social/activities/" + rootActivity.getId() + "/comments", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        ActivityRestResourcesTest.assertEquals((int)5, (int)collections.getEntities().size());
        response = this.service("GET", "/v1/social/activities/" + rootActivity.getId() + "/comments?expand=subComments", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        ActivityRestResourcesTest.assertEquals((int)(nbComments + nbComments * nbReplies), (int)collections.getEntities().size());
        this.activityManager.deleteActivity((ExoSocialActivity)rootActivity);
    }

    public void testPostComment() throws Exception {
        this.startSessionAs("root");
        ExoSocialActivityImpl rootActivity = new ExoSocialActivityImpl();
        rootActivity.setTitle("root activity");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)rootActivity);
        String input = "{\"body\":comment1, \"title\":comment1}";
        ContainerResponse response = this.getResponse("POST", "/v1/social/activities/" + rootActivity.getId() + "/comments", input);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CommentEntity result = this.getBaseEntity(response.getEntity(), CommentEntity.class);
        ActivityRestResourcesTest.assertEquals((String)"comment1", (String)result.getTitle());
        ActivityRestResourcesTest.assertEquals((int)1, (int)this.activityManager.getCommentsWithListAccess((ExoSocialActivity)rootActivity).getSize());
        this.activityManager.deleteActivity((ExoSocialActivity)rootActivity);
    }

    public void testUpdateComment() throws Exception {
        this.startSessionAs("root");
        ExoSocialActivityImpl rootActivity = new ExoSocialActivityImpl();
        rootActivity.setTitle("root activity");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)rootActivity);
        Object input = "{\"body\":comment1, \"title\":comment1}";
        ContainerResponse response = this.getResponse("POST", "/v1/social/activities/" + rootActivity.getId() + "/comments", (String)input);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CommentEntity result = this.getBaseEntity(response.getEntity(), CommentEntity.class);
        ActivityRestResourcesTest.assertEquals((String)"comment1", (String)result.getTitle());
        ActivityRestResourcesTest.assertEquals((int)1, (int)this.activityManager.getCommentsWithListAccess((ExoSocialActivity)rootActivity).getSize());
        input = "{\"body\":\"comment2\", \"title\":\"comment2\", \"id\":\"" + result.getId() + "\"}";
        response = this.getResponse("PUT", "/v1/social/activities/" + rootActivity.getId() + "/comments", (String)input);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        result = this.getBaseEntity(response.getEntity(), CommentEntity.class);
        ActivityRestResourcesTest.assertEquals((String)"comment2", (String)result.getTitle());
        ActivityRestResourcesTest.assertEquals((int)1, (int)this.activityManager.getCommentsWithListAccess((ExoSocialActivity)rootActivity).getSize());
        this.activityManager.deleteActivity((ExoSocialActivity)rootActivity);
    }

    public void testShareActivityOnSpaces() throws Exception {
        this.startSessionAs("root");
        this.getSpaceInstance("test", "root");
        this.testSpaceIdentity = new Identity("space", "test");
        this.identityStorage.saveIdentity(this.testSpaceIdentity);
        ExoSocialActivityImpl testSpaceActivity = new ExoSocialActivityImpl();
        testSpaceActivity.setTitle("Test space activity");
        this.activityManager.saveActivityNoReturn(this.testSpaceIdentity, (ExoSocialActivity)testSpaceActivity);
        this.getSpaceInstance("share", "root");
        Identity shareTargetSpaceIdentity = new Identity("space", "share");
        this.identityStorage.saveIdentity(shareTargetSpaceIdentity);
        String input = "{\"title\":\"shared default activity\",\"type\":SHARED_DEFAULT_ACTIVITY,\"targetSpaces\":[\"share\"]}";
        ContainerResponse response = this.getResponse("POST", this.getURLResource("activities/" + testSpaceActivity.getId() + "/share"), input);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        RealtimeListAccess listAccess = this.activityManager.getActivitiesOfSpaceWithListAccess(shareTargetSpaceIdentity);
        ActivityRestResourcesTest.assertEquals((int)2, (int)listAccess.getSize());
        ExoSocialActivity activity = ((ExoSocialActivity[])listAccess.load(0, 10))[0];
        ActivityRestResourcesTest.assertEquals((String)"shared default activity", (String)activity.getTitle());
    }

    public void testGetSharedActivityOnSpaces() throws Exception {
        this.startSessionAs("root");
        Space originalSpace = this.getSpaceInstance("originalSpace", "root", "john");
        this.startSessionAs("john");
        String param1 = "param1";
        String param2 = "param2";
        String value1 = "value1";
        String value2 = "value2";
        String input = "{\"title\":titleOfActivity,\"templateParams\":{\"" + param1 + "\": \"" + value1 + "\",\"" + param2 + "\":\"" + value2 + "\"}}";
        ContainerResponse response = this.getResponse("POST", this.getURLResource("activities?spaceId=" + originalSpace.getId()), input);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        ActivityEntity originalActivity = this.getBaseEntity(response.getEntity(), ActivityEntity.class);
        ActivityRestResourcesTest.assertNotNull((Object)originalActivity);
        ActivityRestResourcesTest.assertNotNull((Object)originalActivity.getActivityStream());
        ActivityRestResourcesTest.assertNotNull((Object)originalActivity.getActivityStream().get((Object)"space"));
        Space targetSpace = this.getSpaceInstance("targetSpace", "mary", "james", "demo");
        String message = "Share activity Message";
        input = "{\"title\":\"" + message + "\",\"type\":SHARED_DEFAULT_ACTIVITY,\"targetSpaces\":[\"" + targetSpace.getPrettyName() + "\"]}";
        response = this.getResponse("POST", this.getURLResource("activities/" + originalActivity.getId() + "/share"), input);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((String)"User john is not member of target space", (int)401, (int)response.getStatus());
        this.spaceService.addMember(targetSpace, "john");
        this.spaceService.addRedactor(targetSpace, "demo");
        response = this.getResponse("POST", this.getURLResource("activities/" + originalActivity.getId() + "/share"), input);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((String)"User john is not redactor of target space", (int)401, (int)response.getStatus());
        this.spaceService.addRedactor(targetSpace, "john");
        response = this.getResponse("POST", this.getURLResource("activities/" + originalActivity.getId() + "/share"), input);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((String)"User john is redactor of target space and member on original space", (int)200, (int)response.getStatus());
        CollectionEntity sharedActivities = (CollectionEntity)response.getEntity();
        ActivityRestResourcesTest.assertNotNull((Object)sharedActivities);
        ActivityRestResourcesTest.assertEquals((int)1, (int)sharedActivities.getEntities().size());
        ActivityEntity sharedActivity = this.getBaseEntity(sharedActivities.getEntities().get(0), ActivityEntity.class);
        ActivityRestResourcesTest.assertNotNull((Object)sharedActivity);
        ActivityRestResourcesTest.assertNotNull((Object)sharedActivity.getId());
        ActivityRestResourcesTest.assertEquals((Object)originalActivity.getId(), (Object)sharedActivity.getTemplateParams().get((Object)"originalActivityId"));
        this.restartTransaction();
        this.startSessionAs("demo");
        response = this.service("GET", "/v1/social/activities/" + sharedActivity.getId() + "?expand=shared", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        sharedActivity = this.getBaseEntity(response.getEntity(), ActivityEntity.class);
        ActivityRestResourcesTest.assertNotNull((Object)sharedActivity);
        ActivityRestResourcesTest.assertNotNull((Object)sharedActivity.getOriginalActivity());
        ActivityRestResourcesTest.assertTrue((!sharedActivity.getTemplateParams().containsKey((Object)param1) ? 1 : 0) != 0);
        ActivityRestResourcesTest.assertTrue((!sharedActivity.getTemplateParams().containsKey((Object)param2) ? 1 : 0) != 0);
        this.restartTransaction();
        this.startSessionAs("john");
        response = this.service("GET", "/v1/social/activities/" + originalActivity.getId() + "?expand=shared", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        originalActivity = this.getBaseEntity(response.getEntity(), ActivityEntity.class);
        ActivityRestResourcesTest.assertNotNull((Object)originalActivity);
        ActivityRestResourcesTest.assertNull((Object)originalActivity.getOriginalActivity());
        ActivityRestResourcesTest.assertNotNull((Object)originalActivity.getShareActions());
        ActivityRestResourcesTest.assertEquals((int)1, (int)originalActivity.getShareActions().size());
    }

    public void testPostCommentReply() throws Exception {
        this.startSessionAs("root");
        ExoSocialActivityImpl rootActivity = new ExoSocialActivityImpl();
        rootActivity.setTitle("root activity");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)rootActivity);
        String input = "{\"body\":\"comment1 body\", \"title\":comment1}";
        ContainerResponse response = this.getResponse("POST", "/v1/social/activities/" + rootActivity.getId() + "/comments", input);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CommentEntity comment = this.getBaseEntity(response.getEntity(), CommentEntity.class);
        ActivityRestResourcesTest.assertEquals((String)"comment1", (String)comment.getTitle());
        ActivityRestResourcesTest.assertEquals((String)"comment1 body", (String)comment.getBody());
        ActivityRestResourcesTest.assertNotNull((Object)comment.getId());
        ActivityRestResourcesTest.assertEquals((int)1, (int)this.activityManager.getCommentsWithListAccess((ExoSocialActivity)rootActivity).getSize());
        String commentReplyInput = "{\"body\":\"comment reply 1 body\", \"title\":\"comment reply 1\", \"parentCommentId\": " + comment.getId() + "}";
        response = this.getResponse("POST", "/v1/social/activities/" + rootActivity.getId() + "/comments", commentReplyInput);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CommentEntity commentReply = this.getBaseEntity(response.getEntity(), CommentEntity.class);
        ActivityRestResourcesTest.assertEquals((String)"comment reply 1", (String)commentReply.getTitle());
        ActivityRestResourcesTest.assertEquals((String)"comment reply 1 body", (String)commentReply.getBody());
        ActivityRestResourcesTest.assertEquals((String)comment.getId(), (String)commentReply.getParentCommentId());
        ActivityRestResourcesTest.assertEquals((int)1, (int)this.activityManager.getCommentsWithListAccess((ExoSocialActivity)rootActivity).getSize());
        ActivityRestResourcesTest.assertEquals((int)1, (int)this.activityManager.getCommentsWithListAccess((ExoSocialActivity)rootActivity, true).getSize());
        ActivityRestResourcesTest.assertEquals((int)2, (int)((ExoSocialActivity[])this.activityManager.getCommentsWithListAccess((ExoSocialActivity)rootActivity, true).load(0, -1)).length);
        this.activityManager.deleteActivity((ExoSocialActivity)rootActivity);
    }

    public void testGetLikes() throws Exception {
        this.startSessionAs("root", true);
        ExoSocialActivityImpl rootActivity = new ExoSocialActivityImpl();
        rootActivity.setTitle("root activity");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)rootActivity);
        ArrayList<String> likerIds = new ArrayList<String>();
        likerIds.add(this.demoIdentity.getId());
        rootActivity.setLikeIdentityIds(likerIds.toArray(new String[likerIds.size()]));
        this.activityManager.updateActivity((ExoSocialActivity)rootActivity);
        ContainerResponse response = this.service("GET", "/v1/social/activities/" + rootActivity.getId() + "/likes", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        ActivityRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        this.activityManager.deleteActivity((ExoSocialActivity)rootActivity);
    }

    public void testPostLike() throws Exception {
        this.startSessionAs("root");
        ExoSocialActivityImpl rootActivity = new ExoSocialActivityImpl();
        rootActivity.setTitle("root activity");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)rootActivity);
        ArrayList<String> likerIds = new ArrayList<String>();
        likerIds.add(this.demoIdentity.getId());
        rootActivity.setLikeIdentityIds(likerIds.toArray(new String[likerIds.size()]));
        this.activityManager.updateActivity((ExoSocialActivity)rootActivity);
        ContainerResponse response = this.service("GET", "/v1/social/activities/" + rootActivity.getId() + "/likes", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        ActivityRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        ArrayList<String> updatedLikes = new ArrayList<String>();
        updatedLikes.add(this.activityManager.getActivity(rootActivity.getId()).getLikeIdentityIds()[0]);
        updatedLikes.add(this.maryIdentity.getId());
        rootActivity.setLikeIdentityIds(updatedLikes.toArray(new String[updatedLikes.size()]));
        this.activityManager.updateActivity((ExoSocialActivity)rootActivity);
        response = this.service("GET", "/v1/social/activities/" + rootActivity.getId() + "/likes", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        ActivityRestResourcesTest.assertEquals((int)2, (int)collections.getEntities().size());
        this.activityManager.deleteActivity((ExoSocialActivity)rootActivity);
    }

    public void testDeleteLike() throws Exception {
        this.startSessionAs("demo");
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("demo activity");
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        ArrayList<String> likerIds = new ArrayList<String>();
        likerIds.add(this.demoIdentity.getId());
        demoActivity.setLikeIdentityIds(likerIds.toArray(new String[likerIds.size()]));
        this.activityManager.updateActivity((ExoSocialActivity)demoActivity);
        ContainerResponse response = this.service("DELETE", "/v1/social/activities/" + demoActivity.getId() + "/likes", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        ActivityRestResourcesTest.assertEquals((int)0, (int)collections.getEntities().size());
        ActivityRestResourcesTest.assertEquals((int)0, (int)collections.getSize());
        this.activityManager.deleteActivity((ExoSocialActivity)demoActivity);
    }

    public void testAddLike() throws Exception {
        this.startSessionAs("demo");
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("demo activity");
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        ContainerResponse response = this.service("POST", "/v1/social/activities/" + demoActivity.getId() + "/likes", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        ActivityRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        ActivityRestResourcesTest.assertEquals((int)1, (int)collections.getSize());
        this.activityManager.deleteActivity((ExoSocialActivity)demoActivity);
    }

    public void testDeleteLikeWhenNoPermissionOnActivity() throws Exception {
        this.startSessionAs("root");
        ExoSocialActivityImpl rootActivity = new ExoSocialActivityImpl();
        rootActivity.setTitle("root activity");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)rootActivity);
        this.startSessionAs("demo");
        ContainerResponse response = this.service("DELETE", "/v1/social/activities/" + rootActivity.getId() + "/likes", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
        DataEntity activityEntity = (DataEntity)response.getEntity();
        ActivityRestResourcesTest.assertNull((Object)activityEntity);
        this.activityManager.deleteActivity((ExoSocialActivity)rootActivity);
    }

    private Space getSpaceInstance(String prettyName, String creator) throws Exception {
        Space space = new Space();
        space.setDisplayName(prettyName);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + prettyName);
        space.setVisibility("private");
        space.setRegistration("validation");
        space.setPriority("2");
        this.spaceService.createSpace(space, creator);
        return space;
    }

    private Space getSpaceInstance(String prettyName, String creator, String ... members) throws Exception {
        Space space = new Space();
        space.setDisplayName(prettyName);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + prettyName);
        space.setVisibility("private");
        space.setRegistration("validation");
        space.setPriority("2");
        space.setMembers(members);
        this.spaceService.createSpace(space, creator);
        return space;
    }

    private Space getSpaceInstance(int number, String creator) throws Exception {
        Space space = new Space();
        space.setDisplayName("space" + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setVisibility("private");
        space.setRegistration("validation");
        space.setPriority("2");
        space = this.spaceService.createSpace(space, creator);
        return space;
    }
}

