/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.GenericContainerRequest;
import org.exoplatform.services.rest.GenericContainerResponse;
import org.exoplatform.services.rest.impl.ContainerRequest;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.impl.InputHeadersMap;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.tools.DummyContainerResponseWriter;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.rest.entity.BaseEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.social.service.test.AbstractServiceTest;
import org.exoplatform.social.service.test.SocialMockHttpServletRequest;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

public abstract class AbstractResourceTest
extends AbstractServiceTest {
    public ContainerResponse getResponse(String method, String restPath, String input) throws Exception {
        byte[] jsonData = (StringUtils.isBlank((CharSequence)input) ? "" : input).getBytes("UTF-8");
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/json");
        h.putSingle((Object)"content-length", (Object)("" + jsonData.length));
        return this.service(method, restPath, "", (MultivaluedMap<String, String>)h, jsonData);
    }

    protected <T extends BaseEntity> T getBaseEntity(Object data, Class<T> clazz) throws Exception {
        BaseEntity entity = (BaseEntity)clazz.newInstance();
        entity.setDataEntity((DataEntity)data);
        return (T)entity;
    }

    protected String getURLResource(String resourceURL) {
        return "/v1/social/" + resourceURL;
    }

    public ContainerResponse service(String method, String requestURI, String baseURI, Map<String, List<String>> headers, byte[] data, String remoteUser, ContainerResponseWriter writer) throws Exception {
        if (headers == null) {
            headers = new MultivaluedMapImpl();
        }
        ByteArrayInputStream in = null;
        if (data != null) {
            in = new ByteArrayInputStream(data);
        }
        EnvironmentContext envctx = new EnvironmentContext();
        SocialMockHttpServletRequest httpRequest = new SocialMockHttpServletRequest("", in, in != null ? in.available() : 0, method, (Map<String, List<String>>)headers, remoteUser);
        envctx.put(HttpServletRequest.class, (Object)httpRequest);
        EnvironmentContext.setCurrent((EnvironmentContext)envctx);
        ContainerRequest request = new ContainerRequest(method, new URI(requestURI), new URI(baseURI), (InputStream)in, (MultivaluedMap)new InputHeadersMap((Map)headers));
        ContainerResponse response = new ContainerResponse(writer);
        this.requestHandler.handleRequest((GenericContainerRequest)request, (GenericContainerResponse)response);
        return response;
    }

    public ContainerResponse service(String method, String requestURI, String baseURI, MultivaluedMap<String, String> headers, byte[] data) throws Exception {
        return this.service(method, requestURI, baseURI, (Map<String, List<String>>)headers, data, null, (ContainerResponseWriter)new DummyContainerResponseWriter());
    }

    public ContainerResponse service(String method, String requestURI, String baseURI, MultivaluedMap<String, String> headers, byte[] data, String remoteUser) throws Exception {
        return this.service(method, requestURI, baseURI, (Map<String, List<String>>)headers, data, remoteUser, (ContainerResponseWriter)new DummyContainerResponseWriter());
    }

    public ContainerResponse service(String method, String requestURI, String baseURI, Map<String, List<String>> headers, byte[] data, ContainerResponseWriter writer) throws Exception {
        return this.service(method, requestURI, baseURI, headers, data, null, writer);
    }

    public void assertJsonStringEqualsEntity(String jsonString, Object entity) throws JsonException {
        JsonParserImpl jsonParser = new JsonParserImpl();
        JsonDefaultHandler jsonDefaultHandler = new JsonDefaultHandler();
        jsonParser.parse((Reader)new InputStreamReader(new ByteArrayInputStream(jsonString.getBytes())), (JsonHandler)jsonDefaultHandler);
        JsonValue firstJsonValue = jsonDefaultHandler.getJsonObject();
        AbstractResourceTest.assertNotNull((String)"firstJsonValue must not be null", (Object)firstJsonValue);
        JsonValue secondJsonValue = new JsonGeneratorImpl().createJsonObject(entity);
        AbstractResourceTest.assertNotNull((String)"secondJsonValue must not be null", (Object)secondJsonValue);
        AbstractResourceTest.assertEquals((String)firstJsonValue.toString(), (String)secondJsonValue.toString());
    }

    public void assertXmlStringEqualsEntity(String xmlString, Object entity) {
    }

    protected void testAccessResourceAsAnonymous(String method, String resourceUrl, MultivaluedMap<String, String> h, byte[] data) throws Exception {
        this.testStatusCodeOfResource(null, method, resourceUrl, h, data, 401);
    }

    protected void testAccessResourceWithoutPermission(String username, String method, String resourceUrl, byte[] data) throws Exception {
        this.testStatusCodeOfResource(username, method, resourceUrl, null, data, 403);
    }

    protected void testAccessNotFoundResourceWithAuthentication(String username, String method, String resourceUrl, byte[] data) throws Exception {
        this.testStatusCodeOfResource(username, method, resourceUrl, null, data, 404);
    }

    protected void testStatusCodeOfResource(String username, String method, String resourceUrl, MultivaluedMap<String, String> h, byte[] data, int statusCode) throws Exception {
        if (username != null) {
            this.startSessionAs(username);
        } else {
            this.endSession();
        }
        ContainerResponse containerResponse = this.service(method, resourceUrl, "", h, data);
        AbstractResourceTest.assertEquals((String)("The response code of resource(" + resourceUrl + ") is not expected.)"), (int)statusCode, (int)containerResponse.getStatus());
    }

    protected void compareActivity(ExoSocialActivity activity, HashMap<String, Object> entity) {
        AbstractResourceTest.assertNotNull((String)"entity must not be null", entity);
        AbstractResourceTest.assertEquals((String)"activity.getId() must equal:", (Object)activity.getId(), (Object)entity.get("id"));
        AbstractResourceTest.assertEquals((String)("activity.getTitle() must equal: " + activity.getTitle() == null ? "" : activity.getTitle()), (Object)(activity.getTitle() == null ? "" : activity.getTitle()), (Object)entity.get("title"));
        AbstractResourceTest.assertEquals((String)("entity.getAppId() must equal: " + activity.getAppId() == null ? "" : activity.getAppId()), (Object)(activity.getAppId() == null ? "" : activity.getAppId()), (Object)entity.get("appId"));
        AbstractResourceTest.assertEquals((String)("activity.getType() must equal: " + activity.getType() == null ? "" : activity.getType()), (Object)(activity.getType() == null ? "" : activity.getType()), (Object)entity.get("type"));
        AbstractResourceTest.assertEquals((float)("entity.PostedTime() must equal: " + activity.getPostedTime() == null ? 0.0f : (float)activity.getPostedTime().longValue()), (float)(activity.getPostedTime() == null ? 0.0f : (float)activity.getPostedTime().longValue()), (float)((Long)entity.get("postedTime")).longValue());
        AbstractResourceTest.assertTrue(((Long)entity.get("lastUpdated") > 0L ? 1 : 0) != 0);
        AbstractResourceTest.assertNotNull((String)"entity.get(\"createdAt\"): ", (Object)entity.get("createdAt"));
        Float expectedPriority = activity.getPriority() == null ? new Float(0.0f) : activity.getPriority();
        AbstractResourceTest.assertEquals((String)"activity.getPriority() must equal:", (Object)expectedPriority, (Object)entity.get("priority"));
        AbstractResourceTest.assertEquals(activity.getTemplateParams() == null ? new HashMap() : activity.getTemplateParams(), (Object)entity.get("templateParams"));
        AbstractResourceTest.assertEquals((String)("activity.getTitleId() must return: " + activity.getTitleId() == null ? "" : activity.getTitleId()), (Object)(activity.getTitleId() == null ? "" : activity.getTitleId()), (Object)entity.get("titleId"));
        Identity streamOwnerIdentity = Util.getOwnerIdentityIdFromActivity((ExoSocialActivity)activity);
        AbstractResourceTest.assertEquals((String)("activity.getIdentityId() must return: " + streamOwnerIdentity.getId() == null ? "" : streamOwnerIdentity.getId()), (Object)(streamOwnerIdentity.getId() == null ? "" : streamOwnerIdentity.getId()), (Object)entity.get("identityId"));
        AbstractResourceTest.assertEquals((String)"TotalNumberOfComments must be equal:", (Object)Util.getActivityManager().getCommentsWithListAccess(activity).getSize(), (Object)entity.get("totalNumberOfComments"));
    }

    protected void compareActivityStream(ActivityStream activityStream, HashMap<String, Object> entity) {
        AbstractResourceTest.assertNotNull((String)"entity must not be null", entity);
        AbstractResourceTest.assertEquals((String)("activityStream.getPrettyId() must equal: " + activityStream.getPrettyId() == null ? "" : activityStream.getPrettyId()), (Object)(activityStream.getPrettyId() == null ? "" : activityStream.getPrettyId()), (Object)entity.get("prettyId"));
        AbstractResourceTest.assertEquals((String)("activityStream.getFaviconUrl() must equal: " + activityStream.getFaviconUrl() == null ? "" : activityStream.getPrettyId()), (Object)(activityStream.getFaviconUrl() == null ? "" : activityStream.getFaviconUrl()), (Object)entity.get("faviconUrl"));
        AbstractResourceTest.assertEquals((String)("activityStream.getTitle() must equal: " + activityStream.getTitle() == null ? "" : activityStream.getTitle()), (Object)(activityStream.getTitle() == null ? "" : activityStream.getTitle()), (Object)entity.get("title"));
        AbstractResourceTest.assertEquals((String)("activityStream.getPermaLink() must equal: " + activityStream.getPermaLink() == null ? "" : Util.getBaseUrl() + activityStream.getPermaLink()), (Object)(activityStream.getPermaLink() == null ? "" : Util.getBaseUrl() + activityStream.getPermaLink()), (Object)entity.get("permaLink"));
    }

    protected void compareIdentity(Identity identity, HashMap<String, Object> entity) {
        AbstractResourceTest.assertNotNull((String)"entity must not be null", entity);
        AbstractResourceTest.assertEquals((String)("identity.Id() must equal: " + identity.getId() == null ? "" : identity.getId()), (Object)(identity.getId() == null ? "" : identity.getId()), (Object)entity.get("id"));
        AbstractResourceTest.assertEquals((String)("identity.getProviderId() must equal: " + identity.getProviderId() == null ? "" : identity.getProviderId()), (Object)(identity.getProviderId() == null ? "" : identity.getProviderId()), (Object)entity.get("providerId"));
        AbstractResourceTest.assertEquals((String)("identity.getRemoteId() must equal: " + identity.getRemoteId() == null ? "" : identity.getRemoteId()), (Object)(identity.getRemoteId() == null ? "" : identity.getRemoteId()), (Object)entity.get("remoteId"));
        HashMap profileEntity = (HashMap)entity.get("profile");
        this.compareProfile(identity.getProfile(), profileEntity);
    }

    protected void compareProfile(Profile profile, HashMap<String, Object> entity) {
        AbstractResourceTest.assertNotNull((String)"entity must not be null", entity);
        AbstractResourceTest.assertEquals((String)("profile.getPrettyId() must equal: " + profile.getFullName() == null ? "" : profile.getFullName()), (Object)(profile.getFullName() == null ? "" : profile.getFullName()), (Object)entity.get("fullName"));
        AbstractResourceTest.assertTrue((String)("profile.getAvatarUrl() must be start with \"http\" " + profile.getAvatarUrl() == null ? "" : profile.getAvatarUrl()), (boolean)((String)entity.get("avatarUrl")).startsWith("http"));
    }

    protected void compareComment(ExoSocialActivity activity, HashMap<String, Object> entity) {
        AbstractResourceTest.assertNotNull((String)"entity must not be null", entity);
        AbstractResourceTest.assertEquals((String)("activity.getId() must be equal:" + activity.getId() == null ? "" : activity.getId()), (Object)(activity.getId() == null ? "" : activity.getId()), (Object)entity.get("id"));
        Identity posterIdentity = Util.getOwnerIdentityIdFromActivity((ExoSocialActivity)activity);
        this.compareIdentity(posterIdentity, (HashMap)entity.get("posterIdentity"));
        AbstractResourceTest.assertEquals((String)("activity.getId() must be equal:" + activity.getTitle() == null ? "" : activity.getTitle()), (Object)(activity.getTitle() == null ? "" : activity.getTitle()), (Object)entity.get("text"));
        AbstractResourceTest.assertEquals((float)("activity.getId() must be equal:" + activity.getPostedTime() == null ? 0.0f : (float)activity.getPostedTime().longValue()), (float)(activity.getPostedTime() == null ? 0.0f : (float)activity.getPostedTime().longValue()), (float)((Long)entity.get("postedTime")).longValue());
    }

    protected String toJsonString(Object object) {
        try {
            if (object instanceof Collection) {
                return new JsonGeneratorImpl().createJsonArray((Collection)object).toString();
            }
            return new JsonGeneratorImpl().createJsonObject(object).toString();
        }
        catch (JsonException e) {
            throw new IllegalStateException("Error parsing object to string " + object, e);
        }
    }
}

