/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlRootElement;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.service.rest.Util;

@Path(value="social/apps")
public class AppsRestService
implements ResourceContainer {
    private ApplicationRegistryService _applicationRegistryService;

    @GET
    @Path(value="show.{format}")
    public Response showApps(@Context UriInfo uriInfo, @PathParam(value="format") String format) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        AppList appList = this.showApps();
        return Util.getResponse(appList, uriInfo, mediaType, Response.Status.OK);
    }

    private AppList showApps() {
        AppList appList = new AppList();
        ApplicationRegistryService applicationRegistryService = this.getApplicationRegistryService();
        try {
            List applicationCategoryList = applicationRegistryService.getApplicationCategories("root", new ApplicationType[0]);
            for (ApplicationCategory applicationCategory : applicationCategoryList) {
                ApplicationType portletType = ApplicationType.PORTLET;
                List applications = applicationRegistryService.getApplications(applicationCategory, new ApplicationType[]{portletType});
                Iterator applicationItr = applications.iterator();
                while (applicationItr.hasNext()) {
                    App app = new App();
                    Application application = (Application)applicationItr.next();
                    app.setAppId(application.getId());
                    app.setAppName(application.getDisplayName());
                    appList.addApp(app);
                }
            }
        }
        catch (Exception ex) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        return appList;
    }

    private ApplicationRegistryService getApplicationRegistryService() {
        if (this._applicationRegistryService == null) {
            PortalContainer portalContainer = PortalContainer.getInstance();
            this._applicationRegistryService = (ApplicationRegistryService)portalContainer.getComponentInstanceOfType(ApplicationRegistryService.class);
        }
        return this._applicationRegistryService;
    }

    @XmlRootElement
    public static class AppList {
        private List<App> _apps;

        public void setApps(List<App> apps) {
            this._apps = apps;
        }

        public List<App> getApps() {
            return this._apps;
        }

        public void addApp(App app) {
            if (this._apps == null) {
                this._apps = new ArrayList<App>();
            }
            this._apps.add(app);
        }
    }

    public static class App {
        private String _appId;
        private String _appName;

        public void setAppId(String appId) {
            this._appId = appId;
        }

        public String getAppId() {
            return this._appId;
        }

        public void setAppName(String appName) {
            this._appName = appName;
        }

        public String getAppName() {
            return this._appName;
        }
    }
}

