/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.relationship;

import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.RelationshipEntity;
import org.exoplatform.social.rest.impl.relationship.RelationshipsRestResourcesV1;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class RelationshipsRestResourcesTest
extends AbstractResourceTest {
    private IdentityManager identityManager;
    private RelationshipManager relationshipManager;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity demoIdentity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("gatein.email.domain.url", "localhost:8080");
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.relationshipManager = (RelationshipManager)this.getContainer().getComponentInstanceOfType(RelationshipManager.class);
        this.rootIdentity = new Identity("organization", "root");
        this.johnIdentity = new Identity("organization", "john");
        this.maryIdentity = new Identity("organization", "mary");
        this.demoIdentity = new Identity("organization", "demo");
        this.identityManager.saveIdentity(this.rootIdentity);
        this.identityManager.saveIdentity(this.johnIdentity);
        this.identityManager.saveIdentity(this.maryIdentity);
        this.identityManager.saveIdentity(this.demoIdentity);
        this.addResource(RelationshipsRestResourcesV1.class, null);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource(RelationshipsRestResourcesV1.class);
    }

    public void testGetRelationships() throws Exception {
        Relationship relationship1 = new Relationship(this.rootIdentity, this.demoIdentity, Relationship.Type.CONFIRMED);
        this.relationshipManager.update(relationship1);
        Relationship relationship2 = new Relationship(this.rootIdentity, this.johnIdentity, Relationship.Type.PENDING);
        this.relationshipManager.update(relationship2);
        Relationship relationship3 = new Relationship(this.rootIdentity, this.maryIdentity, Relationship.Type.CONFIRMED);
        this.relationshipManager.update(relationship3);
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", "/v1/social/relationships", "", null, null);
        RelationshipsRestResourcesTest.assertNotNull((Object)response);
        RelationshipsRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        List relationships = collections.getEntities();
        RelationshipsRestResourcesTest.assertEquals((int)3, (int)relationships.size());
        List relationshipsIds = relationships.stream().map(relationship -> relationship.get((Object)"id")).collect(Collectors.toList());
        RelationshipsRestResourcesTest.assertTrue((boolean)relationshipsIds.contains(relationship1.getId()));
        RelationshipsRestResourcesTest.assertTrue((boolean)relationshipsIds.contains(relationship2.getId()));
        RelationshipsRestResourcesTest.assertTrue((boolean)relationshipsIds.contains(relationship3.getId()));
    }

    public void testCreateRelationship() throws Exception {
        this.startSessionAs("root");
        String input = "{\"sender\":\"root\", \"receiver\":\"demo\", \"status\":\"CONFIRMED\"}";
        ContainerResponse response = this.getResponse("POST", "/v1/social/relationships/", input);
        RelationshipsRestResourcesTest.assertNotNull((Object)response);
        RelationshipsRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        RelationshipEntity result = this.getBaseEntity(response.getEntity(), RelationshipEntity.class);
        RelationshipsRestResourcesTest.assertEquals((String)"/portal/rest/v1/social/users/root", (String)result.getSender());
        RelationshipsRestResourcesTest.assertEquals((String)"/portal/rest/v1/social/users/demo", (String)result.getReceiver());
        RelationshipsRestResourcesTest.assertEquals((String)"CONFIRMED", (String)result.getStatus());
        Relationship relationship = this.relationshipManager.get(result.getId());
        RelationshipsRestResourcesTest.assertNotNull((Object)relationship);
        RelationshipsRestResourcesTest.assertEquals((String)"root", (String)relationship.getSender().getRemoteId());
        RelationshipsRestResourcesTest.assertEquals((String)"demo", (String)relationship.getReceiver().getRemoteId());
        RelationshipsRestResourcesTest.assertEquals((String)"CONFIRMED", (String)relationship.getStatus().name());
    }

    public void testGetRelationshipById() throws Exception {
        Relationship relationship = new Relationship(this.rootIdentity, this.demoIdentity, Relationship.Type.CONFIRMED);
        this.relationshipManager.update(relationship);
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", "/v1/social/relationships/" + relationship.getId(), "", null, null);
        RelationshipsRestResourcesTest.assertNotNull((Object)response);
        RelationshipsRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        RelationshipEntity result = this.getBaseEntity(response.getEntity(), RelationshipEntity.class);
        RelationshipsRestResourcesTest.assertEquals((String)"CONFIRMED", (String)result.getStatus());
    }

    public void testDeleteRelationshipById() throws Exception {
        Relationship relationship = new Relationship(this.rootIdentity, this.demoIdentity, Relationship.Type.CONFIRMED);
        this.relationshipManager.update(relationship);
        this.startSessionAs("root");
        ContainerResponse response = this.service("DELETE", "/v1/social/relationships/" + relationship.getId(), "", null, null);
        RelationshipsRestResourcesTest.assertNotNull((Object)response);
        RelationshipsRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        RelationshipEntity entity = this.getBaseEntity(response.getEntity(), RelationshipEntity.class);
        relationship = this.relationshipManager.get(entity.getId());
        RelationshipsRestResourcesTest.assertNull((Object)relationship);
    }
}

