/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.entity;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.DataEntity;
import org.json.JSONObject;

public class CollectionEntity
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 5157400162426650346L;
    private final String key;

    public CollectionEntity(List<? extends DataEntity> entities, String key, int offset, int limit) {
        this.put(key, entities);
        this.put("offset", offset);
        this.put("limit", limit);
        this.key = key;
    }

    public int getSize() {
        Integer size = (Integer)this.get("size");
        return size == null ? -1 : size;
    }

    public void setSize(int size) {
        this.put("size", size);
    }

    public int getLimit() {
        return (Integer)this.get("limit");
    }

    public void setLimit(int limit) {
        this.put("limit", limit);
    }

    public int getOffset() {
        return (Integer)this.get("offset");
    }

    public void setOffset(int offset) {
        this.put("offset", offset);
    }

    public List<? extends DataEntity> getEntities() {
        for (Map.Entry entry : this.entrySet()) {
            if (!(entry.getValue() instanceof List)) continue;
            return (List)entry.getValue();
        }
        return new ArrayList();
    }

    public CollectionEntity extractInfo(List<String> returnedProperties) {
        ArrayList<DataEntity> returnedInfos = new ArrayList<DataEntity>();
        for (DataEntity dataEntity : this.getEntities()) {
            returnedInfos.add(RestUtils.extractInfo(dataEntity, returnedProperties));
        }
        this.put(this.key, returnedInfos);
        return this;
    }

    @Override
    public String toString() {
        return this.toJSONObject().toString();
    }

    public JSONObject toJSONObject() {
        if (this.getOffset() == 0 && this.getLimit() == 0) {
            return new JSONObject(this.getEntities());
        }
        return new JSONObject((Map)this);
    }
}

