/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.websocket;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.websocket.entity.ActivityStreamModification;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;
import org.picocontainer.Startable;

public class ActivityStreamWebSocketService
implements Startable {
    public static final String COMETD_CHANNEL = "/eXo/Application/ActivityStream";
    private static final Log LOG = ExoLogger.getLogger(ActivityStreamWebSocketService.class);
    private PortalContainer portalContainer;
    private ContinuationService continuationService;
    private EXoContinuationBayeux continuationBayeux;
    private ActivityManager activityManager;
    private RelationshipManager relationshipManager;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private ExecutorService executorService;

    public ActivityStreamWebSocketService(PortalContainer portalContainer, ActivityManager activityManager, IdentityManager identityManager, RelationshipManager relationshipManager, SpaceService spaceService, EXoContinuationBayeux continuationBayeux, ContinuationService continuationService) {
        this.portalContainer = portalContainer;
        this.continuationService = continuationService;
        this.continuationBayeux = continuationBayeux;
        this.activityManager = activityManager;
        this.relationshipManager = relationshipManager;
        this.spaceService = spaceService;
        this.identityManager = identityManager;
    }

    public void start() {
        this.executorService = Executors.newFixedThreadPool(1);
    }

    public void stop() {
        this.executorService.shutdownNow();
    }

    public void sendMessage(ActivityStreamModification activityStreamModification) {
        Set connectedUserIds;
        Space space;
        String message = activityStreamModification.toString();
        String activityId = activityStreamModification.getActivityId();
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null || activity.getActivityStream() == null) {
            this.continuationService.sendBroadcastMessage(COMETD_CHANNEL, (Object)message);
        } else if (activity.getActivityStream().getType() == ActivityStream.Type.USER) {
            this.executorService.execute(() -> {
                RequestLifeCycle.begin((ExoContainer)this.portalContainer);
                ExoContainerContext.setCurrentContainer((ExoContainer)this.portalContainer);
                try {
                    String userId = activity.getActivityStream().getPrettyId();
                    this.continuationService.sendMessage(userId, COMETD_CHANNEL, (Object)message);
                    Identity identity = this.identityManager.getOrCreateUserIdentity(userId);
                    HashSet connectedUserIds = new HashSet(this.continuationBayeux.getConnectedUserIds());
                    connectedUserIds.remove(userId);
                    connectedUserIds.forEach(connectedUserId -> {
                        Identity connectedIdentity = this.identityManager.getOrCreateUserIdentity(connectedUserId);
                        if (this.relationshipManager.getStatus(identity, connectedIdentity) == Relationship.Type.CONFIRMED) {
                            try {
                                this.continuationService.sendMessage(connectedUserId, COMETD_CHANNEL, (Object)message);
                            }
                            catch (Exception e) {
                                LOG.warn("Error sending WebSocket message for activity {} update", new Object[]{activityId, e});
                            }
                        }
                    });
                    this.relationshipManager.getAllWithListAccess(null);
                }
                finally {
                    RequestLifeCycle.end();
                    ExoContainerContext.setCurrentContainer(null);
                }
            });
        } else if (activity.getActivityStream().getType() == ActivityStream.Type.SPACE && (space = this.spaceService.getSpaceByPrettyName(activity.getActivityStream().getPrettyId())) != null && CollectionUtils.isNotEmpty((Collection)(connectedUserIds = this.continuationBayeux.getConnectedUserIds()))) {
            this.executorService.execute(() -> {
                RequestLifeCycle.begin((ExoContainer)this.portalContainer);
                ExoContainerContext.setCurrentContainer((ExoContainer)this.portalContainer);
                try {
                    connectedUserIds.forEach(connectedUserId -> {
                        if (this.spaceService.isMember(space, connectedUserId)) {
                            try {
                                this.continuationService.sendMessage(connectedUserId, COMETD_CHANNEL, (Object)message);
                            }
                            catch (Exception e) {
                                LOG.warn("Error sending WebSocket message for activity {} update", new Object[]{activityId, e});
                            }
                        }
                    });
                }
                finally {
                    RequestLifeCycle.end();
                    ExoContainerContext.setCurrentContainer(null);
                }
            });
        }
    }
}

