/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import org.exoplatform.social.service.rest.LinkShare;
import org.junit.Assert;
import org.junit.Test;

public class LinkShareTest {
    @Test
    public void shouldNotFetchLinkPreviewWhenPreviewIsDisabled() throws Exception {
        String previousPropertyValue = System.getProperty("exo.activity.link.preview.enabled");
        System.setProperty("exo.activity.link.preview.enabled", "false");
        try {
            LinkShare linkShare = LinkShare.getInstance((String)"http://dummy.url.com");
            Assert.assertNotNull((Object)linkShare);
            Assert.assertEquals((Object)"http://dummy.url.com", (Object)linkShare.getLink());
            Assert.assertEquals((Object)"", (Object)linkShare.getDescription());
            Assert.assertNull((Object)linkShare.getMediaObject());
        }
        finally {
            if (previousPropertyValue == null) {
                System.clearProperty("exo.activity.link.preview.enabled");
            } else {
                System.setProperty("exo.activity.link.preview.enabled", previousPropertyValue);
            }
        }
    }

    @Test
    public void shouldFetchLinkPreviewWhenPreviewIsDisabled() throws Exception {
        String previousPropertyValue = System.getProperty("exo.activity.link.preview.enabled");
        System.setProperty("exo.activity.link.preview.enabled", "true");
        try {
            LinkShare linkShare = LinkShare.getInstance((String)"https://www.meeds.io/");
            Assert.assertNotNull((Object)linkShare);
            Assert.assertEquals((Object)"https://www.meeds.io/", (Object)linkShare.getLink());
            Assert.assertNotNull((Object)linkShare.getDescription());
            Assert.assertNotNull((Object)linkShare.getImages());
        }
        finally {
            if (previousPropertyValue == null) {
                System.clearProperty("exo.activity.link.preview.enabled");
            } else {
                System.setProperty("exo.activity.link.preview.enabled", previousPropertyValue);
            }
        }
    }
}

