/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.spacetemplates;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.SpaceTemplate;
import org.exoplatform.social.core.space.spi.SpaceTemplateService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.ErrorResource;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.api.SocialRest;

@Path(value="v1/social/spaceTemplates")
@Tag(name="v1/social/spaceTemplates", description="Managing Spaces Templates")
public class SpaceTemplatesRestResourcesV1
implements SocialRest {
    private static final Log LOG = ExoLogger.getLogger(SpaceTemplatesRestResourcesV1.class);
    private static final CacheControl CACHE_CONTROL = new CacheControl();
    private static final Date DEFAULT_IMAGES_LAST_MODIFED = new Date();
    private static final int CACHE_IN_SECONDS = 31536000;
    private static final int CACHE_IN_MILLI_SECONDS = 1471228928;
    private SpaceTemplateService spaceTemplateService;
    private ConfigurationManager configurationManager;

    public SpaceTemplatesRestResourcesV1(SpaceTemplateService spaceTemplateService, ConfigurationManager configurationManager) {
        this.spaceTemplateService = spaceTemplateService;
        this.configurationManager = configurationManager;
    }

    @GET
    @Path(value="templates")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets all spaces templates", method="GET", description="This returns space templates details")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getAllTemplates(@Context UriInfo uriInfo, @Context HttpServletRequest request) {
        Identity identity = ConversationState.getCurrent().getIdentity();
        String userId = identity.getUserId();
        String lang = request.getLocale() == null ? Locale.ENGLISH.getLanguage() : request.getLocale().getLanguage();
        try {
            List list = this.spaceTemplateService.getLabelledSpaceTemplates(userId, lang);
            return EntityBuilder.getResponse(list, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        }
        catch (Exception e) {
            LOG.error("Cannot get list of templates for user {}, with lang {}", new Object[]{userId, lang, e});
            return EntityBuilder.getResponse(new ErrorResource("Error occurred while getting list of space templates", "space templates permissions not extracted"), uriInfo, RestUtils.getJsonMediaType(), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="{templateName}/banner")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets space template banner", method="GET", description="This returns space template banner input stream")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Resource not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getBannerStream(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Space template name", required=true) @PathParam(value="templateName") String templateName, @Parameter(description="The value of lastModified parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="lastModified") String lastModified) {
        SpaceTemplate spaceTemplate = this.spaceTemplateService.getSpaceTemplateByName(templateName);
        if (spaceTemplate == null) {
            LOG.debug("Cannot find space template: {}", new Object[]{templateName});
            return EntityBuilder.getResponse(new ErrorResource("space template does not exist: " + templateName, "space template not found"), uriInfo, RestUtils.getJsonMediaType(), Response.Status.NOT_FOUND);
        }
        String bannerPath = spaceTemplate.getBannerPath();
        if (StringUtils.isNotBlank((CharSequence)bannerPath)) {
            EntityTag eTag = new EntityTag(Integer.toString(templateName.hashCode()));
            Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
            if (builder == null) {
                InputStream bannerStream = null;
                try {
                    bannerStream = this.configurationManager.getInputStream(bannerPath);
                }
                catch (Exception e) {
                    LOG.warn("Error retrieving banner image of template {}", new Object[]{templateName, e});
                    return EntityBuilder.getResponse(new ErrorResource("inputStream could not be extracted from path: " + bannerPath, "inputStream not extracted"), uriInfo, RestUtils.getJsonMediaType(), Response.Status.INTERNAL_SERVER_ERROR);
                }
                if (bannerStream == null) {
                    throw new WebApplicationException(Response.Status.NOT_FOUND);
                }
                builder = Response.ok((Object)bannerStream, (String)"image/png");
                builder.tag(eTag);
                builder.cacheControl(CACHE_CONTROL);
                builder.lastModified(DEFAULT_IMAGES_LAST_MODIFED);
                builder.expires(new Date(System.currentTimeMillis() + 1471228928L));
            }
            return builder.build();
        }
        return EntityBuilder.getResponse(new ErrorResource("image does not exist in path: " + bannerPath, "banner not found"), uriInfo, RestUtils.getJsonMediaType(), Response.Status.NOT_FOUND);
    }

    static {
        CACHE_CONTROL.setMaxAge(31536000);
    }
}

