/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.util.List;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.SpaceRest;
import org.exoplatform.social.service.rest.SpacesRestService;
import org.exoplatform.social.service.rest.api.models.IdentityNameList;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class SpaceRestServiceTest
extends AbstractResourceTest {
    private static SpaceService spaceService;
    private IdentityManager identityManager;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity demoIdentity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.addResource(SpacesRestService.class, null);
        spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        SpaceRestServiceTest.assertNotNull((Object)this.identityManager);
        this.rootIdentity = this.identityManager.getOrCreateUserIdentity("root");
        this.johnIdentity = this.identityManager.getOrCreateUserIdentity("john");
        this.maryIdentity = this.identityManager.getOrCreateUserIdentity("mary");
        this.demoIdentity = this.identityManager.getOrCreateUserIdentity("demo");
        SpaceRestServiceTest.assertNotNull((Object)this.rootIdentity);
        SpaceRestServiceTest.assertNotNull((Object)this.johnIdentity);
        SpaceRestServiceTest.assertNotNull((Object)this.maryIdentity);
        SpaceRestServiceTest.assertNotNull((Object)this.demoIdentity);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource(SpacesRestService.class);
    }

    private void populateData() throws Exception {
        String apps = "app1:app1:false:installed";
        this.createSpace("space_0", null);
        this.createSpace("space_1", apps);
        this.createSpace("space_2", apps);
        this.createSpace("space_3", apps);
        this.createSpace("space_4", apps);
        this.createSpace("space_5", apps);
        List spaces = spaceService.getLastAccessedSpace("mary", "app1", 0, 5);
        SpaceRestServiceTest.assertEquals((int)5, (int)spaces.size());
    }

    public void testGetSpacesLastVisited() throws Exception {
        this.startSessionAs("mary");
        this.populateData();
        ContainerResponse response = this.service("GET", "/portal/social/spaces/lastVisitedSpace/list.json?appId=app1&limit=5", "", null, null);
        SpaceRestServiceTest.assertEquals((int)200, (int)response.getStatus());
        SpacesRestService.SpaceList list = (SpacesRestService.SpaceList)response.getEntity();
        SpaceRestServiceTest.assertNotNull((Object)list);
        SpaceRestServiceTest.assertEquals((int)5, (int)list.getSpaces().size());
        SpaceRest spaceRest = (SpaceRest)list.getSpaces().get(0);
        SpaceRestServiceTest.assertEquals((String)"space_1", (String)spaceRest.getDisplayName());
        Space space4 = spaceService.getSpaceByPrettyName("space_4");
        SpaceRestServiceTest.assertNotNull((Object)space4);
        spaceService.updateSpaceAccessed("mary", space4);
        List spaces = spaceService.getLastAccessedSpace("mary", "app1", 0, 5);
        SpaceRestServiceTest.assertEquals((int)5, (int)spaces.size());
        Space got = (Space)spaces.get(0);
        SpaceRestServiceTest.assertEquals((String)"space_4", (String)got.getPrettyName());
        response = this.service("GET", "/portal/social/spaces/lastVisitedSpace/list.json?appId=app1&limit=5", "", null, null);
        SpaceRestServiceTest.assertEquals((int)200, (int)response.getStatus());
        SpacesRestService.SpaceList gotList = (SpacesRestService.SpaceList)response.getEntity();
        SpaceRestServiceTest.assertNotNull((Object)gotList);
        List myList = gotList.getSpaces();
        SpaceRest sRest = (SpaceRest)myList.get(0);
        SpaceRestServiceTest.assertEquals((String)"space_4", (String)sRest.getName());
        SpaceRestServiceTest.assertTrue((sRest.getAvatarUrl().length() > 0 ? 1 : 0) != 0);
        Space space2 = spaceService.getSpaceByPrettyName("space_2");
        SpaceRestServiceTest.assertNotNull((Object)space2);
        spaceService.updateSpaceAccessed("mary", space2);
        spaces = spaceService.getLastAccessedSpace("mary", "app1", 0, 5);
        SpaceRestServiceTest.assertEquals((int)5, (int)spaces.size());
        got = (Space)spaces.get(0);
        SpaceRestServiceTest.assertEquals((String)"space_2", (String)got.getPrettyName());
        response = this.service("GET", "/portal/social/spaces/lastVisitedSpace/list.json?appId=app1&limit=5", "", null, null);
        SpaceRestServiceTest.assertEquals((int)200, (int)response.getStatus());
        gotList = (SpacesRestService.SpaceList)response.getEntity();
        SpaceRestServiceTest.assertNotNull((Object)gotList);
        myList = gotList.getSpaces();
        sRest = (SpaceRest)myList.get(0);
        SpaceRestServiceTest.assertEquals((String)"space_2", (String)sRest.getName());
        SpaceRestServiceTest.assertTrue((sRest.getAvatarUrl().length() > 0 ? 1 : 0) != 0);
        this.endSession();
    }

    public void testGetSpacesLastVisitedAppIdNull() throws Exception {
        this.startSessionAs("mary");
        this.populateData();
        ContainerResponse response = this.service("GET", "/portal/social/spaces/lastVisitedSpace/list.json?limit=5", "", null, null);
        SpaceRestServiceTest.assertEquals((int)200, (int)response.getStatus());
        SpacesRestService.SpaceList gotList = (SpacesRestService.SpaceList)response.getEntity();
        SpaceRestServiceTest.assertNotNull((Object)gotList);
        List myList = gotList.getSpaces();
        SpaceRest sRest = (SpaceRest)myList.get(0);
        SpaceRestServiceTest.assertEquals((String)"space_0", (String)sRest.getName());
        Space space4 = spaceService.getSpaceByPrettyName("space_4");
        SpaceRestServiceTest.assertNotNull((Object)space4);
        spaceService.updateSpaceAccessed("mary", space4);
        List spaces = spaceService.getLastAccessedSpace("mary", null, 0, 5);
        SpaceRestServiceTest.assertEquals((int)5, (int)spaces.size());
        Space got = (Space)spaces.get(0);
        SpaceRestServiceTest.assertEquals((String)"space_4", (String)got.getPrettyName());
        this.endSession();
    }

    public void testGetSpaceInfo() throws Exception {
        this.startSessionAs("root");
        Space space = new Space();
        space.setDisplayName("testspace");
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space ");
        space.setType("classic");
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setPriority("2");
        space.setGroupId("/space/" + space.getPrettyName());
        String[] managers = new String[]{"root"};
        String[] members = new String[]{"root", "mary"};
        String[] invitedUsers = new String[]{"john"};
        String[] pendingUsers = new String[]{};
        space.setInvitedUsers(invitedUsers);
        space.setPendingUsers(pendingUsers);
        space.setManagers(managers);
        space.setMembers(members);
        space.setUrl("/space/" + space.getPrettyName());
        spaceService.createSpace(space, "root");
        space = spaceService.getSpaceByPrettyName(space.getPrettyName());
        space.setDisplayName("test1");
        space.setPrettyName("test1");
        space.setEditor("root");
        spaceService.updateSpace(space);
        ContainerResponse response = this.service("GET", "/portal/social/spaces/spaceInfo/?spaceName=testspace", "", null, null);
        SpaceRestServiceTest.assertEquals((int)200, (int)response.getStatus());
        response = this.service("GET", "/portal/social/spaces/spaceInfo/?spaceName=spaceNotExist", "", null, null);
        SpaceRestServiceTest.assertEquals((int)404, (int)response.getStatus());
    }

    public void testSuggestSpacesOfCurrentUser() throws Exception {
        this.startSessionAs("mary");
        this.populateData();
        ContainerResponse response = this.service("GET", "/portal/social/spaces/suggest.json?currentUser=mary&typeOfRelation=confirmed", "", null, null, "mary");
        SpaceRestServiceTest.assertEquals((int)200, (int)response.getStatus());
        IdentityNameList list = (IdentityNameList)response.getEntity();
        SpaceRestServiceTest.assertNotNull((Object)list);
        SpaceRestServiceTest.assertNotNull((Object)list.getOptions());
        SpaceRestServiceTest.assertEquals((int)6, (int)list.getOptions().size());
        this.endSession();
    }

    public void testSuggestSpacesOfNoUser() throws Exception {
        this.startSessionAs("mary");
        this.populateData();
        ContainerResponse response = this.service("GET", "/portal/social/spaces/suggest.json?typeOfRelation=confirmed", "", null, null, "mary");
        SpaceRestServiceTest.assertEquals((int)400, (int)response.getStatus());
        this.endSession();
    }

    public void testSuggestSpacesOfAnotherUser() throws Exception {
        this.startSessionAs("john");
        this.populateData();
        ContainerResponse response = this.service("GET", "/portal/social/spaces/suggest.json?currentUser=mary&typeOfRelation=confirmed", "", null, null, "john");
        SpaceRestServiceTest.assertEquals((int)401, (int)response.getStatus());
        this.endSession();
    }

    private Space createSpace(String name, String apps) throws Exception {
        Space space = new Space();
        space.setDisplayName(name);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + name);
        space.setType("classic");
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setPriority("2");
        space.setGroupId("/space/" + name);
        space.setApp(apps);
        String[] managers = new String[]{"john", "mary"};
        String[] members = new String[]{"john", "mary", "demo"};
        space.setManagers(managers);
        space.setMembers(members);
        space.setUrl(space.getPrettyName());
        space.setAvatarUrl("/profile/my_avatar_" + name);
        spaceService.createSpace(space, "john");
        return space;
    }
}

