/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.social.rest.impl.registry.ApplicationRegistryRest;
import org.exoplatform.social.service.test.AbstractResourceTest;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ApplicationRegistryRestTest
extends AbstractResourceTest {
    private static final String APPLICATIONS_URI = "/applications";
    private static final String APPLICATIONS_CATEGORIES_URI = "/applications/categories";
    private static final String ADMIN_GROUP = "ADMIN_GROUP";
    @Mock
    private ApplicationRegistryService applicationRegistryService;
    @Mock
    private UserACL userAcl;
    @Mock
    private ApplicationCategory category;
    @Mock
    private Application application;

    @Override
    @Before
    public void setUp() throws Exception {
        this.begin();
        super.setUp();
        ApplicationRegistryRest applicationRegistryRest = new ApplicationRegistryRest(this.applicationRegistryService, this.userAcl);
        this.addResource(applicationRegistryRest, null);
        this.startSessionAs("root1");
    }

    @Test
    public void testGetApplications() {
        Mockito.when((Object)this.applicationRegistryService.detectPortletsFromWars()).thenReturn(Collections.singleton(this.category));
        Mockito.when((Object)this.category.getApplications()).thenReturn(Collections.singletonList(this.application));
        Mockito.when((Object)this.userAcl.getAdminGroups()).thenReturn((Object)ADMIN_GROUP);
        Mockito.when((Object)this.userAcl.isUserInGroup(ADMIN_GROUP)).thenReturn((Object)true);
        ContainerResponse response = this.service("GET", APPLICATIONS_URI, "", null, null);
        ApplicationRegistryRestTest.assertNotNull((Object)response);
        ApplicationRegistryRestTest.assertEquals((int)200, (int)response.getStatus());
        List applications = (List)response.getEntity();
        ApplicationRegistryRestTest.assertNotNull((Object)applications);
        ApplicationRegistryRestTest.assertEquals((int)1, (int)applications.size());
        ApplicationRegistryRestTest.assertEquals((Object)this.application, applications.get(0));
    }

    @Test
    public void testGetApplicationsNoPermissions() {
        Mockito.when((Object)this.applicationRegistryService.detectPortletsFromWars()).thenReturn(Collections.singleton(this.category));
        Mockito.when((Object)this.category.getApplications()).thenReturn(Collections.singletonList(this.application));
        ContainerResponse response = this.service("GET", APPLICATIONS_URI, "", null, null);
        ApplicationRegistryRestTest.assertNotNull((Object)response);
        ApplicationRegistryRestTest.assertEquals((int)200, (int)response.getStatus());
        List applications = (List)response.getEntity();
        ApplicationRegistryRestTest.assertNotNull((Object)applications);
        ApplicationRegistryRestTest.assertEquals((int)0, (int)applications.size());
    }

    @Test
    public void testGetApplicationsNotPermitted() {
        Mockito.when((Object)this.applicationRegistryService.detectPortletsFromWars()).thenReturn(Collections.singleton(this.category));
        Mockito.when((Object)this.category.getApplications()).thenReturn(Collections.singletonList(this.application));
        ArrayList<String> permissions = new ArrayList<String>();
        permissions.add(ADMIN_GROUP);
        Mockito.when((Object)this.application.getAccessPermissions()).thenReturn(permissions);
        ContainerResponse response = this.service("GET", APPLICATIONS_URI, "", null, null);
        ApplicationRegistryRestTest.assertNotNull((Object)response);
        ApplicationRegistryRestTest.assertEquals((int)200, (int)response.getStatus());
        List applications = (List)response.getEntity();
        ApplicationRegistryRestTest.assertNotNull((Object)applications);
        ApplicationRegistryRestTest.assertEquals((int)0, (int)applications.size());
    }

    @Test
    public void testGetApplicationsPermitted() {
        Mockito.when((Object)this.applicationRegistryService.detectPortletsFromWars()).thenReturn(Collections.singleton(this.category));
        Mockito.when((Object)this.category.getApplications()).thenReturn(Collections.singletonList(this.application));
        ArrayList<String> permissions = new ArrayList<String>();
        permissions.add(ADMIN_GROUP);
        Mockito.when((Object)this.application.getAccessPermissions()).thenReturn(permissions);
        Mockito.when((Object)this.userAcl.hasPermission((String[])ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<String[]>(){

            public boolean matches(String[] p) {
                return p.length == 1 && StringUtils.equals((CharSequence)p[0], (CharSequence)ApplicationRegistryRestTest.ADMIN_GROUP);
            }
        }))).thenReturn((Object)true);
        ContainerResponse response = this.service("GET", APPLICATIONS_URI, "", null, null);
        ApplicationRegistryRestTest.assertNotNull((Object)response);
        ApplicationRegistryRestTest.assertEquals((int)200, (int)response.getStatus());
        List applications = (List)response.getEntity();
        ApplicationRegistryRestTest.assertNotNull((Object)applications);
        ApplicationRegistryRestTest.assertEquals((int)1, (int)applications.size());
        ApplicationRegistryRestTest.assertEquals((Object)this.application, applications.get(0));
    }

    @Test
    public void testGetApplicationCategories() {
        Mockito.when((Object)this.applicationRegistryService.getApplicationCategories()).thenReturn(Collections.singletonList(this.category));
        Mockito.when((Object)this.userAcl.getAdminGroups()).thenReturn((Object)ADMIN_GROUP);
        Mockito.when((Object)this.userAcl.isUserInGroup(ADMIN_GROUP)).thenReturn((Object)true);
        ContainerResponse response = this.service("GET", APPLICATIONS_CATEGORIES_URI, "", null, null);
        ApplicationRegistryRestTest.assertNotNull((Object)response);
        ApplicationRegistryRestTest.assertEquals((int)200, (int)response.getStatus());
        List categories = (List)response.getEntity();
        ApplicationRegistryRestTest.assertNotNull((Object)categories);
        ApplicationRegistryRestTest.assertEquals((int)1, (int)categories.size());
        ApplicationRegistryRestTest.assertEquals((Object)this.category, categories.get(0));
    }

    @Test
    public void testGetApplicationCategoriesNoPermissions() {
        Mockito.when((Object)this.applicationRegistryService.getApplicationCategories()).thenReturn(Collections.singletonList(this.category));
        ContainerResponse response = this.service("GET", APPLICATIONS_CATEGORIES_URI, "", null, null);
        ApplicationRegistryRestTest.assertNotNull((Object)response);
        ApplicationRegistryRestTest.assertEquals((int)200, (int)response.getStatus());
        List categories = (List)response.getEntity();
        ApplicationRegistryRestTest.assertNotNull((Object)categories);
        ApplicationRegistryRestTest.assertEquals((int)0, (int)categories.size());
    }

    @Test
    public void testGetApplicationCategoriesNotPermitted() {
        Mockito.when((Object)this.applicationRegistryService.getApplicationCategories()).thenReturn(Collections.singletonList(this.category));
        Mockito.when((Object)this.category.getAccessPermissions()).thenReturn(Arrays.asList(ADMIN_GROUP));
        ContainerResponse response = this.service("GET", APPLICATIONS_CATEGORIES_URI, "", null, null);
        ApplicationRegistryRestTest.assertNotNull((Object)response);
        ApplicationRegistryRestTest.assertEquals((int)200, (int)response.getStatus());
        List categories = (List)response.getEntity();
        ApplicationRegistryRestTest.assertNotNull((Object)categories);
        ApplicationRegistryRestTest.assertEquals((int)0, (int)categories.size());
    }

    @Test
    public void testGetApplicationCategoriesPermitted() {
        Mockito.when((Object)this.applicationRegistryService.getApplicationCategories()).thenReturn(Collections.singletonList(this.category));
        Mockito.when((Object)this.category.getAccessPermissions()).thenReturn(Arrays.asList(ADMIN_GROUP));
        Mockito.when((Object)this.userAcl.hasPermission((String[])ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<String[]>(){

            public boolean matches(String[] p) {
                return p.length == 1 && StringUtils.equals((CharSequence)p[0], (CharSequence)ApplicationRegistryRestTest.ADMIN_GROUP);
            }
        }))).thenReturn((Object)true);
        ContainerResponse response = this.service("GET", APPLICATIONS_CATEGORIES_URI, "", null, null);
        ApplicationRegistryRestTest.assertNotNull((Object)response);
        ApplicationRegistryRestTest.assertEquals((int)200, (int)response.getStatus());
        List categories = (List)response.getEntity();
        ApplicationRegistryRestTest.assertNotNull((Object)categories);
        ApplicationRegistryRestTest.assertEquals((int)1, (int)categories.size());
        ApplicationRegistryRestTest.assertEquals((Object)this.category, categories.get(0));
    }
}

