/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.translation.rest;

import io.meeds.social.translation.model.TranslationConfiguration;
import io.meeds.social.translation.plugin.TranslationPlugin;
import io.meeds.social.translation.rest.TranslationRest;
import io.meeds.social.translation.service.TranslationService;
import io.meeds.social.translation.service.TranslationServiceImpl;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class TranslationRestResourcesTest
extends AbstractResourceTest {
    private TranslationRest translationRest;
    private static final String OBJECT_TYPE = "activity";
    private TranslationServiceImpl translationService;
    private LocaleConfigService localeConfigService;
    private String objectType = "activity";
    private long objectId = 322L;
    private long spaceId = 322L;
    private long audienceId = 3L;
    private String fieldName = "title";
    private String username = "john";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.translationService = (TranslationServiceImpl)ExoContainerContext.getService(TranslationServiceImpl.class);
        this.localeConfigService = (LocaleConfigService)ExoContainerContext.getService(LocaleConfigService.class);
        this.translationRest = new TranslationRest((TranslationService)this.translationService, this.localeConfigService);
        this.registry(this.translationRest);
        ExoContainerContext.setCurrentContainer((ExoContainer)this.getContainer());
        this.restartTransaction();
        this.begin();
        System.setProperty("gatein.email.domain.url", "localhost:8080");
    }

    @Override
    protected void tearDown() throws Exception {
        this.translationService.deleteTranslationLabels(this.objectType, this.objectId);
        this.removeTranslationPlugin();
        super.tearDown();
        this.removeResource(this.translationRest.getClass());
    }

    public void testSaveTranslationLabels() throws Exception {
        this.startSessionAs(this.username);
        this.setTranslationPlugin(true, false, this.spaceId, this.audienceId);
        String input = "{\n  \"en\": \"Test Label\",\n  \"FR\": \"Test Label FR\"\n}\n";
        ContainerResponse response = this.getResponse("POST", this.getUrl(), input);
        TranslationRestResourcesTest.assertNotNull((Object)response);
        TranslationRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
        this.setTranslationPlugin(true, true, this.spaceId, this.audienceId);
        response = this.getResponse("POST", this.getUrl(), input);
        TranslationRestResourcesTest.assertNotNull((Object)response);
        TranslationRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
    }

    public void testGetTranslationLabels() throws Exception {
        this.startSessionAs(this.username);
        this.setTranslationPlugin(true, true, this.spaceId, this.audienceId);
        String input = "{\n  \"en\": \"Test Label\",\n  \"FR\": \"Test Label FR\"\n}\n";
        ContainerResponse response = this.getResponse("POST", this.getUrl(), input);
        TranslationRestResourcesTest.assertNotNull((Object)response);
        TranslationRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        this.setTranslationPlugin(false, true, this.spaceId, this.audienceId);
        response = this.getResponse("GET", this.getUrl(), null);
        TranslationRestResourcesTest.assertNotNull((Object)response);
        TranslationRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
        this.setTranslationPlugin(true, true, this.spaceId, this.audienceId);
        response = this.getResponse("GET", this.getUrl(), null);
        TranslationRestResourcesTest.assertNotNull((Object)response);
        TranslationRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        Map responseEntity = (Map)response.getEntity();
        String labelEn = (String)responseEntity.get("en");
        TranslationRestResourcesTest.assertEquals((String)"Test Label", (String)labelEn);
        String labelFr = (String)responseEntity.get("fr");
        TranslationRestResourcesTest.assertEquals((String)"Test Label FR", (String)labelFr);
    }

    public void testGetTranslationConfiguration() throws Exception {
        this.startSessionAs(this.username);
        this.setTranslationPlugin(false, false, this.spaceId, this.audienceId);
        ContainerResponse response = this.getResponse("GET", this.getConfigurationUrl(), null);
        TranslationRestResourcesTest.assertNotNull((Object)response);
        TranslationRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        TranslationConfiguration responseEntity = (TranslationConfiguration)response.getEntity();
        TranslationRestResourcesTest.assertNotNull((Object)responseEntity);
        TranslationRestResourcesTest.assertNotNull((Object)responseEntity.getDefaultLanguage());
        TranslationRestResourcesTest.assertNotNull((Object)responseEntity.getSupportedLanguages());
    }

    public void testSaveDefaultLanguageConfiguration() throws Exception {
        this.startSessionAs(this.username);
        this.setTranslationPlugin(false, false, this.spaceId, this.audienceId);
        ContainerResponse response = this.getResponse("GET", this.getConfigurationUrl(), null);
        TranslationRestResourcesTest.assertNotNull((Object)response);
        TranslationRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        TranslationConfiguration responseEntity = (TranslationConfiguration)response.getEntity();
        TranslationRestResourcesTest.assertNotNull((Object)responseEntity);
        TranslationRestResourcesTest.assertEquals((String)"en", (String)responseEntity.getDefaultLanguage());
        response = this.saveDefaultLocale("fr");
        TranslationRestResourcesTest.assertNotNull((Object)response);
        TranslationRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        response = this.getResponse("GET", this.getConfigurationUrl(), null);
        TranslationRestResourcesTest.assertNotNull((Object)response);
        TranslationRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        responseEntity = (TranslationConfiguration)response.getEntity();
        TranslationRestResourcesTest.assertNotNull((Object)responseEntity);
        TranslationRestResourcesTest.assertEquals((String)"fr", (String)responseEntity.getDefaultLanguage());
        response = this.saveDefaultLocale("");
        TranslationRestResourcesTest.assertNotNull((Object)response);
        TranslationRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        response = this.getResponse("GET", this.getConfigurationUrl(), null);
        responseEntity = (TranslationConfiguration)response.getEntity();
        TranslationRestResourcesTest.assertNotNull((Object)responseEntity);
        TranslationRestResourcesTest.assertEquals((String)"en", (String)responseEntity.getDefaultLanguage());
        response = this.saveDefaultLocale("en");
        TranslationRestResourcesTest.assertNotNull((Object)response);
        TranslationRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        response = this.getResponse("GET", this.getConfigurationUrl(), null);
        responseEntity = (TranslationConfiguration)response.getEntity();
        TranslationRestResourcesTest.assertNotNull((Object)responseEntity);
        TranslationRestResourcesTest.assertEquals((String)"en", (String)responseEntity.getDefaultLanguage());
    }

    private ContainerResponse saveDefaultLocale(String locale) throws UnsupportedEncodingException, Exception {
        byte[] formDataInput = ("lang=" + locale).getBytes("UTF-8");
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/x-www-form-urlencoded");
        h.putSingle((Object)"content-length", (Object)("" + formDataInput.length));
        ContainerResponse response = this.service("PUT", this.getConfigurationUrl() + "/defaultLanguage", "", (MultivaluedMap<String, String>)h, formDataInput);
        return response;
    }

    private String getConfigurationUrl() {
        return "/social/translations/configuration";
    }

    private String getUrl() {
        return "/social/translations/" + this.objectType + "/" + this.objectId + "/" + this.fieldName;
    }

    private void removeTranslationPlugin() {
        this.translationService.removePlugin(OBJECT_TYPE);
    }

    private void setTranslationPlugin(final boolean hasAccessPermission, final boolean hasEditPermission, final long spaceId, final long audienceId) {
        this.removeTranslationPlugin();
        TranslationPlugin translationPlugin = new TranslationPlugin(this){

            public String getObjectType() {
                return TranslationRestResourcesTest.OBJECT_TYPE;
            }

            public boolean hasEditPermission(long objectId, String username) throws ObjectNotFoundException {
                return hasEditPermission;
            }

            public boolean hasAccessPermission(long objectId, String username) throws ObjectNotFoundException {
                return hasAccessPermission;
            }

            public long getSpaceId(long objectId) throws ObjectNotFoundException {
                return spaceId;
            }

            public long getAudienceId(long objectId) throws ObjectNotFoundException {
                return audienceId;
            }
        };
        this.translationService.addPlugin(translationPlugin);
    }

    public void testDeleteTranslationLabels() throws Exception {
        this.startSessionAs(this.username);
        String url = "/social/translations/" + this.objectType + "/" + this.objectId;
        ContainerResponse response = this.getResponse("DELETE", url, null);
        TranslationRestResourcesTest.assertNotNull((Object)response);
        TranslationRestResourcesTest.assertEquals((int)500, (int)response.getStatus());
        this.setTranslationPlugin(true, false, this.spaceId, this.audienceId);
        response = this.getResponse("DELETE", url, null);
        TranslationRestResourcesTest.assertNotNull((Object)response);
        TranslationRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
        this.setTranslationPlugin(true, true, this.spaceId, this.audienceId);
        response = this.getResponse("DELETE", url, null);
        TranslationRestResourcesTest.assertNotNull((Object)response);
        TranslationRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
    }
}

